<?php
/**
 * gpg_sign_functions.php
 * -----------
 * GPG plugin functions as defined by the SquirrelMail-1.2 API.
 * Updated for the SM 1.3/1,4 API
 *
 * Copyright (c) 1999-2003 The SquirrelMail development team
 * Licensed under the GNU GPL. For full terms see the file COPYING.
 *
 * Copyright (c) 2002-2003 Braverock Ventures
 *
 * $Id: gpg_sign_functions.php,v 1.14 2003/04/03 21:46:56 brian Exp $
 *
 */
/*********************************************************************/

/**
 * function gpg_sign_message
 *
 * @param $body, $passphrase, $debug
 * @return $return : An array that contains the cyphertext as well as
 *       warnings and error messages
 *
 * If $passphrase is not passed in then we have to assume either a problem
 * or that the user wants to sign the message with a key that has had the
 * passphrase removed, also known as a signing key. See README.txt
 *
 */
function gpg_sign_message($body,$passphrase,$debug){
  global $trusted_key_id;
  global $gpg_key_file;
  global $gpg_key_dir;
  global $path_to_gpg;

  $username = $_SESSION['username'];

  if ($debug) {
	echo "<br>Global Key Dir: " . $gpg_key_dir;
	echo "<br>Username: $username";
  };

  // check to see if user wants to autosign
  $key_id = 0;
  $auto_sign = getPref ($data_dir, $username, 'no_signing_passwd');
  $use_signing_key_id = getPref ($data_dir, $username, 'use_signing_key_id');

  $no_signing_passwd = getPref ($data_dir, $username, 'no_signing_passwd');

  if ($use_signing_key_id=='true') {
    // grab the keyID to autosign with
    $key_id = getPref ($data_dir, $username, 'signing_key_id');
  }
  if ($debug) {
     echo "<br>Use Signing Feature: $use_signing_key_id";
     echo "<br>Using autosign: $auto_sign";
     echo "<br>Using keyID: $key_id";
  }


  if ($debug) {
	 echo "<br>Original Body Text<br><textarea cols=80 rows=5 name=plaintext>$body</textarea>";
  	 echo '<hr>';
  };

  // clean the body string that is passed in
  // make sure that funny characters get
  // bracketed by single quotes and backslashes
  $body = escapeshellarg ($body);

  /********* gpg_sign_message Command String *********/
  /**
   * Build the command string in pieces, checking for the
   * existance of various preferences, and modifying the
   * command string accordingly
   */
   //set up the base command

   if (($auto_sign=='true') and ($key_id)) {
      if ($debug) {
          echo "<br>Caught auto_sign AND key_id";
      };
      // user has asked to autosign and we have a keyID to use
      $command = "echo $body | $path_to_gpg --batch --no-tty --clearsign --default-key $key_id --homedir $gpg_key_dir 2>&1";
   } else {
      // autosign is not on so we should be expecting a passphrase
      if ($passphrase) {
         if ($debug) {
            echo "<br>Got passphrase";
         };
         //Make sure we escape naughty characters before passing to the shell
         $passphrase = escapeshellarg($passphrase . "\n");
          // we have a passphrase so attempt to sign with phrase
          // and we dont need a default key then

          //build a command without the passphrase incase debug is set so
          // we dont go displaying the passphrase in a debug window
          $pre_pass ="$body | $path_to_gpg --passphrase-fd 0 --batch --no-tty --clearsign --default-key $key_id --homedir $gpg_key_dir 2>&1";
          $command = "echo $passphrase$pre_pass";
      } else {
         // we should reopen the window or check for passphrase with javascript
	     // instead of just throwing an error here
         echo "You did not provide a passphrase! Close this window and try again";
         exit;
      };
   };



  if ($debug) {
     if ($auto_sign=='true') {
	    echo "<hr>Command String: $command<hr>";
     } else {
        echo "<hr>Command String: echo [passphrase stripped for security] $pre_pass<hr>";
     }
  };

  exec($command, $cyphertext, $returnval);

  // make the result a string
  if (is_array($cyphertext)) {
      $cyphertext_str = implode($cyphertext,"\n");
    };

  if ($debug) {
	echo "<br>New body text<br><textarea cols=80 rows=5 name=cyphertext>$cyphertext_str</textarea>";
  	echo "<br> returnvalue= $returnval";
  };

  $sep = '-----BEGIN PGP SIGNED MESSAGE-----';
  list ($front, $cyphertext_tail) = explode ($sep, $cyphertext_str);


  if (!$cyphertext_tail) {
     $unclean = 1;
     $debug = 1;
  }

  $return['cyphertext'] = $cyphertext_str;
  $return['errors'] = array();

  if ($unclean) {
     echo "<hr>";
     foreach ($cyphertext as $line) {
        if ($line == $sep) break;
           $j = substr_count ($line, 'gpg: no default secret key: bad passphrase');
           if ($j) {
              echo 'You probably entered a bad passphrase<br>';
              $return['errors'][] = $line;
              break;
           };
        if ($line == $sep) break;
           $j = substr_count ($line, 'gpg: [stdin]: clearsign failed: bad passphrase');
           if ($j) {
              echo 'You probably entered a bad passphrase<br>';
              $return['errors'][] = $line;
              break;
           };
        if ($line == $sep) break;
           $j = substr_count ($line, 'gpg: protection algorithm 1 (IDEA) is not supported');
           if ($j) {
              echo 'The algorithm on the key you are using to sign is not supported.<br>';
              $return['errors'][] = $line;
              break;
           };
        if ($line == $sep) break;
           $j = substr_count ($line, 'gpg: no default secret key');
           if ($j) {
              echo 'You do not have a default signing key defined.<br>';
              $return['errors'][] = $line;
              break;
           };
     };
  };

  if ($debug) {
        echo "<hr>";
        foreach ($return['errors'] as $error) echo "<br>Error $error";
  };

  if ($unclean) exit;
  return ($return);

};

/**
 *
 * $Log: gpg_sign_functions.php,v $
 * Revision 1.14  2003/04/03 21:46:56  brian
 * Fixed extra } from line 186 by:
 * - moving other code into the proper brackets
 * - removing extra brace
 * - fixing indents so they lined up
 *
 * Revision 1.13  2003/04/03 12:28:03  brian
 * removed superfluous " " . in substr_count lines
 *
 * Revision 1.12  2003/04/03 00:28:07  tyler
 * - converted error handling to the gpg_encrypt_function new method
 *
 * Revision 1.11  2003/04/03 00:04:59  tyler
 * - squashed bug 17, incorrect handling of signing when message being signed already has a signature
 *
 * Revision 1.10  2003/03/31 14:23:37  brian
 * fixed comment typos -non-functional change
 *
 * Revision 1.9  2003/03/20 00:45:36  tyler
 * - First attempt at better error parsing -tyler
 *
 * Revision 1.8  2003/03/14 06:30:01  joelm
 * Discription: Make sure the passphrase has special chars escaped before we put
 * in on the command line.
 *
 * Revision 1.7  2003/03/13 19:48:52  tyler
 * - fixed a bug that put a \n in the wrong spot and thus invalidated some signed messages
 *
 * Revision 1.6  2003/03/13 04:05:49  brian
 * - modified to correctly accept passphrase for message signing
 * - added checks for using the signing feature and
 *   needing passphrase for secret key
 *
 * Revision 1.5  2003/03/12 19:18:05  tyler
 * - fixed a bug with one of the debug sections and added function comments
 *
 * Revision 1.4  2003/03/12 15:45:22  brian
 * added header and footer blocks to file created by tyler
 *
 *
 * Revision 1.1  2003/03/11 tyler
 * initial revision
 *
 */

?>
