<?php
/**
 * gpg_pref_functions.php
 * -----------
 * GPG plugin preference functions file, as defined by the SquirrelMail-1.2 API.
 * Updated for the SM 1.3/1,4 API
 *
 * Copyright (c) 1999-2003 The SquirrelMail development team
 * Licensed under the GNU GPL. For full terms see the file COPYING.
 *
 * Copyright (c) 2002-2003 Braverock Ventures
 *
 * $Id: gpg_pref_functions.php,v 1.2 2003/03/12 15:43:50 brian Exp $
 *
 */

/*********************************************************************/
/**
 * function load_prefs_from_file
 *
 * This function is called on load to set up the system wide options
 *
 * TO GET AT THESE PREFERENCES:
 * $GLOBALS['GPG_SYSTEM_OPTIONS']['key_you_want']
 * or global $GPG_SYSTEM_OPTIONS
 * then $GPG_SYSTEM_OPTIONS['key_you_want']
 *
 * foreach ($GLOBALS['GPG_SYSTEM_OPTIONS'] as $key => $value)
 *     echo "<br>J $key = $value";
 *
 * @param $filename $debug
 * @return
 */

function load_prefs_from_file($filename,$debug) {

  // eventually, add the getHashedFile security checks here
  // $filename=getHashedFile($username, $data_dir, $filename);

  if (file_exists($filename)){
    $fd = fopen ($filename, "r");
    $contents = fread ($fd, filesize ($filename));
    fclose ($fd);
    $lines = explode ("\n", $contents);
    foreach ($lines as $line) {
      eregi("^([[:alnum:]|_]+)=(.*)", $line, $matches);
      $GLOBALS['GPG_SYSTEM_OPTIONS'][$matches[1]] = $matches[2];
      if ($debug) {
        echo "<br>global preferences '$line' gives (", $matches[1], '=', $matches[2], ")";
      };
    };
  } else echo "No GPG prefs could be found";
}

/*********************************************************************/

/**
 *
 * $Log: gpg_pref_functions.php,v $
 * Revision 1.2  2003/03/12 15:43:50  brian
 * added header and footer blocks to file created by tyler
 *
 *
 */

?>
