<?php
/**
 * gpg_functions.php
 * -----------
 * GPG plugin functions file, as defined by the SquirrelMail-1.2 API.
 * Updated for the SM 1.3/1,4 API
 *
 * Copyright (c) 1999-2003 The SquirrelMail development team
 * Licensed under the GNU GPL. For full terms see the file COPYING.
 *
 * Copyright (c) 2002-2003 Braverock Ventures
 *
 * $Id: gpg_functions.php,v 1.47 2003/04/06 23:46:47 brian Exp $
 *
 */
/*********************************************************************/

/**
 * Set a couple of constants and defaults. Don't change these,
 * the configurable stuff is in gpg_config.php
 */
$GPG_DIR='gpg';
$GPG_CRYPTO=TRUE;

/**
 * Load our config file.
 *
 * place all common load files in gpg_config.php
 * as well as checks for 1.2 vs 1.3 or greater
 *
 */
require_once ("gpg_config.php");


/*
 * Let's assume that we get the following from a submit
 *        <INPUT TYPE=text NAME="send_to"
 *        <INPUT TYPE=text NAME="send_to_cc"
 *        <INPUT TYPE=text NAME="send_to_bcc"
 *        <INPUT TYPE=text NAME=subject
 *        <TEXTAREA NAME=body
 *
 */

/* Just for poor wretched souls with E_ALL. :) */
global $data_dir;

/* Load the path to the gpg binary from our preferences */

$path_to_gpg=($GLOBALS['GPG_SYSTEM_OPTIONS']['path_to_gpg']);

/*********************************************************************/

/**
 * function gpg_https_connection
 *
 * This function is caled to check whether the user has an SSL connection
 * Returns 0 for false and 1 for true (SSL)
 *
 * Use whenever you are expecting input from the user (passphrase, etc.)
 *
 * @param ()
 * @return 0/1
 */
 function gpg_https_connection () {
  // does this definitely work on Windows etc?
  if ($_SERVER['HTTPS'])
   return (1);
  else return (0);
}


/*********************************************************************/

/**
 * function gpg_makePage
 *
 * This function is called by all of the module
 * code to render the pges using the Squirrelmail
 * templates, headers, footers, CSS, etc.
 *
 * @param $title,$scriptsrc,$body
 * @return
 */
function gpg_makePage($title, $scriptsrc, $body){
  global $color, $GPG_VERSION;

  if ( !check_php_version(4,1) ) {
      global $_GET;
  }
  //load the correct module for this from the modules directory
  if (isset($_GET['MOD'])) {
    $MOD = $_GET['MOD'];
  }
  else {
    $MOD = "options_main";
  }

  // call the main Squirrelmail page header function
  displayPageHeader($color, 'None');
  echo "&nbsp;<br>\n";
  /**
   * Check if we need to link in a script.
   */
  if($scriptsrc) {
    echo "<script type=\"text/javascript\" src=\"js/$scriptsrc\"></script>\n";
  }
  echo '<table width="95%" align="center" border="0" cellpadding="2" '
    . 'cellspacing="0">'
    . '<tr>'
    . "<td bgcolor=\"$color[9]\" align=center>"
    . "<strong>$title</strong>"
    . '</td>'
    . '</tr>'
    . '<tr><td><hr></td></tr>'
    . "<tr><td>$body</td></tr>";
  /**
   * Generate a nice "Return to Options" link, unless this is the
   * starting page.
   */
  if (($MOD != "options_main") or ($MOD != "encrypt")){
    echo '<tr><td><hr></td></tr>'
      . '<tr><td align="center"><a href="gpg_options.php">'
      . _("Back to &quot;GPG Plugin Options&quot; page")
      . '</a></td></tr>';
  }
  /**
   * Close the table and display the version.
   */
  echo '<tr><td><hr></td></tr>'
    . '<tr>'
    . "<td bgcolor=\"$color[9]\" align=center>"
    . "GPG Plugin $GPG_VERSION"
    . '</td>'
    . '</tr>'
    . '</table>';

};

/*********************************************************************/
/**
 * function gpg_setglobal ($label, $value)
 *
 * This function will set a global variable that we want to be available
 * to Squirrelmail in a fassion that is usable by all of the SM getglobal
 * or other get functions.  Place the variable in _SESSION, _POST, and _GET
 *
 * @param $name $value
 * @return true|false
 */
function gpg_setglobal ($name, $value ) {
	if ( !check_php_version(4,1) ) {
		global $_SESSION, $_GET, $_POST, $_COOKIE, $_SERVER;
	}
	if( isset($_SESSION[$name] ) ) {
		$_SESSION[$name] = $value;
	}
	if( isset($_POST[$name]) ) {
		$_POST[$name] = $value;
	}
	if ( isset($_GET[$name]) ) {
		$_GET[$name] = $value;
	}
	if ( isset($_COOKIE[$name]) ) {
		$_COOKIE[$name] = $value;
	}
	if ( isset($_SERVER[$name]) ) {
		$_SERVER[$name] = $value;
	}

	//should decide what to put in here as debug, if anything
	/* uncomment this if you want lots of marginally useful debug output
	if ($debug) {
	   echo "<br> Setting global variables $name == $value";
	   echo '<br> Session value = '. $_SESSION[$name];
	   echo '<br> POST value = '. $_POST[$name];
	   echo '<br> GET value = '. $_GET[$name];
	   echo '<br> COOKIE value = '. $_COOKIE[$name];
	   echo '<br> SERVER value = '. $_SERVER[$name];
	}
	*/ //end debug
	//under what circumstances would we return false?

}

/*********************************************************************/
/**
 * function gpg_ckMOD($rMOD)
 * This function checks for security attacks. A $MOD variable is
 * provided in the QUERY_STRING and includes one of the files from the
 * modules directory ($MOD.mod). See if someone is trying to get out
 * of the modules directory by providing dots, unicode strings, or
 * slashes.
 *
 * @param  $rMOD the name of the module requested to include.
 * @return       void, since it bails out with an access error if needed.
 */
function gpg_ckMOD($rMOD){
  if (strstr($rMOD, '.')
      || strstr($rMOD, '/')
      || strstr($rMOD, '%')
      || strstr($rMOD, "\\")){
    echo _("Cute.");
    exit;
  }
};

/*********************************************************************/

/**
 * GPG version. Don't modify, since it identifies the format
 * of the user files and messing with this can do ugly
 * stuff. :)
 */
$GPG_VERSION="v1.1";

/*********************************************************************/

/**
 *
 * $Log: gpg_functions.php,v $
 * Revision 1.47  2003/04/06 23:46:47  brian
 * comment out debug in gpg_setglobal by default.  it is too voluminous to be of much use.
 *
 * Revision 1.46  2003/04/06 21:28:00  brian
 * fixed typos in debug
 *
 * Revision 1.45  2003/04/06 21:26:24  brian
 * added debug to gpg_setglobal
 *
 * Revision 1.44  2003/04/06 21:19:25  brian
 * fixed $name, $value mappings
 *
 * Revision 1.43  2003/04/06 20:50:34  brian
 * fixed typo on line 151
 *
 * Revision 1.42  2003/04/06 20:47:47  brian
 * - create gpg_setglobal to get around SM's getglobal function
 * - update gpg_encrypt to use ne gpg_setglobal function
 * Bug 22
 *
 * Revision 1.41  2003/04/01 19:36:28  brian
 * updated GPG_VERSION to 1.1
 *
 * Revision 1.40  2003/03/31 14:23:37  brian
 * fixed comment typos -non-functional change
 *
 * Revision 1.39  2003/03/12 14:08:12  brian
 * - updated gpg version to 1.0.2
 * - added function header comment blocks to all functions
 *
 * Revision 1.38  2003/03/11 23:29:15  tyler
 * - modified to use the new broken out *_function.php files
 *
 * Revision 1.37  2003/03/11 22:14:02  tyler
 * - Bug fixing in the accept passphrase section of _sign_message
 *
 * Revision 1.36  2003/03/11 21:58:27  tyler
 * - Initial work to accept passphrase in popup window and use for signing
 *
 * Revision 1.35  2003/03/11 18:28:55  tyler
 * - Added comment to the sign_message function where the hardcoded keyID is.
 *   Need to fix this soon.
 *
 * Revision 1.34  2003/03/11 18:05:57  tyler
 * - modified the sign_message function to not accept rcpt list, not used
 *
 * Revision 1.33  2003/03/11 16:55:24  brian
 * Added Joel's fix for the extra line after the GPG MESSAGE header
 *
 * Revision 1.32  2003/03/11 01:09:28  brian
 * Fixed handling of missing keys which cause gpg to not encrypte the message - "encryption failed" warnings
 *
 * Revision 1.31  2003/03/09 21:39:25  brian
 * Added check for https connection
 *
 * Revision 1.30  2003/03/09 14:33:36  brian
 * Added Tyler's gpg_sign_message function
 *
 * Revision 1.29  2003/03/08 19:30:56  brian
 * Added missing bracket at line 188 - credit Tyler
 *
 * Revision 1.28  2003/03/07 16:38:42  brian
 * Patched to fix broken if staetments and debug tests - credit Tyler
 * Removed Superflous includes
 * fixed typo on line 579c590 >global $path_to_gpg
 *
 * Revision 1.27  2003/03/06 01:57:56  brian
 * minor syntax issues resolved
 *
 * Revision 1.26  2003/03/05 14:56:03  brian
 * Final Edits for Release 1.0
 *
 * Revision 1.25  2003/02/22 20:09:59  brian
 * Added gpg_list_keys function and updated gpg_encrypt to use trusted_key preference again.
 *
 * Revision 1.24  2003/02/19 23:52:29  brian
 * updates to use more prefs selections
 *
 * Revision 1.23  2003/01/06 13:09:07  brian
 * Changed all command code to utilize global $path_to_gpg loaded from preferences file
 *
 * Revision 1.22  2003/01/05 15:05:37  brian
 * Added infrastructure function gpg_generate_keypair and fixed strpos usage in gpg_encrypt.
 *
 * Revision 1.21  2003/01/04 11:43:29  brian
 * added vinay's changes for encrypt
 *
 * Revision 1.20  2003/01/03 23:32:06  brian
 * Bracketed remaining echo statement in if $debug in function gpg_encrypt
 *
 * Revision 1.19  2003/01/03 23:10:00  brian
 * removed escapeshellarg for returntext in function gpg_encrypt since we use the --armor command in gpg.
 *
 * Revision 1.18  2003/01/03 23:01:18  brian
 * changed back to escapeshellarg for body only in function gpg_encrypt. we will rely on SM to scrub email addresses.
 *
 * Revision 1.17  2003/01/03 22:45:12  brian
 * Merged vinay's changes.
 *
 * Revision 1.16  2003/01/03 22:40:35  brian
 * Fixed escapeshellcmd to escape the entire gpg command string in function gpg_encrypt.
 *
 * Revision 1.15  2003/01/03 21:59:10  brian
 * Changed a comment to test checkin from laptop.
 *
 * Revision 1.14  2002/12/10 21:52:29  brian
 * fixed syntax errors in gpg_recv_key fuction after integrating to keyserver.mod
 *
 * Revision 1.13  2002/12/10 03:24:36  brian
 * added gpg_recv_key function
 *
 * Revision 1.12  2002/12/10 03:23:54  brian
 * updated all functions to user system $data_dir for prefs and $data_dir/$username.gnupg as the --homedir for gpg
 *
 * Revision 1.11  2002/12/09 03:48:35  vinay
 * added support for system preferences
 *
 * Revision 1.10  2002/12/08 19:51:26  brian
 * added beginnings of keyserver functions
 *
 * Revision 1.9  2002/12/06 21:02:11  brian
 * updates to functions to prepare for keyserver lookup
 *
 * Revision 1.8  2002/12/06 02:18:15  brian
 * edited key/ring import functions to echo nothing unless $debug is set and return the resultstring from the gpg comand as a string
 *
 * Revision 1.7  2002/12/05 23:14:53  brian
 * fixed function gpg_import_key to use user keyring rather than system keyring
 *
 * Revision 1.6  2002/12/05 22:45:55  brian
 * added comments and worked around hack code
 *
 * Revision 1.5  2002/12/05 21:06:16  brian
 * mannually appended log entries
 *
 * Revision 1.4  2002/12/05 21:02:02  brian
 * fixed $Log
 *
 * Revision 1.3  2002/12/05 21:01:09  brian
 * changed gpg_MakePage to point to correct gpg plugin functions instead of sqspell functions
 *
 * Revision 1.2  2002/12/05 19:28:11  brian
 * Added ID and Log tags
 *
 * Revision 1.1  2002/12/05 16:47:55  brian
 * Initial revision
 *
 */

?>
