<?php

/**
 * trustedkey.mod
 * ----------------
 * GPG module
 * Copyright (c) 1999-2002 The SquirrelMail development team
 * Licensed under the GNU GPL. For full terms see the file COPYING.
 *
 * Trusted Key options page
 * Allow the user to specified a trusted_key_id
 *
 *  $Id: trustedkey.mod,v 1.11 2003/04/07 22:21:59 brian Exp $
 *
 * $Author: brian $
 * $Date: 2003/04/07 22:21:59 $
 */

//make the global $debug setting available here
global $debug;

$GPG_DIR="gpg";
if (file_exists('gpg_key_functions.php')){
	require_once('gpg_key_functions.php');
} elseif (file_exists('../gpg_key_functions.php')){
    require_once('../gpg_key_functions.php');
} elseif (file_exists('../plugins/gpg/gpg_key_functions.php')){
    require_once('../plugins/gpg/gpg_key_functions.php');
} else echo "include file not found, exiting abnormally";

// get the variables we need from the _POST without extract ($_POST);
$form = $_POST ['form'];
if ($form == 1) {
   $use_trusted_key_id = $_POST ['use_trusted_key_id'];
   $key_id             = $_POST ['key_id'];
   $key_search_string  = $_POST ['key_search_string'];
}

/* TODO
 * Add code in here to make sure that
 * the user has a public key on the system
 *
 * Otherwise, display an error and a link to
 * the key upload screen
 */

function gpg_format_key_list ($search_string, $msg, $debug){

	$list_text = gpg_list_keys($debug, $search_string, 'true', 'false');

	$trusted_key_id = getPref ($data_dir, $username, 'trusted_key_id');

	if ($debug) {
	   $msg .= $search_string . 'Search String <br>';
	   $msg .= '<p>'
	     .'Using trusted key: '.getPref ($data_dir, $username, 'use_trusted_key_id').'<br>'
	     ._("You currently trust key: ") . $key_id .'<br>Key Details:<br><br>';
	   $msg .= htmlspecialchars(implode ('', $list_text));

	};

	$msg .= '<table>'
		. '<tr>'
		. ' <td></td>'
		. ' <td><b>Email Address</b></td>'
		. ' <td nowrap><b> Key Date </b></td>'
		. ' <td><b>Key Length</b></td>'
		. ' <td><b>Algorithm</b></td>'
		. ' <td><b>Key ID</b></td>'
		. '</tr>';
	foreach ($list_text as $line) {
	  $checked='';
	  if (eregi ("pub:", $line)) {
	     $bits = explode (":", $line);
	     $key_len = $bits[2];
	     $key_alg = $bits[3];
	     /* Algorithm
	      *  1 = RSA
              * 16 = ElGamal (encrypt only)
              * 17 = DSA (sometimes called DH, sign only)
              * 20 = ElGamal (sign and encrypt)
              */
	     switch ($key_alg) {
	         case 1:
	             $key_alg_str = 'RSA';
	             break;
	         case 16:
	             $key_alg_str = 'ElGamal (encrypt only)';
	             break;
	         case 17:
	             $key_alg_str = 'DSA/DH';
	             break;
	         case 20:
	             $key_alg_str = 'ElGamal (sign and encrypt)';
	             break;
	     }
	     $key_id = $bits[4];
	     if ($key_id == $trusted_key_id) {$checked='checked';};
	     $key_date = $bits[5];
	     eregi(".*(<.*>).*", $bits[9], $matches);
	     $email_str = htmlspecialchars($bits[9]);
	     $email_addr = htmlspecialchars($matches[1]);
	     if ($key_id != "") {
	        $msg .=   '<tr>'
			. " <td><input type=radio $checked name=key_id value=$key_id></td>"
			. " <td>$email_str [$email_addr]</td>"
			. " <td nowrap>$key_date</td>"
			. " <td>$key_len</td>"
			. " <td>$key_alg_str</td>"
			. " <td>$key_id</td>"
			. '</tr>';
	     };
	   };
	   $checked='';
	};
	$msg .= '</table>';
	$msg .=
		  '<br> If you do not see the key you want to trust in the list above, '
		. 'or if there is no list: '
		. 'Enter a search string for the key you would like to trust in the box below. '
		. 'This will usually be the email address of the account that you use as your primary signing key.'
		. '<br> Search String:'
		. "<input TYPE='text' NAME='key_search_string' SIZE='40' MAXLENGTH='60' VALUE='$search_string'><br>";

	return $msg;
};


if ($form != 1) {

	$use_trusted_key_id = getPref ($data_dir, $username, 'use_trusted_key_id');
	if ($use_trusted_key_id =='true') {$checked='checked=checked';};
        $msg =
          '<p>'
	  . _("Define the Key you trust implicitly on this screen.")
	  . '<FORM METHOD="POST">'
	  . '<input type="hidden" name="MOD" value="trustedkey" >'
	  . 'Web-based email programs are very convenient, and using '
	  . 'your web email to send encrypted emails adds to that convenience. '
	  . 'It would be dangerous to believe that any web server (like this one) '
	  . 'may be presumed secure.  In fact, most security experts recommend that '
	  . 'web servers be presumed to be at risk of compromise. Because of this risk of '
	  . 'compromise and lack of security, you may not want to store your private key on the web server.'
 	  . '<BR>'
	  . 'To allow you to use the GPG plugin optimally without storing '
	  . 'your private key(s) on the web server, the GPG plugin allows you '
	  . 'to specify a special option called "Trusted Key ID". This option '
	  . 'allows you to indicate to GPG which key on your public keyring '
	  . 'should be treated as a fully trusted key.  Usually, this will be your '
	  . 'primary public key, the key you use to sign other people\'s keys.'
	  . '<BR>'
	  . '<p>'
	  . 'Use the Trusted Key Feature: '
	  . "<input type=checkbox $checked name=use_trusted_key_id value='true'>";

	//start by searching for the user's email address on their public key
	$search_string  = getPref($data_dir, $username, 'email_address');

	$msg .=
	  '<hr>'
	  . 'The default list below is a list of keys that match your email address '
	  . 'on this server.  You may select one of these keys as your trusted key, '
	  . 'or enter another search string to look for your trusted key '
	  . 'on your public keyring by entering your search text below.';

	//create the radio button table
	$msg = gpg_format_key_list ($search_string, $msg, $debug);

	$msg .=
	    '<input type=hidden name=form value=1>'
	  . '<br><input type=submit value="Set or search for your Trusted Key ID">'
	  . '</form>';


	gpg_makePage( _("GPG Options - Set Trusted Key"), null, $msg);
	exit();
}
else {

	if ($key_id != "") {
	   //$use_trusted_key_id = getPref ($data_dir, $username, 'use_trusted_key_id');
	   //set the Preference and retrieve it
           setPref ($data_dir, $username, 'trusted_key_id', $key_id);
  	   if ($use_trusted_key_id==true) {
  	   	setPref ($data_dir, $username, 'use_trusted_key_id', 'true');
  	   } else {
  	   	setPref ($data_dir, $username, 'use_trusted_key_id', 'false');
  	   };
  	   $key_id = getPref ($data_dir, $username, 'trusted_key_id');
  	   if ($debug) {
  	  	$msg .= "Search String: $key_id"
  	  		. '<br>';
  	   };

  	   $list_text = gpg_list_keys($debug, $key_id, 'false', 'false');
	   $msg .= '<p>'
	     .'Using trusted key: '.getPref ($data_dir, $username, 'use_trusted_key_id')
	     .'<br>';
	   if ($use_trusted_key_id==true){
	      $msg .= '<p>'
	         ._("You will now trust key: ") . $key_id .'<br>Key Details:<br><br>'
	         . htmlspecialchars(implode ('', $list_text))
	         . '<br>Any key signed with this key ID will be allowed for encryption without generating errors.';
	   } else {
	      $msg .= '<p>Your preference to not use the trusted key ID feature has been recorded.';
	   };

	   gpg_makePage( _("Trusted Key Results"), null, $msg);
	   exit();
	} else {
	   $use_trusted_key_id = getPref ($data_dir, $username, 'use_trusted_key_id');
	   if ($use_trusted_key_id =='true') {$checked='checked=checked';};

	   $msg = '<form METHOD="POST"><p>'
	     . '<input type="hidden" name="MOD" value="trustedkey" >'
	     . '<p>'
	     . 'Use the Trusted Key Feature: '
	     . "<input type=checkbox $checked name=use_trusted_key_id value='true'>"
	     . '<p>'
	     . 'The table below is a list of keys that match the search parameters that you submitted.'
	     . 'You may select one of these keys as your trusted key, '
	     . 'or enter another search string to look for your trusted key '
	     . 'on your public keyring by entering your search text below.';

	     //create the radio button table
	     $msg = gpg_format_key_list ($key_search_string, $msg, $debug);
	     $msg .=
	  	'<input type=hidden name=form value=1>'
		. '<br><input type=submit value="Set or search for your Trusted Key ID">'
		. '</form>';

	    gpg_makePage( _("Trusted Key Search"), null, $msg);
	    exit();
	};

};

/**
 *
 * $Log: trustedkey.mod,v $
 * Revision 1.11  2003/04/07 22:21:59  brian
 * modified files to not use extract $_POST
 * Bug 5
 *
 * Revision 1.10  2003/04/02 20:48:39  brian
 * fixed spelling errors using aspell
 * TODO - check grammer and sentence structure manually
 * Bug 18
 *
 * Revision 1.9  2003/04/01 17:58:46  brian
 * fixed includes to reflect different calling directories
 *
 * Revision 1.8  2003/03/12 00:21:19  brian
 * Added code to correctly display the state of the preference and selected key on loading.
 *
 * Revision 1.7  2003/03/11 23:29:15  tyler
 * - modified to use the new broken out *_function.php files
 *
 * Revision 1.6  2003/03/07 15:56:33  brian
 * Removed enctype=multipart/form-data - not needed for this form
 *
 * Revision 1.5  2003/03/07 00:11:53  brian
 * Removed superfluous includes.
 *
 * Revision 1.4  2003/02/27 01:05:14  brian
 * Applied Vinay's patch to fix form input from key search screen.
 *
 * Revision 1.3  2003/02/25 00:56:12  brian
 * Added setPref for use_trusted_key_id so that the gpg_encrypt function will use the trusted_key set in this module.
 *
 * Revision 1.2  2003/02/22 20:13:37  brian
 * Completed Trusted key selection and storage,
 * allowing search for appropriate trusted key,
 * and using default behavior to make the user task easier.
 *
 * Revision 1.1  2003/02/22 14:11:55  brian
 * Initial revision
 *
 */

?>
