<?php

/**
 * key.mod
 * ----------------
 * GPG module
 * Copyright (c) 1999-2002 The SquirrelMail development team
 * Licensed under the GNU GPL. For full terms see the file COPYING.
 *
 * Key import screen
 * the user uses this screen to upload an ASCII Armored Key or a
 * standard PGP/GPG keyring file to the plugin
 *
 *  $Id: key.mod,v 1.18 2003/04/07 22:21:59 brian Exp $
 */

//make the global $debug setting available here
global $debug;

$GPG_DIR="gpg";
if (file_exists('gpg_key_functions.php')){
	require_once('gpg_key_functions.php');
} elseif (file_exists('../gpg_key_functions.php')){
    require_once('../gpg_key_functions.php');
} elseif (file_exists('../plugins/gpg/gpg_key_functions.php')){
    require_once('../plugins/gpg/gpg_key_functions.php');
} else echo 'Include file not found, exiting abnormally.';

// get the variables we need from the _POST without extract ($_POST);
$form = $_POST ['form'];
if ($form == 1) {
   $keystring = $_POST['keystring'];
   // $keyfile   = $_POST['keyfile'];
}

if (!$form) {
        $msg =
          '<p>'
	  . _("You may add keys or upload a keyring to your server keyring here:")
	  . '<FORM METHOD="POST" enctype="multipart/form-data">'
	  . 'Paste your ASCII-armored keys here'
	  . '<BR><textarea name="keystring" rows=10 cols=60>'
	  . '</textarea>'
	  . '<input type="hidden" name="MOD" value="key" >'
	  . '<input type="hidden" name="MAX_FILE_SIZE" value="100000">'
	  . '<BR>and/or Upload a key/keyring file.'
	  . '<BR><INPUT TYPE="FILE" NAME="keyfile" size="75%">'
	  . '<input type=hidden name=form value=1>'
	  . '<br><input type=submit value="Add Keys to your Keyring">'
	  . '</form>';


	gpg_makePage( _("GPG Key/Keyring Import"), null, $msg);
	exit();
}
else {

	$msg = '<p>'
	  . '<input type="hidden" name="MOD" value="key" >';

	if ($keystring != "") {
	  $key_import_output_str = gpg_import_key($keystring, $debug);

	  $msg .= '<p>'
	    ._("Your ASCII Armored Key Import Returned")
	    . "<br><textarea cols=80 rows=15 name=output>$key_import_output_str</textarea>"
            . '<hr>';

	};

	if (is_uploaded_file($_FILES['keyfile']['tmp_name'])) {
	  $keyring_import_output_str = gpg_import_keyring($_FILES['keyfile']['tmp_name'],$debug);

	  $msg .= '<p>'
	    ._("Your Keyring File Import Returned")
	    . "<br><textarea cols=80 rows=15 name=output>$keyring_import_output_str</textarea>"
	    . '<hr>';
	};

       gpg_makePage( _("Key/Keyring Import Results"), null, $msg);
  	exit();
};

/**
 *
 * $Log: key.mod,v $
 * Revision 1.18  2003/04/07 22:21:59  brian
 * modified files to not use extract $_POST
 * Bug 5
 *
 * Revision 1.17  2003/04/02 20:48:39  brian
 * fixed spelling errors using aspell
 * TODO - check grammer and sentence structure manually
 * Bug 18
 *
 * Revision 1.16  2003/04/02 14:58:55  brian
 * fixed typo and changed size attribute for file box
 *
 * Revision 1.15  2003/04/02 14:53:33  brian
 * removed references to public key, as this screen is used for importing both public and private keyrings
 *
 * Revision 1.14  2003/04/01 18:04:06  brian
 * fixed includes to reflect different calling directories
 *
 * Revision 1.13  2003/04/01 18:00:40  brian
 * fixed includes to reflect different calling directories
 *
 * Revision 1.12  2003/03/11 23:29:15  tyler
 * - modified to use the new broken out *_function.php files
 *
 * Revision 1.11  2003/03/07 00:09:56  brian
 * Removed superfluous includes.
 *
 * Revision 1.10  2003/01/22 23:46:18  brian
 * Removed test SetPref and GetPref directives. (missed some)
 *
 * Revision 1.9  2003/01/22 23:28:37  brian
 * Removed test SetPref and GetPref directives.
 *
 * Revision 1.8  2002/12/10 14:32:13  brian
 * edited to use global \$debug, rather than a local code
 *
 * Revision 1.7  2002/12/10 14:31:22  brian
 * edited to use global \$debug, rather than a local code
 *
 * Revision 1.6  2002/12/06 19:55:46  vinay
 * fixed single-quote bug in showing returns from GPG functions
 *
 * Revision 1.5  2002/12/06 02:21:11  brian
 * tinkered with the output formatting.
 * this file displays in the standard template on submit,
 * but does not display the output strings,
 * suspect that the values are not getting passed to gpg_makePage
 *
 * Revision 1.4  2002/12/06 01:06:59  brian
 * modified form submit functions to utilize SM template and gpg_makePage
 *
 * Revision 1.3  2002/12/05 21:14:53  brian
 * fixed $Log entry, manually appended log history, and integrated display with template format for gpg_makePage function
 *
 * Revision 1.2  2002/12/05 19:53:56  brian
 * added log and id tag
 *
 * Revision 1.1  2002/12/05 16:47:55  brian
 * Initial revision
 *
 */

?>
