<?php

/**
 * general.mod
 * ----------------
 * GPG module
 * Copyright (c) 1999-2002 The SquirrelMail development team
 * Licensed under the GNU GPL. For full terms see the file COPYING.
 *
 * Copyright (c) 2002-2003 Braverock Ventures
 *
 * General options screen.
 *
 *  $Id: general.mod,v 1.6 2003/04/07 22:21:59 brian Exp $
 *
 * $Author: brian $
 * $Date: 2003/04/07 22:21:59 $
 */

/* From the TODO file
 *	- Provide a User Preferences Screen,
 *	  accessed from the "Options" screen in Squirrelmail
 *
 *		- allow automatic keyserver lookup of public keys? (Y/N)
 *
 *		- trust system-wide public keyring? (Y/N)
 *			(if the sysadmin has turned this on and created one)
 *
 *		- allow encryption to only some recipients (Y/N)
 *
 *		- allow user to select whether to encrypt to self by default
 *			- will set --default-recipient-self flag
 *
 */

//make the global $debug setting available here
global $debug;

$GPG_DIR="gpg";

// get the variables we need from the _POST without extract ($_POST);
$form = $_POST ['form'];
if ($form == 1) {
   $encrypt_to_self          = $_POST['encrypt_to_self'];
   $self_encr_email          = $_POST['self_encr_email'];
   $allow_partial_encryption = $_POST['allow_partial_encryption'];
   $trust_system_keyring     = $_POST['trust_system_keyring'];
   //allow_partial_encryption needs to be added here once implemented
}


/*
 * check to see if preferences we need are set using GetPref
 * for now, set all these options to true if the preferences come back null
 * eventually, we should probably allow the system admin to set defaults in
 * the config files and use those defaults
 *
 * Design Philosophy:
 * assume that relatively harmless options are true by default
 * and that really dodgy ones are false by default
 * (this also gives some variation on the screen ;-)
 */

global $GPG_SYSTEM_OPTIONS;

if (!$form) {

	//set defaults
	$systemkeyring=$GPG_SYSTEM_OPTIONS['systemkeyring'];
	$encrypt_to_self='true';
	$self_encr_email  = getPref($data_dir, $username, 'self_encr_email');
	$allow_partial_encryption='true';
	$trust_system_keyring='false';
	$automatic_key_lookup='false';

	//now load preferences if they exist.
	$encrypt_to_self=getPref($data_dir,$username,'encrypt_to_self');
	$self_encr_email  = getPref($data_dir, $username, 'email_address');
	$self_encr_email = htmlspecialchars($self_encr_email);
	$allow_partial_encryption=getPref($data_dir,$username,'allow_partial_encryption');
	$trust_system_keyring=getPref($data_dir,$username,'trust_system_keyring');
	$automatic_key_lookup=getPref($data_dir,$username,'automatic_key_lookup');

	$msg =
          _("This screen allows you to set general GPG Plugin Options.")
	  . '<hr>'
	  . '<FORM METHOD="POST" >'
	  . '<input type="hidden" name="form" value=1>'
	  . '<input type="hidden" name="MOD" value="general" >';

	// Partial encryption
	$msg .=
	  '<p>'
	  . _("Sometimes, you may not have public keys for all of the email addresses in your To, CC, and BCC fields in the Compose window. ")
	  . _("When this happens, the GPG plugin can either display an error and return to your plaintext, or encrypt the message to the recipients that you do have keys for, and inform you of the email addresses that you did not have keys for.")
	  . '<p>'
	  . _("Do you want the GPG plugin to encrypt the message to only some recipients, if you do not have keys for everyone?")
	  . '<br>';
	if ($allow_partial_encryption=='true')
	{
	   $msg .=
	     '<input TYPE="radio" NAME="allow_partial_encryption" VALUE="true" checked>Yes'
	     . '<input TYPE="radio" NAME="allow_partial_encryption" VALUE="false" >No';
	}
	else {
	   $msg .=
	     '<input TYPE="radio" NAME="allow_partial_encryption" VALUE="true" >Yes'
	     . '<input TYPE="radio" NAME="allow_partial_encryption" VALUE="false" checked>No';
	};
	//end partial encryption option

	// Encrypt to Self
	$msg .=
	  '<p>'
	  . _("When you encrypt an email message, the plugin can be set to automatically include your email address in the recipient list.")
	  . _("If your keyring has a public key for this email address on it, then all messages you encrypt will be readable by you later. ")
	  . _("If you set this option to 'No', you will not be able to decrypt messages encrypted with the plugin unless you add your email address in the To, CC, or BCC line of the email before encrypting it.")
	  . '<p>'
	  . _("Do you want the plugin to encrypt mail to your address, in addition to the recipients?")
	  . '<br>';
	if ($encrypt_to_self=='true')
	{
	   $msg .=
	     '<input TYPE="radio" NAME="encrypt_to_self" VALUE="true" checked>Yes'
	     . '<input TYPE="radio" NAME="encrypt_to_self" VALUE="false" >No';
	}
	else {
	   $msg .=
	     '<input TYPE="radio" NAME="encrypt_to_self" VALUE="true" >Yes'
	     . '<input TYPE="radio" NAME="encrypt_to_self" VALUE="false" checked>No';
	};
	$msg.=
	  '<br>'
	  . _("If you selected 'Yes', what is the email address you would like to encrypt to:")
	  . "<br><input TYPE='text' NAME='self_encr_email' SIZE='40' MAXLENGTH='60' VALUE='$self_encr_email'><br>";
	//end encrypt to self option

	// automatic lookup of public keys
	/*
	 * The option to automatically look up public keys will work well
	 * with the partial encryption option.  The idea is that if you
	 * select this option, we will do some automated processing to
	 * retrieve keys for the email addresses in your recipient list
	 * and add them to the users public keyring before calling the
	 * encrypt function.
	 *
	 * This would let a user try to encrypt messages to people,
	 * even without manually looking up their keys.
	 *
	 * Probably not for Release 1
	 */

	// trust system keyring
	if ($systemkeyring=='true') {
	   $msg .=
	      '<p>'
	      . _("Your System administrator has indicated that there is a 'system-wide' public keyring. ")
	      . _("Usually, this would suggest that a keyring is maintained for some group which you are a part of, such as a corporation. ")
	      . _("You must choose whether to trust this keyring and use it in your public key lookups. ")
	      . _("If you select 'Yes' below, the plugin will search the 'system-wide' keyring for public keys after looking at your public keyring. ")
	      . _("If you set this option to 'No', you will not have access to any keys stored on the system keyring, which may include keys for members of a group to which you belong.")
	      . '<p>'
	      . _("Do you want to trust the system-wide keyring that has been defined by your system administrator?")
	      . '<br>';
		if ($trust_system_keyring=='true')
		{
		   $msg .=
		     '<input TYPE="radio" NAME="trust_system_keyring" VALUE="true" checked>Yes'
		     . '<input TYPE="radio" NAME="trust_system_keyring" VALUE="false" >No';
		}
		else {
		   $msg .=
		     '<input TYPE="radio" NAME="trust_system_keyring" VALUE="true" >Yes'
		     . '<input TYPE="radio" NAME="trust_system_keyring" VALUE="false" checked>No';
		};
	};
	//end system keyring option

	//wrap up and submit
	$msg .=
	  '<br><input type=submit value="Change Preferences">'
	  . '</form>';

	//setPref($data_dir,"gpgplugin","test_gpg_pref", "true");

        //$msg .= "KEY:" . getPref($data_dir, $username, 'has_key') . ":";
        //$msg .= "<br>System Pref:" . getPref($data_dir, "gpgplugin", 'test_gpg_pref') . ":";
	gpg_makePage( _("GPG Plugin - General Options"), null, $msg);
	exit();
}

else {
	/* Process the form input */
	$msg = ''; //initialize $msg

	if ($allow_partial_encryption=='true')
	{
	   setPref ($data_dir, $username, 'allow_partial_encryption', 'true');
	}
	else {
	   setPref ($data_dir, $username, 'allow_partial_encryption', 'false');
	};
	if ($debug) {
	   $msg .= '<br>allow_partial_encryption = ' . getPref($data_dir, $username, 'allow_partial_encryption');
        };

	if ($encrypt_to_self=='true')
	{
	   setPref ($data_dir, $username, 'encrypt_to_self', 'true');
	   setPref ($data_dir, $username, 'self_encr_email', $self_encr_email);
	}
	else {
	   setPref ($data_dir, $username, 'encrypt_to_self', 'false');
	};
	if ($debug) {
	   $msg .= '<br>encrypt_to_self = ' . getPref($data_dir, $username, 'encrypt_to_self');
	   $msg .= '<br>self_encr_email = ' . htmlspecialchars(getPref($data_dir, $username, 'self_encr_email'));
        };

	if ($automatic_key_lookup=='true')
	{
	   setPref ($data_dir, $username, 'automatic_key_lookup', 'true');
	}
	else {
	   setPref ($data_dir, $username, 'automatic_key_lookup', 'false');
	};
	if ($debug) {
	   $msg .= '<br>automatic_key_lookup = ' . getPref($data_dir, $username, 'automatic_key_lookup');
        };

	if ($trust_system_keyring=='true')
	{
	   setPref ($data_dir, $username, 'trust_system_keyring', 'true');
	}
	else {
	   setPref ($data_dir, $username, 'trust_system_keyring', 'false');
	};
	if ($debug) {
	   $msg .= '<br>trust_system_keyring = ' . getPref($data_dir, $username, 'trust_system_keyring');
        };

	$msg .=
	  '<br><p>Your Preferences have been saved.<p>';

	gpg_makePage( _("GPG Plugin - General Options"), null, $msg);
  	exit();
};

exit();

/**
 *
 * $Log: general.mod,v $
 * Revision 1.6  2003/04/07 22:21:59  brian
 * modified files to not use extract $_POST
 * Bug 5
 *
 * Revision 1.5  2003/04/02 20:48:39  brian
 * fixed spelling errors using aspell
 * TODO - check grammer and sentence structure manually
 * Bug 18
 *
 * Revision 1.4  2003/03/07 12:58:28  brian
 * Removed enctype=multipart/form-data - not needed for this form
 * Removed second reference to hidden field 'form' - superfluous
 *
 * Revision 1.3  2003/03/06 23:20:44  brian
 * Fixed bug in setting preferences
 * (only set defaults before form has been submitted)
 *
 * Revision 1.2  2003/02/22 20:12:46  brian
 * Added text to describe the automatic key lookup option, not in this release.
 *
 * Revision 1.1  2003/01/24 16:40:25  brian
 * Setting preferences for encr_to_self, trust_system_keyring, automatic_key_lookup, and allow_partial_encryption
 *
 *
 */

?>