<?php

  /* SquirrelMail gotmail (HotMail fetcher) plugin
   *
   * Copyright (c) 1999-2003 The SquirrelMail Project Team
   * Licensed under the GNU GPL. For full terms see the file COPYING.
   *
   * This is my first attempt at a plugin.  I wanted a way to fetch
   * my hotmail so I'd only need one interface.  Of course I don't
   * like to reinvent the wheel so this just gets options for gotmail
   * and runs gotmail with cmd line params to fetch the mail.  Kinda
   * hackish but it's better then parsing and ever changing interface
   * coded by M$ techs.
   */

  define('SM_PATH','../../');
  
  require_once(SM_PATH . 'include/load_prefs.php');
  require_once(SM_PATH . 'plugins/got_hotmail/config.php');
    
  function got_hotmail_Status($msg) {
    echo html_tag( 'table',
      html_tag( 'tr',
        html_tag( 'td', htmlspecialchars( $msg ) , 'left' )
      ),
    '', '', 'width="90%"' );
    flush();
  }

  function got_hotmail_cmd($gm_c_number, $gm_pass) {
    // server conf vars
    global $gotmail_bin, $curl_bin;
    global $gm_proxy, $gm_proxy_auth, $gm_speed_limit;
    global $gm_retry_limit, $gm_silent;

    $gm_only_new    = getPref($data_dir, $username, "gm_only_new$gm_c_number");
    $gm_mark_read   = getPref($data_dir, $username, "gm_mark_read$gm_c_number");
    $gm_delete      = getPref($data_dir, $username, "gm_delete$gm_c_number");
    $gm_folder_list = getPref($data_dir, $username, "gm_folder_list$gm_c_number");
    $gm_username    = getPref($data_dir, $username, "gm_username$gm_c_number");
    $gm_domain      = getPref($data_dir, $username, "gm_domain$gm_c_number");

    $email = getPref($data_dir, $username, "email_address");

    if($gotmail_bin != "") {
      $cmd  = $gotmail_bin;
    } else {
      $cmd  = "gotmail";
    }
    if($curl_bin != "") {
      $cmd .= " " . $curl_bin;
    }
    if($gm_proxy != "") {
      $cmd .= " --proxy " . $gm_proxy;
    }
    if($gm_proxy_auth != "") {
      $cmd .= " --proxy-auth " . $gm_proxy_auth;
    }
    if($gm_speed_limit == "on") {
      $cmd .= " --speed-limit";
    }
    if($gm_retry_limit != "") {
      $cmd .= " --retry-limit " . $gm_retry_limit;
    }
    $cmd .= " --forward " . $email;
    if($gm_silent == "on") {
      $cmd .= " --silent ";
    }
    $cmd .= " --username " . $gm_username;
    $cmd .= " --password " . $gm_pass;
    $cmd .= " --domain " . $gm_domain;
    $cmd .= " --folders \"" . $gm_folder_list . "\"";
    if($gm_only_new == "on") {
      $cmd .= " --only-new";
    }
    if($gm_mark_read == "on") {
      $cmd .= " --mark-read";
    }
    if($gm_delete == "on") {
      $cmd .= " --delete";
    }

    return $cmd;
  }

  function gm_parser($cmd_output, $cmd_error, $mail) {
    $mailexists = 0;
    foreach ($cmd_output as $line) {
      if($line == "Logging in...") {
        got_hotmail_Status("::: "._("Logging in"));
      } else if($line == "Loading folder list...") {
        got_hotmail_Status("::: "._("Getting folder info"));
      } else if(preg_match("/^Processing Folder: \"(.*)\", Total messages: ([0-9]+)?, Unread messages: ([0-9]+)./", $line, $matches)) {
        got_hotmail_Status(":::    ".$matches[1]._(" has ").$matches[3]._(" unread messages of ").$matches[2]);
      } else if(preg_match("/^Loading folder \"(.*)\" page ([0-9]+).../", $line, $matches)) {
        $box = $matches[1];
        $msg = $matches[2];
	$mailexists = 1;
        got_hotmail_Status("::: "._("Getting msg ").$msg._(" from ").$box);
      } else if($line == "Marking message as read...") {
        got_hotmail_Status("::: "._("Marking msg ").$msg._(" as read"));
      } else if($line == "Deleting message...") {
        got_hotmail_Status("::: "._("Removing msg ").$msg._(" from ").$box);
      } else if($line == "All done!") {
        got_hotmail_Status("::: "._("Closing connection"));
      }
    }

    if($gm_error == 0) {
      if($mailexists == 0) {
        got_hotmail_Status("::: "._("No messages to get"));
      } else {
        got_hotmail_Status("::: "._("All the messages should be delivered to ".$mail." shortly"));
      }
    } else if($gm_error != 0) {
      if($mail != 0) {
        got_hotmail_Status("::: "._("All the messages should be delivered to ".$mail." shortly"));
      }
      got_hotmail_Status("::: "._("Some errors have occured"));
      got_hotmail_Status("::: "._("Please notify your administrator"));
    }
  }

/* ------- */
  function gm_hex2bin( $data ) {
    /* Original code by josh@superfork.com */

    $len = strlen($data);
    $newdata = '';
    for( $i=0; $i < $len; $i += 2 ) {
      $newdata .= pack( "C", hexdec( substr( $data, $i, 2) ) );
    }
    return $newdata;
  }

  function gm_keyED( $txt ) {
    global $GM_TIT;

    if( !isset( $GM_TIT ) ) {
      $GM_TIT = "GotMail Secure for SquirrelMail 1.x";
    }

    $encrypt_key = md5( $GM_TIT );
    $ctr = 0;
    $tmp = "";
    for( $i = 0; $i < strlen( $txt ); $i++ ) {
      if( $ctr == strlen( $encrypt_key ) ) $ctr=0;
      $tmp.= substr( $txt, $i, 1 ) ^ substr( $encrypt_key, $ctr, 1 );
      $ctr++;
    }
    return $tmp;
  }

  function gm_encrypt( $txt ) {
    srand( (double) microtime() * 1000000 );
    $encrypt_key = md5( rand( 0, 32000 ) );
    $ctr = 0;
    $tmp = "";
    for( $i = 0; $i < strlen( $txt ); $i++ ) {
      if ($ctr==strlen($encrypt_key)) $ctr=0;
      $tmp.= substr($encrypt_key,$ctr,1) .
             (substr($txt,$i,1) ^ substr($encrypt_key,$ctr,1));
      $ctr++;
    }
    return bin2hex( gm_keyED( $tmp ) );
  }

  function gm_decrypt( $txt ) {
    $txt = gm_keyED( gm_hex2bin( $txt ) );
    $tmp = '';
    for ( $i=0; $i < strlen( $txt ); $i++ ) {
      $md5 = substr( $txt, $i, 1 );
      $i++;
      $tmp.= ( substr( $txt, $i, 1 ) ^ $md5 );
    }
    return $tmp;
  }
?>
