<?php
    /*
     * $Id: read_uuencode.php,v 1.4 2003/09/26 19:59:45 indiri69 Exp $
     */
    define('SM_PATH', '../../');
    require_once(SM_PATH . 'include/validate.php');
    require_once(SM_PATH . 'functions/strings.php');
    require_once(SM_PATH . 'config/config.php');
    require_once(SM_PATH . 'functions/imap.php');
    require_once(SM_PATH . 'functions/mime.php');
    require_once(SM_PATH . 'functions/prefs.php');
    require_once(SM_PATH . 'functions/global.php');
    include_once(SM_PATH . 'plugins/get_uuencode/get_uuencode.php');

    sqgetGlobalVar('key',           $key,           SQ_COOKIE);
    sqgetGlobalVar('username',      $username,      SQ_SESSION);
    sqgetGlobalVar('onetimepad',    $onetimepad,    SQ_SESSION);
    sqgetGlobalVar('mailbox',       $mailbox,       SQ_GET);
    sqgetGlobalVar('passed_id',     $passed_id,     SQ_GET);
    if(!sqgetGlobalVar('passed_ent_id', $passed_ent_id, SQ_GET)) {
        $passed_ent_id = 1;
    }
    if(!sqgetGlobalVar('get_uuencode_file', $get_uuencode_file, SQ_GET)) {
        $get_uuencode_file = 1;
    }

    $imapConnection = sqimap_login($username, $key, $imapServerAddress, $imapPort, 0);
    sqimap_mailbox_select($imapConnection, $mailbox);
    $message = sqimap_get_message($imapConnection, $passed_id, $mailbox);

    $body = decodeBody(mime_fetch_body($imapConnection, $passed_id, $passed_ent_id), $message->header->encoding);

    $uu_file = '/((begin|begin-base64)' . '\s+' . '[0-7]{3}' . '\s+' .
               '([^\n]+))' . '\n' . '(.+?)' . '\n' . '(end|====)' . '/s';

    // Find the file that was requested
    for ($i = 1; $i <= $get_uuencode_file; $i++) {
        preg_match($uu_file, $body, $uu_data) or
            die ('get_uudecode: Message doesn\'t contain a uuencoded message.');
        $uu_complete = $uu_data[0];
        $uu_match    = $uu_data[1];
        $uu_type     = $uu_data[2];
        $uu_filename = $uu_data[3];
        $uu_end      = $uu_data[5];

        $bodyhead  = strpos($body, $uu_match);
        $bodystart = $bodyhead + strlen($uu_match);
        $bodyend   = strpos($body, $uu_end, $bodystart);
        if ($bodyend) {
            $bodyend += strlen($uu_end);
            $body     = substr($body, $bodyend);
        }
    }
    $data = get_uuencode_decode($uu_complete);

    $uu_filename = ereg_replace('[\\/:\*\?"<>\|;]', '_', str_replace('&nbsp;', ' ', $uu_filename));

    header('Pragma: ');
    header('Cache-Control: cache');
    header("Content-Disposition: attachment; filename=$uu_filename");
    header("Content-type: application/octet-stream; name=$uu_filename");
    echo $data;
?>
