<?php
/**
 * SquirrelMail Forced Prefs Plugin -- Main setup script
 * Copyright (c) 2004-2007 Tomas Kuliavas <tokul@users.sourceforge.net>
 * This file is part of SquirrelMail forced_prefs plugin.
 *
 * This plugin is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This plugin is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * plugin; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place, Suite 330, Boston, MA  02111-1307  USA
 * @package sm-plugins
 * @subpackage forced_prefs
 * @version $Id: setup.php,v 1.14 2007/08/29 13:21:51 tokul Exp $
 */

/**
 * init function
 */
function squirrelmail_plugin_init_forced_prefs() {
    global $squirrelmail_plugin_hooks;

    $squirrelmail_plugin_hooks['login_verified']['forced_prefs'] = 'forced_prefs_set';
    // Dynamic overrides with backend hooks (since 1.4)
    $squirrelmail_plugin_hooks['get_pref_override']['forced_prefs'] = 'forced_prefs_get_pref_override';
    $squirrelmail_plugin_hooks['get_pref']['forced_prefs'] = 'forced_prefs_get_pref';
    // optpage blocks
    $squirrelmail_plugin_hooks['optpage_register_block']['forced_prefs'] = 'fp_optpage_register_block';
    // optpage_data preference filter
    $squirrelmail_plugin_hooks['optpage_loadhook_display']['forced_prefs'] = 'fp_filter_optdata';
    $squirrelmail_plugin_hooks['optpage_loadhook_personal']['forced_prefs'] = 'fp_filter_optdata';
    $squirrelmail_plugin_hooks['optpage_loadhook_folder']['forced_prefs'] = 'fp_filter_optdata';
    // one more hook for squirrelmail 1.5.1+
    $squirrelmail_plugin_hooks['optpage_loadhook_compose']['forced_prefs'] = 'fp_filter_optdata';
    // what can be done with these two hooks?
    $squirrelmail_plugin_hooks['optpage_loadhook_highlight']['forced_prefs'] = 'fp_filter_optdata';
    $squirrelmail_plugin_hooks['optpage_loadhook_order']['forced_prefs'] = 'fp_filter_optdata';

    // advanced_settings plugin
    $squirrelmail_plugin_hooks['optpage_loadhook_advanced_settings']['forced_prefs'] = 'fp_filter_optdata';

    // override during save
    $squirrelmail_plugin_hooks['options_save']['forced_prefs'] = 'fp_override_save';

    // plugin hooks filter
    include_once(SM_PATH . 'plugins/forced_prefs/functions.php');
    $squirrelmail_plugin_hooks=fp_filter_hooks($squirrelmail_plugin_hooks);
}

/**
 * sets preferences
 * @since 1.0
 */
function forced_prefs_set() {
    include_once(SM_PATH . 'plugins/forced_prefs/functions.php');
    set_forced_prefs();
}

/**
 * calls internal optpage_data filtering functions
 * @since 1.1
 */
function fp_filter_optdata() {
    include_once(SM_PATH . 'plugins/forced_prefs/functions.php');
    fp_filter_optdata_internal();
}

/**
 * calls internal function which overrides enforced settings during save
 * @since 1.1
 */
function fp_override_save() {
    include_once(SM_PATH . 'plugins/forced_prefs/functions.php');
    fp_override_save_internal();
}

/**
 * calls internal function which filters option page blocks
 * @since 1.2
 */
function fp_optpage_register_block() {
    include_once(SM_PATH . 'plugins/forced_prefs/functions.php');
    fp_filter_optpage_blocks();
}

/**
 * Function attached to get_pref_override hook
 * @param array hook arguments
 * @return mixed overriden setting value or false
 * @since 1.4
 */
function forced_prefs_get_pref_override($args) {
    include_once(SM_PATH . 'plugins/forced_prefs/functions.php');
    return fp_get_pref_override_do($args);
}

/**
 * Function attached to get_pref hook
 * @param array hook arguments
 * @return mixed overriden setting value or false
 * @since 1.4
 */
function forced_prefs_get_pref($args) {
    include_once(SM_PATH . 'plugins/forced_prefs/functions.php');
    return fp_get_pref_do($args);
}

/**
 * shows plugin's version
 * @return string
 */
function forced_prefs_version() {
    return '1.4.sm';
}