<?php
/**
 * SquirrelMail Forced Prefs Plugin -- Default plugin configuration
 * Copyright (C) 2004-2007 Tomas Kuliavas <tokul@users.sourceforge.net>
 * This file is part of SquirrelMail forced_prefs plugin.
 *
 * This plugin is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This plugin is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * plugin; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place, Suite 330, Boston, MA  02111-1307  USA
 * @package sm-plugins
 * @subpackage forced_prefs
 * @version $Id: config_default.php,v 1.5 2007/08/29 13:21:51 tokul Exp $
 */

/**
 * lists settings that should be added, if not present in user's prefs
 * array should use setting names as array keys and setting values as
 * key values.
 *
 * @global array $fp_added_settings
 * @since 1.0
 */
$fp_added_settings=array();

/**
 * lists settings that should be set during login. Enforced settings
 * are removed from option pages, if they use SquirrelMail $optdata
 * array. array should use setting names as array keys and setting
 * values as key values.
 *
 * @global array $fp_forced_settings
 * @since 1.0
 */
$fp_forced_settings=array();

/**
 * lists functions that should be removed from enabled hooks
 *
 * WARNING. Use with caution. Disable only function calls that control
 * option display and saving. If you have problems with plugins - make
 * sure that problems can be reproduced without forced_prefs plugin.
 * @global array $fp_disabled_hooks
 * @since 1.1
 */
$fp_disabled_hooks=array();

/**
 * Array with urls that should be removed from option blocks. Other option block
 * array keys can't be used because they contain translatable data and strings
 * are not static.
 *
 * This option can be used to strip standard SquirrelMail option pages that
 * don't use plugin hooks. You can use regular expression instead of URL. Plugin
 * uses case insensitive POSIX regexps (http://www.php.net/eregi). If you make
 * regexp error, warning message won't be displayed and option block is not removed.
 * @global array $fp_removed_optpage_urls
 * @since 1.2
 */
$fp_removed_optpage_urls=array();

/**
 * Displays debug information
 *
 * calls sm_print_r() function in order to display processed data
 * If set to true, requires SquirrelMail 1.4.1 or better. Interface will revert
 * to false, if sm_print_r() function is not available.
 *
 * WARNING: don't enable option in production environment.
 * @global boolean $fp_debug
 * @since 1.2
 */
$fp_debug=false;

/**
 * Overrides interface defaults without saving them in user preferences
 *
 * Setting requires preference backend with get_pref hook support. Due to
 * implementation specifics, you can't override defaults with zero, empty or any
 * other values that are evaluated as boolean false in PHP.
 * @global array $fp_dynamic_defaults
 * @since 1.4
 */
$fp_dynamic_defaults=array();

/**
 * Overrides settings without saving them in user preferences
 *
 * Setting requires preference backend with get_pref_override hook support. Due
 * to implementation specifics, you can't override defaults with zero, empty or
 * any other values that are evaluated as boolean false in PHP. Overrides are
 * filtered in option pages same way as overrides in $fp_forced_settings.
 * @global array $fp_dynamic_overrides
 * @since 1.4
 */
$fp_dynamic_overrides=array();
