<?php
/**
 * plugins/forced_prefs/functions.php -- Functions used by plugin
 *
 * SquirrelMail Forced Prefs Plugin
 * Copyright (C) 2004-2005 Tomas Kuliavas <tokul@users.sourceforge.net>
 * This program is licensed under GPL. See COPYING for details
 *
 * @package sm-plugins
 * @subpackage forced_prefs
 * @version $Id: functions.php,v 1.8 2005/01/25 13:27:32 tokul Exp $
 */

// make sure SM_PATH is defined
if (!defined('SM_PATH')) {
    define('SM_PATH','../../');
}

// load global declarations and default config
if (file_exists(SM_PATH . 'plugins/forced_prefs/config_default.php')) {
    include_once(SM_PATH . 'plugins/forced_prefs/config_default.php');
} else {
    // default config file was removed
    global $fp_added_settings;
    $fp_added_settings=array();
    global $fp_forced_settings;
    $fp_forced_settings=array();
    global $fp_disabled_hooks;
    $fp_disabled_hooks=array();
}

// load config
if (file_exists(SM_PATH . 'config/forced_prefs_config.php')) {
    include_once(SM_PATH . 'config/forced_prefs_config.php');
} elseif (file_exists(SM_PATH . 'plugins/forced_prefs/config.php')) {
    include_once(SM_PATH . 'plugins/forced_prefs/config.php');
}

/**
 * Sets forced and added settings during login
 */
function set_forced_prefs() {
    global $username, $data_dir;
    global $fp_added_settings, $fp_forced_settings;

    foreach ($fp_added_settings as $pref => $value) {
        if (getPref($data_dir,$username,$pref) == '') {
            setPref($data_dir,$username,$pref,$value);
        }
    }

    foreach ($fp_forced_settings as $pref => $value) {
        setPref($data_dir,$username,$pref,$value);
    }
}

/**
 * Removes forced settings from option pages
 */
function fp_filter_optdata_internal() {
    global $optpage_data;

    // filter optpage_data values
    foreach ($optpage_data['vals'] as $key => $value) {
        $new_optpage_data['vals'][$key]=array_filter($value,'fp_filter_optdata_callback');
    }

    // add optpage_data extras (used in display hook)
    if (isset($optpage_data['xtra']))
        $new_optpage_data['xtra']=$optpage_data['xtra'];

    // add optpage_data groups
    // TODO: fix groups that contain only hidden inputs
    foreach ($optpage_data['grps'] as $key => $value) {
        if (! isset($new_optpage_data['vals'][$key]) ||
            $new_optpage_data['vals'][$key]!=array())
            $new_optpage_data['grps'][$key]=$optpage_data['grps'][$key];
    }

    // override old optpage data with new one
    $optpage_data=$new_optpage_data;
}

/**
 * callback function for array_filter call in fp_filter_optdata_internal.
 *
 * Removes forced preferences entries from optpage_data array
 * @param array $key squirrelmail option from optpage_data array.
 * @return bool true if setting is not enforced
 */
function fp_filter_optdata_callback($key) {
    global $fp_forced_settings;

    // php 4.1.0+ code
    if ( function_exists('array_key_exists')) {
        return (! array_key_exists($key['name'],$fp_forced_settings)); 
    // php 4.0.6 code (function is not present in 4.1.x)
    } elseif ( function_exists('key_exists')) {
        return (! key_exists($key['name'],$fp_forced_settings));
    } else {
        return true;
    }
}

/**
 * removes plugin hooks
 * @param array $orig_hooks
 * @return array filtered hooks
 */
function fp_filter_hooks($orig_hooks) {
    foreach ($orig_hooks as $hook => $plugin) {
        $filtered_hooks[$hook]=array_filter($plugin,'fp_filter_hooks_callback');
    }
    return $filtered_hooks;
}

/**
 * Filters hooks array
 * @param string $plugin_function plugin function name from hooks array
 * @return boolean true if function name is not present in $fp_disabled_hooks
 */
function fp_filter_hooks_callback($plugin_function) {
    global $fp_disabled_hooks;

    return (! in_array($plugin_function,$fp_disabled_hooks));
}

/**
 * Overrides settings if user manages to get to option form
 */
function fp_override_save_internal() {
    global $fp_forced_settings;

    foreach ($fp_forced_settings as $pref => $value) {
        setPref($data_dir,$username,$pref,$value);
    }
}
?>