<?php
/**
 * plugins/forced_prefs/config_default.php -- Default plugin configuration
 *
 * SquirrelMail Forced Prefs Plugin
 * Copyright (C) 2004-2005 Tomas Kuliavas <tokul@users.sourceforge.net>
 * This program is licensed under GPL. See COPYING for details
 *
 * @package sm-plugins
 * @subpackage forced_prefs
 * @version $Id: config_default.php,v 1.2 2005/01/24 18:07:47 tokul Exp $
 */

/**
 * lists settings that should be added, if not present in user's prefs
 * array should use setting names as array keys and setting values as
 * key values.
 *
 * @global array $fp_added_settings
 * @since 1.0
 */
global $fp_added_settings;
$fp_added_settings=array();

/**
 * lists settings that should be set during login. Enforced settings
 * are removed from option pages, if they use squirrelmail $optdata
 * array. array should use setting names as array keys and setting
 * values as key values.
 *
 * @global array $fp_forced_settings
 * @since 1.0
 */
global $fp_forced_settings;
$fp_forced_settings=array();

/**
 * lists functions that should be removed from enabled hooks
 *
 * WARNING. Use with caution. Disable only function calls that control
 * option display and saving. If you have problems with plugins - make
 * sure that problems can be reproduced without forced_prefs plugin.
 * @global array $fp_disabled_hooks
 * @since 1.1
 */
global $fp_disabled_hooks;
$fp_disabled_hooks=array();
?>