<?php
/**
 * plugins/forced_prefs/functions.php -- Functions used by plugin
 *
 * SquirrelMail Forced Prefs Plugin
 * Copyright (C) 2004 Tomas Kuliavas <tokul@users.sourceforge.net>
 * This program is licensed under GPL. See COPYING for details
 *
 * $Id: functions.php,v 1.4 2004/02/15 18:09:08 tomas Exp $
 */

function set_forced_prefs() {
  global $username, $data_dir;

  // load config
  if (file_exists(SM_PATH . 'config/forced_prefs_config.php')) {
    include_once(SM_PATH . 'config/forced_prefs_config.php');
  } elseif (file_exists(SM_PATH . 'plugins/forced_prefs/config.php')) {
    include_once(SM_PATH . 'plugins/forced_prefs/config.php');
  } else {
    // config file is not present. load defaults
    $fp_added_settings=array();
    $fp_forced_settings=array();
  }

  foreach ($fp_added_settings as $pref => $value) {
    if (getPref($data_dir,$username,$pref) == '') {
      setPref($data_dir,$username,$pref,$value);
    }
  }

  foreach ($fp_forced_settings as $pref => $value) {
    setPref($data_dir,$username,$pref,$value);
  }
}
?>