<?php
/* folder_sizes -- Version 1.4
 * By Robin Rainton <robin@rainton.com>
 * http://rainton.com/fun/freeware
 *
 * Utilise the "folders_bottom" and/or "left_main_after" hooks to display
 * (or link to display) folder size and messages count.
 */

require_once(SM_PATH . "/plugins/folder_sizes/folder_sizes_config.php");

function squirrelmail_plugin_init_folder_sizes() {
  global $squirrelmail_plugin_hooks;
  $squirrelmail_plugin_hooks['folders_bottom']['folder_sizes'] =
    'folder_sizes_folders_page';
  $squirrelmail_plugin_hooks['left_main_after']['folder_sizes'] =
    'folder_sizes_link';
  $squirrelmail_plugin_hooks['options_folder_inside']['folder_sizes'] =
    'folder_sizes_options';
  $squirrelmail_plugin_hooks['options_folder_save']['folder_sizes'] =
    'folder_sizes_save';
  $squirrelmail_plugin_hooks['loading_prefs']['folder_sizes'] =
    'folder_sizes_pref';
}

/*
 * These next two (folder_sizes_link and folder_sizes_folders_page) are called
 * to either show a link to our standalone page (folder_sizes.php) or to
 * output the folder size details (from the bottom of the Folders page via
 * it's hook.
 */

function folder_sizes_link()
{
  global $folder_sizes_left_link, $folder_sizes_link_button;
  
  if (!isset($folder_sizes_left_link) || !$folder_sizes_left_link) return;

  echo '<P><CENTER>';
  if ($folder_sizes_link_button)
  {
    echo '<form target="right" action="../plugins/folder_sizes/folder_sizes.php" method="get">';
    echo '<input class="small" type="submit" value="' . _('Folder Sizes') . '"></form>';
  }
  else
  {
    echo '<A HREF="../plugins/folder_sizes/folder_sizes.php" TARGET="right">' .
         _('Folder Sizes') . '</A>';
  }
  echo '</CENTER>';
}

function folder_sizes_folders_page()
{
  global $folder_sizes_on_folder_page;
  if (isset($folder_sizes_on_folder_page) && $folder_sizes_on_folder_page)
  {
    echo "<P>";
    folder_sizes_list();
  }
}

/*
 * Next few do the work.
 * First smaller one counts the messages and size in a mailbox folder.
 * Second outputs sub-totals for each level.
 * The third actually calculates all sizes and builds HTML table for these.
 */

function get_folder_size($imapConnection, $mailbox)
{
/*
 * Select the appropriate mailbox (folder) and retrieve message headers
 */

  $size = 0;
  $num_messages = sqimap_get_num_messages($imapConnection, $mailbox);
  if ($num_messages > 0) {
    $mbxresponse = sqimap_mailbox_select($imapConnection, $mailbox);
/*
 * Only grab small number of headers at a time.
*/
    $id = sqimap_get_php_sort_order($imapConnection, $mbxresponse);
    define("HEAD_BATCH", 50);
    while (count($id) > 0)
    {
      $msgs_list = sqimap_get_small_header_list($imapConnection, array_slice($id, 0, HEAD_BATCH));
/*
 * We have the headers list now - just add up the size and return it and count
 */
      foreach ($msgs_list as $hdr) { $size += $hdr['SIZE']; }
/*
 * Trash message list we no longer need.
 */
      unset($msgs_list);
/*
 * Next lot
 */
      $id = array_slice($id, HEAD_BATCH);
    }
  }

  return array($num_messages,
               sqimap_unseen_messages($imapConnection, $mailbox),
               $size);
}

/*
 * Sub to add the totals and subtotals for the passed depth.
 * If Depth is zero, this is the grand total and should be in bold.
 */

function folder_sizes_add_totals($from_depth, $to_depth)
{
  global $color;
  global $subfolders, $subcount, $subunread, $subsize, $tab_cols;

  for ($lp = $from_depth; $lp > $to_depth; $lp--) {
    $indent = $lp > 0 ? "<TD BGCOLOR=\"$color[4]\" COLSPAN=$lp>&nbsp;</TD>"
                     : "";
    echo "<TR BGCOLOR=\"$color[0]\">$indent<TD" .
         ($tab_cols - $lp > 3 ? " colspan=" . ($tab_cols - $lp - 3)
                              : "") . ">" .
         ($lp > 0 ? "" : "<B>") .
        $subfolders[$lp] . " " . ($subfolders[$lp] == 1 ? _('Folder') : _('Folders') ) .
         ($lp > 0 ? "" : "</B>") . "</TD>" .
         "<TD>" . ($lp > 0 ? "" : "<B>") .
         $subcount[$lp] .
         ($lp > 0 ? "" : "</B>") . "</TD>" .
         "<TD>" . ($lp > 0 ? "" : "<B>") .
         $subunread[$lp] .
         ($lp > 0 ? "" : "</B>") . "</TD>" .
         "<TD>" . ($lp > 0 ? "" : "<B>") .
         show_readable_size($subsize[$lp]) .
         ($lp > 0 ? "" : "</B>") . "</TD></TR>\n";

    $next_depth = $lp - 1;
    $subfolders[$next_depth] += $subfolders[$lp];
    $subcount[$next_depth] += $subcount[$lp];
    $subunread[$next_depth] += $subunread[$lp];
    $subsize[$next_depth] += $subsize[$lp];
  }
}

/*
 * Main functon for calculating and outputting folder list.
 */

function folder_sizes_list() {
  global $delimiter;

  $right_main = SM_PATH . "/src/right_main.php";

/*
 * First - we go about the business of getting a list of folders.
 */

  global $imapServerAddress, $imapPort;
  $imapConnection = sqimap_login ($_SESSION['username'], $_COOKIE['key'],
                                  $imapServerAddress, $imapPort, 0);
  $boxes = sqimap_mailbox_list($imapConnection);

/*
 * Work through the folder list and count messages in each.
 * We will add the message count for each folder to the original boxes
 * array. This is so we can determine how deep the directories are before we
 * start.
 * This is necessary because we need to know how many columns are going to
 * be presented to begin with.
 */

  $max_depth = 0;
  for ($boxnum = 0; $boxnum < count($boxes); $boxnum++) {

/*
 * Record new depth if it's greatest so far
 */

    $parts = explode($delimiter, $boxes[$boxnum]['unformatted-disp']);
    $boxes[$boxnum]['display'] = array_pop($parts);
    $boxes[$boxnum]['depth'] = count($parts);

    if ($boxes[$boxnum]['depth']  > $max_depth)
      $max_depth = $boxes[$boxnum]['depth'];

/*
 * Get sizes for this folder if it's selectable
 */

    if (!in_array('noselect', $boxes[$boxnum]['flags']))
    {
      list($count, $unread, $size) =
        get_folder_size($imapConnection, $boxes[$boxnum]['unformatted']);
      $boxes[$boxnum]['count'] = $count;
      $boxes[$boxnum]['unread'] = $unread;
      $boxes[$boxnum]['size'] = $size;
    }
  }

  global $tab_cols;
  $tab_cols = $max_depth + 4;

/*
 * Now we know how many columns the table will have, send it out.
 * Start the table in the same way as others on Folders page, so everything
 * looks nice and neat.
 * This also looks nice on it's own page luckily ;-)
 */

  $indent_width = 20;

  global $color;
  echo "<TABLE BGCOLOR=\"$color[0]\" WIDTH=\"70%\" COLS=1 ALIGN=CENTER cellpadding=1 cellspacing=0 border=0>\n";
  echo "<TR><TD><TABLE BGCOLOR=\"$color[0]\" WIDTH=\"100%\" ALIGN=CENTER cellpadding=3 cellspacing=1 border=0>\n".
       "<COLGROUP>" . ($tab_cols > 4 ? "<col span=" . ($tab_cols - 4) . " width=$indent_width>"
                                     : "") .
       "<col width=\"*\"><col span=3 width=\"5%\" align=\"right\"></colgroup>\n" .
       "<TR><TD ALIGN=CENTER COLSPAN=$tab_cols><B>" . _('Folder Sizes') .
       "</B></TD></TR>\n";
/*
 * Table heading is color 5
 */

  echo "<TR BGCOLOR=\"$color[5]\" ALIGN=\"center\"><TD COLSPAN=" . ($tab_cols - 3) .
       "><B>" . _('Folder') . "</B></TD>" .
       "<TD><B>" . _('Count') . "</B></TD><TD><B>" . _('Unread') .
       "</B></TD><TD><B>" . _('Size') . "</B></TD></TR>\n";

  global $use_special_folder_color, $folder_sizes_subtotals;

/*
 * Have to make the following global so the folder_sizes_add_totals function
 * can see them.
 */

  global $subfolders, $subcount, $subunread, $subsize;

  $last_depth = 0;
  for ($boxnum = 0; $boxnum < count($boxes); $boxnum++) {
/*
 * If we are keeping subtotals show last one(s)
 */
    if ($folder_sizes_subtotals && $last_depth > $boxes[$boxnum]['depth']) {
      folder_sizes_add_totals($last_depth,  $boxes[$boxnum]['depth']);
      $last_depth = $boxes[$boxnum]['depth'];
    }

/*
 * Indent sub-folders
 */

    $indent = $boxes[$boxnum]['depth'] > 0
            ? "<TD COLSPAN=" . $boxes[$boxnum]['depth'] . ">&nbsp;</TD>"
            : "";

/*
 * How many columns will this folder name cross?
 * For non-selectable is number of cols - depth
 * For other is number of cols - depth - 3
 */

    $use_cols = in_array('noselect', $boxes[$boxnum]['flags'])
              ? $tab_cols - $boxes[$boxnum]['depth']
              : $tab_cols - $boxes[$boxnum]['depth'] - 3;
/*
 * Make a link to each folder - it's a bit friendlier.
 * Of course - use a special colour for those special folders.
 */

    $special_color = ($use_special_folder_color &&
                      isSpecialMailbox($boxes[$boxnum]['unformatted']));
	
    echo "<TR BGCOLOR=\"$color[4]\">" . $indent .
       "<TD" . ($use_cols > 1 ? " COLSPAN=$use_cols" : "") . ">" .
       (in_array('noselect', $boxes[$boxnum]['flags'])
        ? ""
        : "<A HREF=\"$right_main?sort=0&amp;startMessage=1&amp;mailbox=" .
          urlencode($boxes[$boxnum]['unformatted']) . "\" TARGET=\"right\" " .
          "STYLE=\"text-decoration:none\">") .
       ($special_color ? "<FONT COLOR=\"$color[11]\">" : "") .
       $boxes[$boxnum]['display'] .
       (in_array('noselect', $boxes[$boxnum]['flags']) ? "" : "</A>") .
       "</TD>";

/*
 * If we are moving down a level, reset the counters for when
 * the subtotal is (perhaps) displayed.
 */

    if ($last_depth < $boxes[$boxnum]['depth']) {
      $last_depth = $boxes[$boxnum]['depth'];
      $subfolders[$last_depth] = 0;
      $subcount[$last_depth] = 0;
      $subunread[$last_depth] = 0;
      $subsize[$last_depth] = 0;
    }

/*
 * Show counts (and add to subtotals) for selectable
 */

    if (!in_array('noselect', $boxes[$boxnum]['flags'])) {
      echo "<TD>" . $boxes[$boxnum]['count'] . "</TD>" .
           "<TD>" . $boxes[$boxnum]['unread'] . "</TD>" .
           "<TD>" . show_readable_size($boxes[$boxnum]['size']) . "</TD>";

      $subfolders[$last_depth]++;
      $subcount[$last_depth] += $boxes[$boxnum]['count'];
      $subunread[$last_depth] += $boxes[$boxnum]['unread'];
      $subsize[$last_depth] += $boxes[$boxnum]['size'];
    }
    echo "</TR>\n";
  }

/*
 * Grand totals
 */

  folder_sizes_add_totals($last_depth,  -1);

/*
 * We're done - close table, connection and return
 */

  echo "</TABlE></TABLE>\n";

  sqimap_logout($imapConnection);
}

/*
 * Here come the few functions for preference handling.
 */

function folder_sizes_options()
{
  global $folder_sizes_left_link, $folder_sizes_on_folder_page,
         $folder_sizes_subtotals;
  
  echo '<tr><td align=right nowrap valign="top">' . _('Show Folder Sizes:') .
       '</td><td>' .
       '<input type=checkbox name="folder_sizes_folder_sizes_left_link"';

  if (isset($folder_sizes_left_link) && $folder_sizes_left_link)
     echo ' CHECKED';

  echo '> '. _('As link under folder list') . '<br>' .
       '<input type=checkbox name="folder_sizes_folder_sizes_on_folder_page"';

  if (isset($folder_sizes_on_folder_page) && $folder_sizes_on_folder_page)
     echo ' CHECKED';

  echo '> ' . _('On Folders page') . '<BR>' .
       '<input type=checkbox name="folder_sizes_folder_sizes_subtotals"';

  if (isset($folder_sizes_subtotals) && $folder_sizes_subtotals)
     echo ' CHECKED';

  echo '> ' . _('With subtotals') .
       '</td></tr>';
}

function folder_sizes_save()
{
  global $username, $data_dir;

  setPref($data_dir, $username, "folder_sizes_left_link",
          isset($_POST['folder_sizes_folder_sizes_left_link']) ? "1" : "0");
  setPref($data_dir, $username, "folder_sizes_on_folder_page",
          isset($_POST['folder_sizes_folder_sizes_on_folder_page']) ? "1" : "0");
  setPref($data_dir, $username, "folder_sizes_subtotals",
          isset($_POST['folder_sizes_folder_sizes_subtotals']) ? "1" : "0");
}

function folder_sizes_pref()
{ 
  global $username, $data_dir;
  global $folder_sizes_left_link, $folder_sizes_on_folder_page,
         $folder_sizes_subtotals;

  $folder_sizes_left_link = getPref($data_dir, $username, 'folder_sizes_left_link');
/*
 * Default for the folders link is to show, so set if it's not explicitly removed.
 */
  if (!isset($folder_sizes_left_link)) $folder_sizes_left_link = 1;

  $folder_sizes_on_folder_page = getPref($data_dir, $username, 'folder_sizes_on_folder_page');
  $folder_sizes_subtotals = getPref($data_dir, $username, 'folder_sizes_subtotals');
}

?>
