<?php

/**
 * Message and Spam Filter Plugin
 *
 * Copyright (c) 1999-2002 The SquirrelMail Project Team
 * Licensed under the GNU GPL. For full terms see the file COPYING.
 *
 * This plugin filters your inbox into different folders based upon given
 * criteria. It is most useful for people who are subscibed to mailing lists
 * to help organize their messages.  The argument stands that filtering is
 * not the place of the client, which is why this has been made a plugin for
 * SquirrelMail.  You may be better off using products such as Sieve or
 * Procmail to do your filtering so it happens even when SquirrelMail isn't
 * running.
 *
 * If you need help with this, or see improvements that can be made, please
 * email me directly at the address above.  I definately welcome suggestions
 * and comments.  This plugin, as is the case with all SquirrelMail plugins,
 * is not directly supported by the developers.  Please come to me off the
 * mailing list if you have trouble with it.
 *
 * Also view plugins/README.plugins for more information.
 *
 * $Id: options.php,v 1.5 2002/11/11 20:15:15 savkar Exp $
 */

   chdir ('..');
   require_once('../src/validate.php');
   require_once('../functions/page_header.php');
   require_once('../functions/imap.php');
   require_once('../src/load_prefs.php');

   global $AllowSpamFilters;
   global $ServerSideFilters;
   global $ServerSideSetup;

   $submitfilter = false;

   if ($ServerSideFilters) { 

     require_once('../plugins/filters/'.$ServerSideSetup.'.php');
   } else {

     /* Set up the basic filter list: Modules have their own */
     $filterlist[0] = 'From';
     $filterlist[1] = 'To';
     $filterlist[2] = 'Cc';
     $filterlist[3] = 'To or Cc';
     $filterlist[4] = 'Subject';
     $filterlist[5] = 'Header';

     /* Set up the actions for the various filters: Modules have their own */
     $filteraction[0] = 'Move';
   }

   displayPageHeader($color, 'None');

   $username = $_SESSION['username'];
   $key = $_COOKIE['key'];
   $onetimepad = $_SESSION['onetimepad'];
   $delimiter = $_SESSION['delimiter'];
   if(isset($_GET['theid'])) {
       $theid = $_GET['theid'];
   }
   if(isset($_POST['theid'])) {
       $theid = $_POST['theid'];
   }
   if(isset($_GET['action'])) {
       $action = $_GET['action'];
   }

   if (isset($_POST['filter_submit'])) {
      $submitfilter = true;
      if(isset($_GET['theid'])) {
          $theid = $_GET['theid'];
      } elseif (isset($_POST['theid'])) {
          $theid = $_POST['theid'];
      } else {
          $theid = 0;
      }
      $filter_what   = $_POST['filter_what'];
      $filter_where  = $_POST['filter_where'];
      $filter_folder = $_POST['filter_folder'];

      $filter_what = ereg_replace(",", " ", $filter_what);
      $filter_what = str_replace("\\\\", "\\", $filter_what);
      $filter_what = str_replace("\\\"", "\"", $filter_what);
      $filter_what = str_replace("\"", "&quot;", $filter_what);

      if (($filter_where == 'Header') && (strchr($filter_what,':') == '')) {
         print ('WARNING! Header filters should be of the format "Header: value"<BR>');
	 $action = 'edit';
      }
      setPref($data_dir, $username, "filter".$theid, $filter_where.",".$filter_what.",".$filter_folder.",".$filter_action);
      $filters[$theid]["where"] = $filter_where;
      $filters[$theid]["what"] = $filter_what;
      $filters[$theid]["folder"] = $filter_folder;
      $filters[$theid]["action"] = $filter_action;
   } elseif (isset($action) && $action == 'delete') {
      remove_filter($theid);
   } elseif (isset($action) && $action == 'move_up') {
      filter_swap($theid, $theid - 1);
   } elseif (isset($action) && $action == 'move_down') {
      filter_swap($theid, $theid + 1);
   } elseif (isset($_POST['user_submit'])) {
       setPref($data_dir, $username, 'filters_user_scan', $_POST['filters_user_scan_set']);
       echo "<br><center><b>"._("Saved Scan type")."</b></center>\n";
   }

   $filters = load_filters();
   $filters_user_scan = getPref($data_dir, $username, 'filters_user_scan');

  $filterbanner = ($ServerSideFilters) ? _("Server Side Message Filtering"):_("User Side Message Filtering");
  $tmp = ($ServerSideFilters) ? "": '<br><form method=post action="options.php">'.
        '<center>'.
        '<table cellpadding=2 cellspacing=0 border=0>'.
        '<tr>'.
            '<th align=right nowrap>' . _("What to Scan:") . '</th>'.
            '<td><select name="filters_user_scan_set">'.
            '<option value=""';

   echo '<br>' .
        '<table width=95% align=center border=0 cellpadding=2 cellspacing=0>'.
        "<tr><td bgcolor=\"$color[0]\">".
        '<center><b>' . _("Options") . ' -  ' .$filterbanner. '</b></center>'.
        '</td></tr></table>'.$tmp;

    if (!$ServerSideFilters) {

      if ($filters_user_scan == '') {
          echo ' SELECTED';
      }
      echo '>' . _("All messages") . '</option>'.
              '<option value="new"';
      if ($filters_user_scan == 'new') {
          echo ' SELECTED';
      }
      echo '>' . _("Only unread messages") . '</option>' .
              '</select>'.
          '</td>'.
          '<td><input type=submit name="user_submit" value="' . _("Save") . '"></td></tr>'.
          '</table>'.
          '</center>'.
          '</form>';
      }

      echo '<center>[<a href="options.php?action=add">' . _("New") .
        '</a>] - [<a href="../../src/options.php">' . _("Done") . '</a>]</center><br>';

    if (isset($action) && ($action == 'add' || $action == 'edit')) {
        $username = $_SESSION['username'];
        $key = $_COOKIE['key'];

        $imapConnection = sqimap_login($username, $key, $imapServerAddress, $imapPort, 0);
        $boxes = sqimap_mailbox_list($imapConnection);
        sqimap_logout($imapConnection);
        if ( !isset($theid) ) {
            $theid = count($filters);
        }
        echo '<center>'.
             '<form action="options.php" method=post>'.
             '<table cellpadding=2 cellspacing=0 border=0>'.
             '<tr>'.
                '<td align=right>' . _("Match:") . '</td>'.
                '<td>'.
                    '<select name=filter_where>';

        $L = isset($filters[$theid]['where']);

        for ($i = 0; $i < count($filterlist); $i++) {

          $sel = (($L && $filters[$theid]['where'] == $filterlist[$i])?'selected':'');
          echo "<option value=\"$filterlist[$i]\" $sel>" . _ ($filterlist[$i]) . '</option>';
        }

        echo         '</select>'.
                '</td>'.
            '</tr>'.
            '<tr>'.
                '<td align=right>'.
                    _("Contains:").
                '</td>'.
                '<td>'.
                    '<input type=text size=32 name=filter_what value="';
        if (isset($filters[$theid]['what'])) {
            echo $filters[$theid]["what"];
        }
        echo '">'.
                '</td>'.
            '</tr>'.
            '<tr>'.
	  '<td>';


	/*  Special case if only one filter action.  No need for selection. */
	if (count($filteraction) == 1) {

          echo $filteraction[0];
          echo '<input type=submit name=filter_action value=' . _($filteraction[0]) . '>';
	} else {

            echo '<select name=filter_action>';

            $L = isset($filters[$theid]['action']);

            for ($i = 0; $i < count($filteraction); $i++) {

              $sel = (($L && $filters[$theid]['action'] == $filteraction[$i])?'selected':'');
              echo "<option value=\"$filteraction[$i]\" $sel>" . _($filteraction[$i]) . '</option>';
            }
	}
            echo '</select>';

	    echo _(" to:").
                '</td>'.
                '<td>'.
                    '<tt>'.
                    '<select name=filter_folder>';

        for ($i = 0; $i < count($boxes); $i++) {
            if (! in_array('noselect', $boxes[$i]['flags'])) {
                $box = $boxes[$i]['unformatted'];
		/*                $box2 = str_replace(' ', '&nbsp;', $boxes[$i]['formatted']); */
                if (isset($filters[$theid]['folder']) &&
                    $filters[$theid]['folder'] == $box)
                echo "<OPTION VALUE=\"$box\" SELECTED>$box</option>";
                else
                echo "<OPTION VALUE=\"$box\">$box</option>";
            }
        }
        echo         '</tt>'.
                    '</select>'.
                '</td>'.
            '</tr>'.
            '</table>'.
            '<input type=submit name=filter_submit value=' . _("Submit") . '>'.
            "<input type=hidden name=theid value=$theid>".
            '</form>'.
            '</center>';

    }

	echo '<table border=0 cellpadding=3 cellspacing=0 align=center>';

    /*
     * Server Side Filters-- call the server side filter function for storing the
     * filters.
     */

    if ($ServerSideFilters && ($submitfilter || (isset($action) && ($action != "edit") && ($action != "add")))) {

        eval("\$ok = $ServerSideSetup"."_StoreFilters( \$filters);");
	if (!$ok) {
          include_once( '../functions/display_messages.php' );
          logout_error( _("Filters: Error in $ServerSideSetup module"));
  	  exit;
	}
    }

    for ($i=0; $i < count($filters); $i++) {

        $clr = (($i % 2)?$color[0]:$color[9]);
        $fdr = ($folder_prefix)?str_replace($folder_prefix, "", $filters[$i]["folder"]):$filters[$i]["folder"];
        echo "<tr bgcolor=\"$clr\"><td><small>".
            "[<a href=\"options.php?theid=$i&action=edit\">" . _("Edit") . '</a>]'.
            '</small></td><td><small>'.
            "[<a href=\"options.php?theid=$i&action=delete\">" . _("Delete") . '</a>]'.
            '</small></td><td align=center><small>[';

        if (isset($filters[$i + 1])) {
            echo "<a href=\"options.php?theid=$i&action=move_down\">" . _("Down") . '</a>';
            if ($i > 0) {
                echo '&nbsp;|&nbsp;';
            }
        }
        if ($i > 0) {
            echo "<a href=\"options.php?theid=$i&action=move_up\">" . _("Up") . '</a>';
        }
        echo ']</small></td><td>-</td><td>';

	/* Special case for server side filtering where SPAM module can be hooked in.  Should
	 * be modularized with different server side filter functions eventually.
	 */
        if ($filters[$i]['where'] != "SPAM") {
          printf( _("If <b>%s</b> contains <b>%s</b> then <b>%s</b> to <b>%s</b>"), _($filters[$i]['where']), $filters[$i]['what'], $filters[$i]['action'], $fdr );
        } else {

          printf( _("If <b>%s</b> then <b>%s</b> to <b>%s</b>"), _($filters[$i]['where']), $filters[$i]['action'], $fdr );
        }

        echo '</td></tr>';
    }

    echo '</table>'.
      '<table width=80% align=center border=0 cellpadding=2 cellspacing=0">'.
          '<tr><td>&nbsp</td></tr>'.
      '</table>';
?>
