<?php

/**
 * Copyright (c) 1999-2002 The SquirrelMail Project Team
 * Licensed under the GNU GPL. For full terms see the file COPYING.
 *
 * $Id: maildrop.php,v 1.3 2002/11/11 20:15:15 savkar Exp $
 */

global $ServerSideUseSql;
global $AllowSpamFilters;


if ($ServerSideUseSql) {

  require_once('DB.php');
}

  /*********************************
   *          FILTER LIST
   *********************************/

  $filterlist[0] = "From";
  $filterlist[1] = "To";
  $filterlist[2] = "Cc";
  $filterlist[3] = "To or Cc";
  $filterlist[4] = "To or Delivered-To";
  $filterlist[5] = "Subject";
  $filterlist[6] = "Anyplace";

  $filteraction[0] = "Move";
  $filteraction[1] = "Copy";

  /*  Keep spam option as the last one.  This option allows for integration of spamassassin into
   *  this maildrop filtering approach, with use of spamc/spamd.  This can obviously be set to
   *  whatever your spam solution is in the switch section below.
   */

  if ($AllowSpamFilters) {

    $filterlist[count($filterlist)] = 'SPAM';
  }

  /*
   *  maildrop_StoreFilters( $filters)
   *
   *  Main function for iterating through list of filters, and 
   *  storing them into the proper .mailfilter file for the given user.  It can both be
   *  set to use a .mailfilter file in the user directory (if a local user) or in a virtual
   *  spot (if a virtual user with SQL support).
   */

  function maildrop_StoreFilters( $filters) {

    global $ServerSideUseSql;
    global $ServerSideSqlDSN;
    global $ServerSideSqlTable;
    global $ServerSideSqlID;
    global $ServerSideSqlHome;
    global $username, $data_dir, $onetimepad, $key, $imapServerAddress;

    /*  Set up for temporary file in the /var/data directory for updating the filter. */
 
    $filename = getHashedFile($username, $data_dir, "$username.mailfilter");
    if(!$fp = @fopen("$filename", 'w')) {
        include_once( '../functions/display_messages.php' );
        logout_error( sprintf( _(".mailfilter file, %s, could not be opened. Contact your system administrator to resolve this issue."), "$filename") );
	return 0;
    }

    /*  Create the code for the .mailfilter file */
    $filterline = "";
    for ($i=0; $i < count($filters); $i++) {

      switch ($filters[$i]['action']) {

      case 'Copy':
	$action = 'cc'; break;

      case 'Move':
      default :
	$action = 'to';
      }

        $fdr = ($folder_prefix)?str_replace($folder_prefix, "", $filters[$i]["folder"]):$filters[$i]["folder"];

	/* Remove reference to INBOX */
        $fdr = ereg_replace("^INBOX", "", $fdr);

	/***********************************************************
	 *            FILTER CODE SWITCH STATEMENT
         ***********************************************************/

	switch ($filters[$i]['where']) {

	case 'SPAM': /* Spam special case since up front xfilter with backend regexp match */
          $filterline = "xfilter \"/usr/bin/spamc -u $username\"\n".$filterline."if (/^X-Spam-Flag: YES/)\n{\n\t".$action." \"Maildir/".$fdr."\"\n}\n"; break;

        case 'To or Cc': /* To/Cc written as two separate conditionals (could be combined) */
  	  $filterline .= "if (/^To:.*".$filters[$i]['what']."/)\n{\n\t".$action." \"Maildir/".$fdr."\"\n}\n";
  	  $filterline .= "if (/^Cc:.*".$filters[$i]['what']."/)\n{\n\t".$action." \"Maildir/".$fdr."\"\n}\n"; break;

	case 'To or Delivered-To': /*  To/Delivered-to written as two separate conditions (could be combined) */
  	  $filterline .= "if (/^To:.*".$filters[$i]['what']."/)\n{\n\t".$action." \"Maildir/".$fdr."\"\n}\n";
  	  $filterline .= "if (/^Delivered-To:.*".$filters[$i]['what']."/)\n{\n\t".$action." \"Maildir/".$fdr."\"\n}\n"; break;

	case 'Anyplace': /*  Allow searches throughout the incoming email */
  	  $filterline .= "if (/".$filters[$i]['what']."/)\n{\n\t".$action." \"Maildir/".$fdr."\"\n}\n"; break;

	default:

	  /* Any other filter but the special cases */
  	  $filterline .= "if (/^".$filters[$i]['where'].":.*".$filters[$i]['what']."/)\n{\n\t".$action." \"Maildir/".$fdr."\"\n}\n";
	}
    }

    fwrite($fp, "#  Begin Squirrelmail Autogenerated .mailfilter\n#  (Do not edit by hand)\n\n");
    fwrite($fp, $filterline);
    fclose($fp);

    /*  Check to see whether sql lookups.  If so, and $userhome exists, then
        use this to copy over the .mailfilter for the virtual user */

    if ($ServerSideUseSql && ($userhome = maildrop_SqlLookupUserHome( $ServerSideSqlDSN, $ServerSideSqlTable, $ServerSideSqlID, $ServerSideSqlHome, $username))) {

        @copy($filename, "$userhome/.mailfilter");
        chmod("$userhome/.mailfilter", 0600);
        @unlink($filename);

    /* Either no entry for the local user or there are no SQL based virtual users at all */
    } else {

      /*  Use ftp functions to transfer over the .mailfilter file to the
       *  right location.
       */

      $password = OneTimePadDecrypt($key, $onetimepad);

      /*  Connect and log in */
      $conn = ftp_connect( $imapServerAddress);
      $login_result = ftp_login($conn, $username, $password);
      if ((!$conn) || (!$login_result)) { 

        echo "maildrop_StoreFilters: FTP connection has failed!";
        echo "Attempted to connect to $username:$imapServerAddress";
	return 0;
      }

      /*  Try to place the file */
      if (!ftp_put($conn, ".mailfilter", $filename, FTP_ASCII)) {

        echo "maildrop_StoreFilters: FTP upload has failed!";
        echo "Attempted to upload .mailfilter to $username:$imapServerAddress";
	return 0;
      }

      /*  Change the permissions so maildrop doesn't barf */
      if (!ftp_site($conn, "chmod 0600 .mailfilter")) {

	echo "maildrop_StoreFilters: ftp chmod of .mailfilter has failed!";
	return 0;
      }

      ftp_close($conn);
    }

    return 1;
  }

function maildrop_SqlLookupUserHome( $dsn, $table, $id, $home, $username) {      

    $dbh = DB::connect($dsn, true);
    if (DB::isError($dbh) || DB::isWarning($dbh)) {
        include_once( '../functions/display_messages.php' );
        logout_error( sprintf( _("maildrop_SqlLookupUserHome Database error : %s"),
                                            DB::errorMessage($dbh)));
	return "";
    }

    $query = sprintf("SELECT * FROM %s WHERE %s='%s'", $table, $id, $username);
    $res = $dbh->query($query);
    if (DB::isError($res)) {
        include_once( '../functions/display_messages.php' );
        logout_error( sprintf( _("maildrop_SqlLookupUserHome Database error : %s"),
                                            DB::errorMessage($dbh)));
	return "";
    }

    while ($row = $res->fetchRow(DB_FETCHMODE_ASSOC)) { $userhome = $row[$home];}

    /* If a user is not located in the mysql database, then we assume a local user */
    if (!isset($userhome)) {

      return "";
    }

    $dbh->disconnect();
    return $userhome;
}

?>
