<?php


function squirrelmail_plugin_init_file_manager() {

   global $squirrelmail_plugin_hooks;
   global $file_manager_config;
   global $mimetypes;


   include_once('../plugins/file_manager/config.php');
   include_once('../plugins/file_manager/mime_types.php');
   include_once('../functions/i18n.php');


   $squirrelmail_plugin_hooks['menuline']['file_manager'] = 'file_manager_link';


   // install "save local" handler for all known mime types
   //
   foreach (array_values($mimetypes) as $mimeType)
   {

      $squirrelmail_plugin_hooks['attachment ' . $mimeType]['file_manager'] = 'file_manager_save_attachment_link';

   }

}

function file_manager_link() {

   global $file_manager_config;
   bindtextdomain('file_manager', '../plugins/file_manager/locale');


   // get global variables for versions of PHP < 4.1
   //
   if ((float)substr(PHP_VERSION,0,3) < 4.1) {
      global $HTTP_SESSION_VARS;
      $_SESSION = $HTTP_SESSION_VARS;
   }


   include_once('../plugins/file_manager/config.php');


   // set to 0 for no debug (regular operation)
   // set to 1 to display the current username in
   //    place of the regular 'File Manager' link
   // set to 2 to dump out the contents of File 
   //    Manager's config settings at run time
   //
   $debug = 0;


   // show actual username -- this must match config file exactly
   //
   if ($debug == 1)
   {
      displayInternalLink('plugins/file_manager/file_manager.php', _($_SESSION['username']), '');
      echo '&nbsp;&nbsp;' . (in_array(strtolower($_SESSION['username']), array_keys($file_manager_config)));
      echo '&nbsp;&nbsp;';
   }

   
   // dump size and contents of config file for debugging...
   //
   else if ($debug == 2)
   {
      echo '<br><br>Number of users configured to use File Manager is ' . sizeof($file_manager_config) . '<br><br>';
      print_r($file_manager_config);
      echo '<hr>';
   }
   
   
   // non-debug (normal) functionality:
   //
   // only users who are allowed get to see the link...
   //
   else
   {   
      if (!in_array(strtolower($_SESSION['username']), array_keys($file_manager_config)))
         return;
         
      textdomain('file_manager');
      displayInternalLink('plugins/file_manager/file_manager.php', _("File Manager"), '');
      textdomain('squirrelmail');
      echo '&nbsp;&nbsp;';

   }


}


function file_manager_save_attachment_link(&$Args)   
{     

   global $file_manager_config;


   // get global variables for versions of PHP < 4.1
   //
   if ((float)substr(PHP_VERSION,0,3) < 4.1) {
      global $HTTP_SESSION_VARS;
      $_SESSION = $HTTP_SESSION_VARS;
   }


   include_once('../plugins/file_manager/config.php');


   if (!in_array(strtolower($_SESSION['username']), array_keys($file_manager_config)))
      return;


   // put "save locally" link for attachment
   //
   $Args[1]['file_manager']['href'] = '../plugins/file_manager/save_attachment.php?'
      . 'passed_id=' . $Args[3] . '&mailbox=' . $Args[4] . '&passed_ent_id=' . $Args[5];

   textdomain('file_manager');
   $Args[1]['file_manager']['text'] = _("save locally");     
   textdomain('squirrelmail');

}   


?>
