<?php


function doDownload($filename, $fullPath, $absolute_dl)
{

   header('Pragma: ');
   // from /src/download.php:  header('Cache-Control: cache');

   // from php.net:
   header('Expires: Mon, 26 Jul 1997 05:00:00 GMT');    // Date in the past
   header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT'); // always modified
   header('Cache-Control: no-store, no-cache, must-revalidate');  // HTTP/1.1
   header('Cache-Control: post-check=0, pre-check=0', false);
   header('Pragma: no-cache');                          // HTTP/1.0



   list($type0, $type1) = explode('/', getMimeType($fullPath));
   if (empty($type0)) $type0 = "application";
   if (empty($type1)) $type1 = "octet-stream";


   DumpHeaders($type0, $type1, $filename, $fullPath, ($absolute_dl=='true'));


   if (!($FILE = fopen($fullPath, 'r')))
   {
      echo ''; echo '';
      echo '<html><body>';
      echo '<h4>FILE DOES NOT EXIST OR PROBLEM OPENING FILE</h4>';
      echo '</body></html>';
      exit(1);
   }


   //fpassthru($FILE);
   //while (!feof($FILE)) { $buffer = fread($FILE, 4096); print $buffer; }
   while (!feof($FILE)) echo fread($FILE, 4096);

   fclose($FILE);

   exit;


}



   //
   // from here on is a modified rip-off of /src/download.php...
   //


/*
 * This function is verified to work with Netscape and the *very latest*
 * version of IE.  I don't know if it works with Opera, but it should now.
 */
function DumpHeaders($type0, $type1, $filename, $fullPath, $force) {

    // get global variables for versions of PHP < 4.1
    //
    if ((float)substr(PHP_VERSION,0,3) < 4.1) {
       global $HTTP_SERVER_VARS;
       $_SERVER = $HTTP_SERVER_VARS;
    }

    $HTTP_USER_AGENT = $_SERVER['HTTP_USER_AGENT'];

    $isIE = 0;

    if (strstr($HTTP_USER_AGENT, 'compatible; MSIE ') !== false &&
        strstr($HTTP_USER_AGENT, 'Opera') === false) {
        $isIE = 1;
    }

    if (strstr($HTTP_USER_AGENT, 'compatible; MSIE 6') !== false &&
        strstr($HTTP_USER_AGENT, 'Opera') === false) {
        $isIE6 = 1;
    }

    $filename = ereg_replace('[^-a-zA-Z0-9\.]', '_', $filename);

    // A Pox on Microsoft and it's Office!
    if (! $force) {
        // Try to show in browser window
        header("Content-Disposition: inline; filename=\"$filename\"");
        header("Content-Type: $type0/$type1; name=\"$filename\"");
        header("Content-Length: " . (filesize($fullPath)));
        header("Content-transfer-encoding: binary"); 
    } else {
        // Try to pop up the "save as" box
        // IE makes this hard.  It pops up 2 save boxes, or none.
        // http://support.microsoft.com/support/kb/articles/Q238/5/88.ASP
        // But, accordint to Microsoft, it is "RFC compliant but doesn't
        // take into account some deviations that allowed within the
        // specification."  Doesn't that mean RFC non-compliant?
        // http://support.microsoft.com/support/kb/articles/Q258/4/52.ASP
        //
        // The best thing you can do for IE is to upgrade to the latest
        // version
        if ($isIE && !isset($isIE6)) {
            // http://support.microsoft.com/support/kb/articles/Q182/3/15.asp
            // Do not have quotes around filename, but that applied to
            // "attachment"... does it apply to inline too?
            //
            // This combination seems to work mostly.  IE 5.5 SP 1 has
            // known issues (see the Microsoft Knowledge Base)
            header("Content-Disposition: inline; filename=$filename");

            // This works for most types, but doesn't work with Word files
            header("Content-Type: application/download; name=\"$filename\"");

            header("Content-Length: " . (filesize($fullPath)));
            header("Content-transfer-encoding: binary"); 

            // These are spares, just in case.  :-)
            //header("Content-Type: $type0/$type1; name=\"$filename\"");
            //header("Content-Type: application/x-msdownload; name=\"$filename\"");
            //header("Content-Type: application/octet-stream; name=\"$filename\"");
        } else {
            header("Content-Disposition: attachment; filename=\"$filename\"");
            // application/octet-stream forces download for Netscape
            header("Content-Type: application/octet-stream; name=\"$filename\"");

            header("Content-Length: " . (filesize($fullPath)));
            header("Content-transfer-encoding: binary"); 
        }
    }
}



function getMimeType($filename)
{

// apache's list of mimie types
//
$mimetypes = array(
    'ez'        => 'application/andrew-inset',
    'hqx'        => 'application/mac-binhex40',
    'cpt'        => 'application/mac-compactpro',
    'doc'        => 'application/msword',
    'bin'        => 'application/octet-stream',
    'dms'        => 'application/octet-stream',
    'lha'        => 'application/octet-stream',
    'lzh'        => 'application/octet-stream',
    'exe'        => 'application/octet-stream',
    'class'        => 'application/octet-stream',
    'so'        => 'application/octet-stream',
    'dll'        => 'application/octet-stream',
    'oda'        => 'application/oda',
    'pdf'        => 'application/pdf',
    'ai'        => 'application/postscript',
    'eps'        => 'application/postscript',
    'ps'        => 'application/postscript',
    'smi'        => 'application/smil',
    'smil'        => 'application/smil',
    'mif'        => 'application/vnd.mif',
    'xls'        => 'application/vnd.ms-excel',
    'ppt'        => 'application/vnd.ms-powerpoint',
    'wbxml'        => 'application/vnd.wap.wbxml',
    'wmlc'        => 'application/vnd.wap.wmlc',
    'wmlsc'        => 'application/vnd.wap.wmlscriptc',
    'bcpio'        => 'application/x-bcpio',
    'vcd'        => 'application/x-cdlink',
    'pgn'        => 'application/x-chess-pgn',
    'cpio'        => 'application/x-cpio',
    'csh'        => 'application/x-csh',
    'dcr'        => 'application/x-director',
    'dir'        => 'application/x-director',
    'dxr'        => 'application/x-director',
    'dvi'        => 'application/x-dvi',
    'spl'        => 'application/x-futuresplash',
    'gtar'        => 'application/x-gtar',
    'hdf'        => 'application/x-hdf',
    'js'        => 'application/x-javascript',
    'skp'        => 'application/x-koan',
    'skd'        => 'application/x-koan',
    'skt'        => 'application/x-koan',
    'skm'        => 'application/x-koan',
    'latex'        => 'application/x-latex',
    'nc'        => 'application/x-netcdf',
    'cdf'        => 'application/x-netcdf',
    'sh'        => 'application/x-sh',
    'shar'        => 'application/x-shar',
    'swf'        => 'application/x-shockwave-flash',
    'sit'        => 'application/x-stuffit',
    'sv4cpio'    => 'application/x-sv4cpio',
    'sv4crc'    => 'application/x-sv4crc',
    'tar'        => 'application/x-tar',
    'tcl'        => 'application/x-tcl',
    'tex'        => 'application/x-tex',
    'texinfo'    => 'application/x-texinfo',
    'texi'        => 'application/x-texinfo',
    't'            => 'application/x-troff',
    'tr'        => 'application/x-troff',
    'roff'        => 'application/x-troff',
    'man'        => 'application/x-troff-man',
    'me'        => 'application/x-troff-me',
    'ms'        => 'application/x-troff-ms',
    'ustar'        => 'application/x-ustar',
    'src'        => 'application/x-wais-source',
    'xhtml'        => 'application/xhtml+xml',
    'xht'        => 'application/xhtml+xml',
    'zip'        => 'application/zip',
    'au'        => 'audio/basic',
    'snd'        => 'audio/basic',
    'mid'        => 'audio/midi',
    'midi'        => 'audio/midi',
    'kar'        => 'audio/midi',
    'mpga'        => 'audio/mpeg',
    'mp2'        => 'audio/mpeg',
    'mp3'        => 'audio/mpeg',
    'aif'        => 'audio/x-aiff',
    'aiff'        => 'audio/x-aiff',
    'aifc'        => 'audio/x-aiff',
    'm3u'        => 'audio/x-mpegurl',
    'ram'        => 'audio/x-pn-realaudio',
    'rm'        => 'audio/x-pn-realaudio',
    'rpm'        => 'audio/x-pn-realaudio-plugin',
    'ra'        => 'audio/x-realaudio',
    'wav'        => 'audio/x-wav',
    'pdb'        => 'chemical/x-pdb',
    'xyz'        => 'chemical/x-xyz',
    'bmp'        => 'image/bmp',
    'gif'        => 'image/gif',
    'ief'        => 'image/ief',
    'jpeg'        => 'image/jpeg',
    'jpg'        => 'image/jpeg',
    'jpe'        => 'image/jpeg',
    'png'        => 'image/png',
    'tiff'        => 'image/tiff',
    'tif'        => 'image/tiff',
    'djvu'        => 'image/vnd.djvu',
    'djv'        => 'image/vnd.djvu',
    'wbmp'        => 'image/vnd.wap.wbmp',
    'ras'        => 'image/x-cmu-raster',
    'pnm'        => 'image/x-portable-anymap',
    'pbm'        => 'image/x-portable-bitmap',
    'pgm'        => 'image/x-portable-graymap',
    'ppm'        => 'image/x-portable-pixmap',
    'rgb'        => 'image/x-rgb',
    'xbm'        => 'image/x-xbitmap',
    'xpm'        => 'image/x-xpixmap',
    'xwd'        => 'image/x-xwindowdump',
    'igs'        => 'model/iges',
    'iges'        => 'model/iges',
    'msh'        => 'model/mesh',
    'mesh'        => 'model/mesh',
    'silo'        => 'model/mesh',
    'wrl'        => 'model/vrml',
    'vrml'        => 'model/vrml',
    'css'        => 'text/css',
    'html'        => 'text/html',
    'htm'        => 'text/html',
    'asc'        => 'text/plain',
    'txt'        => 'text/plain',
    'rtx'        => 'text/richtext',
    'rtf'        => 'text/rtf',
    'sgml'        => 'text/sgml',
    'sgm'        => 'text/sgml',
    'tsv'        => 'text/tab-separated-values',
    'wml'        => 'text/vnd.wap.wml',
    'wmls'        => 'text/vnd.wap.wmlscript',
    'etx'        => 'text/x-setext',
    'xsl'        => 'text/xml',
    'xml'        => 'text/xml',
    'mpeg'        => 'video/mpeg',
    'mpg'        => 'video/mpeg',
    'mpe'        => 'video/mpeg',
    'qt'        => 'video/quicktime',
    'mov'        => 'video/quicktime',
    'mxu'        => 'video/vnd.mpegurl',
    'avi'        => 'video/x-msvideo',
    'movie'        => 'video/x-sgi-movie',
    'ice'        => 'x-conference/x-cooltalk'
);

   if (in_array(substr(strrchr(strtolower($filename), '.'), 1), array_keys($mimetypes)))
      return $mimetypes[substr(strrchr(strtolower($filename), '.'), 1)];
   else
      return '/';

}

?>
