<?php
/*******************************************************************************

    Author ......... Jimmy Conner
    Contact ........ jimmy@advcs.org
    Home Site ...... http://www.advcs.org/
    Program ........ Extract Files
    Version ........ 0.1
    Purpose ........ Allows you to click an compressed attachment, and download the files
                     inside it individually

*******************************************************************************/

define('SM_PATH','../../');

/* SquirrelMail required files. */
require_once(SM_PATH . 'include/validate.php');
require_once(SM_PATH . 'functions/imap.php');
require_once(SM_PATH . 'functions/mime.php');

sqgetGlobalVar('key',          $key,          SQ_COOKIE);
sqgetGlobalVar('username',     $username,     SQ_SESSION);
sqgetGlobalVar('onetimepad',   $onetimepad,   SQ_SESSION);
sqgetGlobalVar('messages',     $messages,     SQ_SESSION);
sqgetGlobalVar('mailbox',      $mailbox,      SQ_GET);
sqgetGlobalVar('ent_id',       $ent_id,       SQ_GET);
sqgetGlobalVar('fname',        $fname,        SQ_GET);
sqgetGlobalVar('passed_id',    $passed_id,    SQ_GET);
sqgetGlobalVar('startMessage', $startMessage, SQ_GET);
sqgetGlobalVar('filen',         $filen,         SQ_GET);

global $uid_support;

$filename = SM_PATH . 'plugins/extract/compression/uncompress.php';
if (file_exists($filename))
   include_once($filename);
else
   return;

$imapConnection = sqimap_login($username, $key, $imapServerAddress, $imapPort, 0);
$mbx_response =  sqimap_mailbox_select($imapConnection, $mailbox);
$message2 = sqimap_get_message($imapConnection, $passed_id, $mailbox);

$message = $message2->getEntity($ent_id);
$header = $message->rfc822_header;
$body = mime_fetch_body ($imapConnection, $passed_id, $ent_id);
$body = decodeBody($body, $message->header->encoding);

$type = determinetype($fname, $body[0] . $body[1], $body[2] . $body[3]);
$u = @new $type();

$u -> uncompress($body, $fname);
if (isset($filen) && $filen != '')
   $u -> downloadfile($filen);
else {

   displayPageHeader($color, 'None');

   print "<TABLE WIDTH='100%' CELLPADDING='2' CELLSPACING='0' BORDER='0' ALIGN='CENTER'>";
   print "<TR><TD BGCOLOR='" . $color[9] . "' WIDTH='100%' ALIGN='CENTER'><B>" . _("Viewing File") . "</B> - $fname<br>";
   print "<a href='" . SM_PATH . "src/read_body.php?mailbox=$mailbox&passed_id=$passed_id&startMessage=$startMessage'>" . _("Back to Message") . "</a></b></td></tr></table><br><br>\n";
   print "<table border='0' cellpadding='1' cellspacing='0'><tr><td bgcolor=gray><table bgcolor='#FFFFFF' border='0' width='100%' cellpadding='1'  cellspacing='0'><tr><td><table width='100%' cellpadding=2 cellspacing=2>\n";
   print "<tr bgcolor='" . $color[9] . "'><td>&nbsp;" . _("Filename") . "</td><td><center>&nbsp;&nbsp;" . _("Size") . "&nbsp;&nbsp;</center></td></tr>\n";
   $c = 4;
   $x = 0;
   foreach ($u->file['files'] as $value) {
      print "<tr bgcolor='" . $color[$c]. "'><td>&nbsp;<a href=\"" . SM_PATH . "plugins/extract/view.php?mailbox=$mailbox&passed_id=$passed_id&startMessage=$startMessage&ent_id=$ent_id&filen=$x&fname=$fname\">" . $value['name'] . "</a>&nbsp;&nbsp;</td><td align=right>&nbsp;&nbsp;&nbsp;" . $value['size'] . "&nbsp;</td></tr>\n";
      $x++;
      if ($c == 12)
         $c = 4;
      else
         $c = 12;
   }
   print "</table></td></tr></table>\n";
}

?>