<?php

/**
  * SquirrelMail Empty Trash Plugin
  *
  * Copyright (c) 2004-2011 Paul Lesniewski <paul@squirrelmail.org>
  * Copyright (c) 2002-2003 Derek Battams <derek@battams.ca>
  *
  * Licensed under the GNU GPL. For full terms see the file COPYING.
  *
  * @package plugins
  * @subpackage empty_trash
  *
  */


global $loginLimit, $dayLimit, $empty_upon_login;



// Number of logins (or logouts, depending on the value of
// $empty_upon_login below) allowed before trash is to be
// emptied.
//
// Set to zero to disable.
//
// Note that setting this to 1 will empty users' trash
// folders EVERY TIME they log in (or out, depending on
// the value of $empty_upon_login below).
//
$loginLimit = 0; 



// Number of days between logins allowed before trash is to 
// be emptied.
//
// Set to zero to disable.
//
$dayLimit = 30;



// Should the trash folder be emptied upon login or logout?
//
//    1        = empty trash upon login
//    0 (zero) = empty trash upon logout
//
// WARNING: You should note that users tend NOT to sign out of
// their email, but when set to 0 (zero), trash folders will
// only be emptied if they do in fact use the sign out link.
//
$empty_upon_login = 1;



