<?php

/**
  * SquirrelMail Empty Folders Plugin
  * Copyright (c) 2003-2009 Paul Lesniewski <paul@squirrelmail.org>
  * Licensed under the GNU GPL. For full terms see the file COPYING.
  *
  * @package plugins
  * @subpackage empty_folders
  *
  */



/**
  * Places text and widgets on the folder page
  *
  */
function empty_folders_show_options_do() 
{

   global $username, $data_dir, $color, $show_empty_link_allow_override, 
          $show_purge_link_allow_override, $javascript_on,
          $show_purge_trash_button, $show_purge_trash_button_allow_override,
          $folders_to_show_purge_button, $confirm_delete_all_button,
          $folders_to_not_show_purge_button, $confirm_purge_button,
          $show_purge_button_allow_override, $confirm_empty_link,
          $folders_to_show_delete_all_button, $confirm_purge_link,
          $folders_to_not_show_delete_all_button, $folders_to_show_purge_link,
          $folders_to_not_show_purge_link, $folders_to_not_show_empty_link,
          $folders_to_show_empty_link, $show_delete_all_button_allow_override;


   // no user config?  bail.
   //
   include_once(SM_PATH . 'plugins/empty_folders/functions.php');
   empty_folders_init();
   if (!$show_purge_link_allow_override
    && !$show_empty_link_allow_override
    && !$show_purge_trash_button_allow_override
    && !$show_purge_button_allow_override
    && !$show_delete_all_button_allow_override)
      return;


   // grab new settings if user had just pressed the Save button
   //
   if (sqgetGlobalVar('empty_folders_form', $empty_folders_form, SQ_FORM)
    && $empty_folders_form)
   {

      // show purge trash button is easy...
      //
      if ($show_purge_trash_button_allow_override)
      {
         if (sqgetGlobalVar('show_purge_trash_button', $show_purge_trash, SQ_FORM)
          && !empty($show_purge_trash))
            setPref($data_dir, $username, 'show_purge_trash_button', 1);
         else
            setPref($data_dir, $username, 'show_purge_trash_button', 0);
      }


      // comfirm purge link is also easy
      //
      if ($show_purge_link_allow_override)
      {
         if (sqgetGlobalVar('confirm_purge_link', $confirm_purge_link, SQ_FORM)
          && !empty($confirm_purge_link))
            setPref($data_dir, $username, 'confirm_purge_link', 1);
         else
            setPref($data_dir, $username, 'confirm_purge_link', 0);
      }


      // so is comfirm empty
      //
      if ($show_empty_link_allow_override)
      {
         if (sqgetGlobalVar('confirm_empty_link', $confirm_empty_link, SQ_FORM)
          && !empty($confirm_empty_link))
            setPref($data_dir, $username, 'confirm_empty_link', 1);
         else
            setPref($data_dir, $username, 'confirm_empty_link', 0);
      }


      // as is comfirm delete-all
      //
      if ($show_delete_all_button_allow_override)
      {
         if (sqgetGlobalVar('confirm_delete_all_button', $confirm_delete_all_button, SQ_FORM)
          && !empty($confirm_delete_all_button))
            setPref($data_dir, $username, 'confirm_delete_all_button', 1);
         else
            setPref($data_dir, $username, 'confirm_delete_all_button', 0);
      }


      // and comfirm purge button
      //
      if ($show_purge_button_allow_override)
      {
         if (sqgetGlobalVar('confirm_purge_button', $confirm_purge_button, SQ_FORM)
          && !empty($confirm_purge_button))
            setPref($data_dir, $username, 'confirm_purge_button', 1);
         else
            setPref($data_dir, $username, 'confirm_purge_button', 0);
      }


      // get folders that should have a purge button
      //
      if ($show_purge_button_allow_override)
      {
         $empty_folders_show_purge_button = 0;
         sqgetGlobalVar('empty_folders_show_purge_button', $empty_folders_show_purge_button, SQ_FORM);
         if (!empty($empty_folders_show_purge_button) && is_array($empty_folders_show_purge_button))
         {
            $allFolders = '';
            foreach ($empty_folders_show_purge_button as $folder)
               $allFolders .= $folder . '###';
         }
         else
            // cannot use an empty value here, otherwise the plugin defaults
            // will take over again when user intended for NO folders to be
            // the correct behavior, so we use the set string "NONE"
            //
            $allFolders = 'NONE';

         setPref($data_dir, $username, 'empty_folders_show_purge_button', $allFolders);
      }


      // get folders that should have a delete all button
      //
      if ($show_delete_all_button_allow_override)
      {
         $empty_folders_show_delete_all = 0;
         sqgetGlobalVar('empty_folders_show_delete_all', $empty_folders_show_delete_all, SQ_FORM);
         if (!empty($empty_folders_show_delete_all) && is_array($empty_folders_show_delete_all))
         {
            $allFolders = '';
            foreach ($empty_folders_show_delete_all as $folder)
               $allFolders .= $folder . '###';
         }
         else
            // cannot use an empty value here, otherwise the plugin defaults
            // will take over again when user intended for NO folders to be
            // the correct behavior, so we use the set string "NONE"
            //
            $allFolders = 'NONE';

         setPref($data_dir, $username, 'empty_folders_show_delete_all', $allFolders);
      }


      // get folders that should have a purge link
      //
      if ($show_purge_link_allow_override)
      {
         $empty_folders_show_purge_link = 0;
         sqgetGlobalVar('empty_folders_show_purge_link', $empty_folders_show_purge_link, SQ_FORM);
         if (!empty($empty_folders_show_purge_link) && is_array($empty_folders_show_purge_link))
         {
            $allFolders = '';
            foreach ($empty_folders_show_purge_link as $folder)
               $allFolders .= $folder . '###';
         }
         else
            // cannot use an empty value here, otherwise the plugin defaults
            // will take over again when user intended for NO folders to be
            // the correct behavior, so we use the set string "NONE"
            //
            $allFolders = 'NONE';

         setPref($data_dir, $username, 'empty_folders_show_purge_link', $allFolders);
      }


      // get folders that should have an empty link
      //
      if ($show_empty_link_allow_override)
      {
         $empty_folders_show_empty_link = 0;
         sqgetGlobalVar('empty_folders_show_empty_link', $empty_folders_show_empty_link, SQ_FORM);
         if (!empty($empty_folders_show_empty_link) && is_array($empty_folders_show_empty_link))
         {
            $allFolders = '';
            foreach ($empty_folders_show_empty_link as $folder)
               $allFolders .= $folder . '###';
         }
         else
            // cannot use an empty value here, otherwise the plugin defaults
            // will take over again when user intended for NO folders to be
            // the correct behavior, so we use the set string "NONE"
            //
            $allFolders = 'NONE';

         setPref($data_dir, $username, 'empty_folders_show_empty_link', $allFolders);
      }

   }



   // grab user preference for purge trash button
   //
   if ($show_purge_trash_button_allow_override)
      $show_purge_trash_button = getPref($data_dir, $username,
                                         'show_purge_trash_button',
                                         $show_purge_trash_button);



   // grab user preference for confirm purge link
   //
   if ($show_purge_link_allow_override)
      $confirm_purge_link = getPref($data_dir, $username,
                                    'confirm_purge_link',
                                    $confirm_purge_link);



   // grab user preference for confirm empty link
   //
   if ($show_empty_link_allow_override)
      $confirm_empty_link = getPref($data_dir, $username,
                                    'confirm_empty_link',
                                    $confirm_empty_link);



   // grab user preference for confirm purge button
   //
   if ($show_purge_button_allow_override)
      $confirm_purge_button = getPref($data_dir, $username,
                                      'confirm_purge_button',
                                      $confirm_purge_button);



   // grab user preference for confirm delete all
   //
   if ($show_delete_all_button_allow_override)
      $confirm_delete_all_button = getPref($data_dir, $username,
                                           'confirm_delete_all_button',
                                           $confirm_delete_all_button);



   // grab user preference for purge button folders
   //
   if ($show_purge_button_allow_override)
      $allFolders = getPref($data_dir, $username,
                            'empty_folders_show_purge_button',
                            NULL);
   else
      $allFolders = NULL;



   // reformat folder list if not NULL (which means defaults apply below)
   //
   if ($allFolders == 'NONE') $allFolders = ''; // see note elsewhere about why we use "NONE"
   if (!is_null($allFolders)) $empty_folders_show_purge_button = explode('###', $allFolders);
   else $empty_folders_show_purge_button = NULL;



   // grab user preference for delete all button folders
   //
   if ($show_delete_all_button_allow_override)
      $allFolders = getPref($data_dir, $username,
                            'empty_folders_show_delete_all',
                            NULL);
   else
      $allFolders = NULL;



   // reformat folder list if not NULL (which means defaults apply below)
   //
   if ($allFolders == 'NONE') $allFolders = ''; // see note elsewhere about why we use "NONE"
   if (!is_null($allFolders)) $empty_folders_show_delete_all = explode('###', $allFolders);
   else $empty_folders_show_delete_all = NULL;



   // grab user preference for purge link folders
   //
   if ($show_purge_link_allow_override)
      $allFolders = getPref($data_dir, $username,
                            'empty_folders_show_purge_link',
                            NULL);
   else
      $allFolders = NULL;



   // reformat folder list if not NULL (which means defaults apply below)
   //
   if ($allFolders == 'NONE') $allFolders = ''; // see note elsewhere about why we use "NONE"
   if (!is_null($allFolders)) $empty_folders_show_purge_link = explode('###', $allFolders);
   else $empty_folders_show_purge_link = NULL;



   // grab user preference for empty link folders
   //
   if ($show_empty_link_allow_override)
      $allFolders = getPref($data_dir, $username, 
                            'empty_folders_show_empty_link',
                            NULL);
   else
      $allFolders = NULL;



   // reformat folder list if not NULL (which means defaults apply below)
   //
   if ($allFolders == 'NONE') $allFolders = ''; // see note elsewhere about why we use "NONE"
   if (!is_null($allFolders)) $empty_folders_show_empty_link = explode('###', $allFolders);
   else $empty_folders_show_empty_link = NULL;



   // prepare folder list for easy use by template
   //
   // create an array where each entry is a seven-element array keyed
   // by "displayable", "option_value", "show_empty_link", "show_purge_link",
   // "show_purge_button", "show_delete_all_button" and "is_special",
   // where the last five are boolean values
   //
   // this list excludes the trash folder, since it already will have
   // a "purge" link given to it by the SquirrelMail core and the message
   // list purge button is controlled by a separate setting
   //
   $ef_folder_listing = array();
/* ----- already tested these at the top of this function...
   if ($show_purge_link_allow_override
    || $show_empty_link_allow_override
    || $show_purge_button_allow_override
    || $show_delete_all_button_allow_override)
----- */
   {
      global $ef_folder_listing, $trash_folder, $boxes, $nbsp;
      if (!check_sm_version(1, 5, 2)) $nbsp = '&nbsp;';
      for ($i = 0; $i < count($boxes); $i++) 
      {
         if (strtolower($boxes[$i]['unformatted']) != strtolower($trash_folder)
          && strtolower($boxes[$i]['unformatted-dm'] != 'inbox.trash'))
         {
            $ef_folder_listing[$i]['option_value'] = $boxes[$i]['unformatted-dm'];
            $ef_folder_listing[$i]['displayable'] = str_replace(' ', $nbsp, imap_utf7_decode_local($boxes[$i]['unformatted-disp']));


            if (isSpecialMailbox($ef_folder_listing[$i]['option_value']))
               $ef_folder_listing[$i]['is_special'] = 1;
            else
               $ef_folder_listing[$i]['is_special'] = 0;



            // if the user specified a list before, just use it to
            // test for what folders have the purge link turned on
            //
            if (is_array($empty_folders_show_purge_link))
            {
               if (in_array($ef_folder_listing[$i]['option_value'], $empty_folders_show_purge_link))
                  $ef_folder_listing[$i]['show_purge_link'] = 1;
               else
                  $ef_folder_listing[$i]['show_purge_link'] = 0;
            }


            // or apply the defaults from the configuration file
            //
            // (link enabled if in default list, or if NOT in the
            // default "don't show" list (and that list is non-empty))
            //
            else
            {
               if (in_array($ef_folder_listing[$i]['option_value'], $folders_to_show_purge_link)
                || (!empty($folders_to_not_show_purge_link) && !in_array($ef_folder_listing[$i]['option_value'], $folders_to_not_show_purge_link)))
                  $ef_folder_listing[$i]['show_purge_link'] = 1;
               else
                  $ef_folder_listing[$i]['show_purge_link'] = 0;
            }



            // if the user specified a list before, just use it to
            // test for what folders have the empty link turned on
            //
            if (is_array($empty_folders_show_empty_link))
            {
               if (in_array($ef_folder_listing[$i]['option_value'], $empty_folders_show_empty_link))
                  $ef_folder_listing[$i]['show_empty_link'] = 1;
               else
                  $ef_folder_listing[$i]['show_empty_link'] = 0;
            }


            // or apply the defaults from the configuration file
            //
            // (link enabled if in default list, or if NOT in the
            // default "don't show" list (and that list is non-empty))
            //
            else
            {
               if (in_array($ef_folder_listing[$i]['option_value'], $folders_to_show_empty_link)
                || (!empty($folders_to_not_show_empty_link) && !in_array($ef_folder_listing[$i]['option_value'], $folders_to_not_show_empty_link)))
                  $ef_folder_listing[$i]['show_empty_link'] = 1;
               else
                  $ef_folder_listing[$i]['show_empty_link'] = 0;
            }



            // if the user specified a list before, just use it to
            // test for what folders have the purge button turned on
            //
            if (is_array($empty_folders_show_purge_button))
            {
               if (in_array($ef_folder_listing[$i]['option_value'], $empty_folders_show_purge_button))
                  $ef_folder_listing[$i]['show_purge_button'] = 1;
               else
                  $ef_folder_listing[$i]['show_purge_button'] = 0;
            }


            // or apply the defaults from the configuration file
            //
            // (button enabled if in default list, or if NOT in the
            // default "don't show" list (and that list is non-empty))
            //
            else
            {
               if (in_array($ef_folder_listing[$i]['option_value'], $folders_to_show_purge_button)
                || (!empty($folders_to_not_show_purge_button) && !in_array($ef_folder_listing[$i]['option_value'], $folders_to_not_show_purge_button)))
                  $ef_folder_listing[$i]['show_purge_button'] = 1;
               else
                  $ef_folder_listing[$i]['show_purge_button'] = 0;
            }



            // if the user specified a list before, just use it to
            // test for what folders have the delete all button turned on
            //
            if (is_array($empty_folders_show_delete_all))
            {
               if (in_array($ef_folder_listing[$i]['option_value'], $empty_folders_show_delete_all))
                  $ef_folder_listing[$i]['show_delete_all_button'] = 1;
               else
                  $ef_folder_listing[$i]['show_delete_all_button'] = 0;
            }


            // or apply the defaults from the configuration file
            //
            // (button enabled if in default list, or if NOT in the
            // default "don't show" list (and that list is non-empty))
            //
            else
            {
               if (in_array($ef_folder_listing[$i]['option_value'], $folders_to_show_delete_all_button)
                || (!empty($folders_to_not_show_delete_all_button) && !in_array($ef_folder_listing[$i]['option_value'], $folders_to_not_show_delete_all_button)))
                  $ef_folder_listing[$i]['show_delete_all_button'] = 1;
               else
                  $ef_folder_listing[$i]['show_delete_all_button'] = 0;
            }
         }
      }
   }


   sq_change_text_domain('empty_folders');


   if (check_sm_version(1, 5, 2))
   {
      global $oTemplate;

      $oTemplate->assign('show_purge_trash_button_allow_override', $show_purge_trash_button_allow_override);
      $oTemplate->assign('show_purge_button_allow_override', $show_purge_button_allow_override);
      $oTemplate->assign('show_delete_all_button_allow_override', $show_delete_all_button_allow_override);
      $oTemplate->assign('show_purge_link_allow_override', $show_purge_link_allow_override);
      $oTemplate->assign('show_empty_link_allow_override', $show_empty_link_allow_override);
      $oTemplate->assign('confirm_delete_all_button', $confirm_delete_all_button);
      $oTemplate->assign('confirm_purge_button', $confirm_purge_button);
      $oTemplate->assign('confirm_purge_link', $confirm_purge_link);
      $oTemplate->assign('confirm_empty_link', $confirm_empty_link);
      $oTemplate->assign('show_purge_trash_button', $show_purge_trash_button);
      $oTemplate->assign('ef_folder_listing', $ef_folder_listing);
      $oTemplate->assign('javascript_on', $javascript_on);
      $oTemplate->assign('color', $color);

      $output = $oTemplate->fetch('plugins/empty_folders/empty_folders_options.tpl');
      return array('folders_bottom' => $output);
   }
   else
   {
      global $t;
      $t = array(); // no need to put config vars herein, they are already globalized

      include_once(SM_PATH . 'plugins/empty_folders/templates/default/empty_folders_options.tpl');
   }


   sq_change_text_domain('squirrelmail');

}



