<?php

/**
  * empty_link.tpl
  *
  * Template for showing the empty/purge link next to a folder
  * name for the Empty Folders plugin.
  *
  * The following variables are available in this template:
  *
  * string  $link_text           The (pre-translated) link text string.
  * string  $title_text          The (pre-translated) link title attribute
  *                              text string.
  * string  $empty_uri           The URI of the script that performs the
  *                              empty action.
  * boolean $square_brackets     Determines whether or not [] brackets (if
  *                              TRUE) or () brackets (if FALSE) will be
  *                              used aroung the link.
  * string  $onclick             The contents of the onclick handler for
  *                              the link, which may be empty if not in use.
  *
  * Copyright (c) 2003-2008 Paul Lesniewski <paul@squirrelmail.org>,
  * Licensed under the GNU GPL. For full terms see the file COPYING.
  *
  * @package plugins
  * @subpackage empty_folders
  *
  */


// retrieve the template vars
//
extract($t);


?><small>&nbsp;&nbsp;<?php if ($square_brackets) echo '['; else echo '('; ?><a href="<?php echo $empty_uri; ?>" title="<?php echo $title_text; ?>" style="text-decoration:none"<?php if (!empty($onclick)) echo ' onclick="' . $onclick . '"'; ?>><?php echo $link_text; ?></a><?php if ($square_brackets) echo ']'; else echo ')'; ?></small><?php  /* no trailing whitespace so advanced folder tree in 1.5.2+ does not choke */
