<?php

/**
  * SquirrelMail Empty Folders Plugin
  * Copyright (c) 2003-2008 Paul Lesniewski <paul@squirrelmail.org>
  * Licensed under the GNU GPL. For full terms see the file COPYING.
  *
  * @package plugins
  * @subpackage empty_folders
  *
  */


global $show_purge_trash_button, $purge_trash_text, $purge_button_text,
       $delete_button_text, $show_purge_trash_button_allow_override,
       $show_purge_button_allow_override, $folders_to_show_delete_all_button,
       $folders_to_not_show_delete_all_button, $folders_to_not_show_purge_button,
       $show_delete_all_button_allow_override, $folders_to_show_purge_button,
       $confirm_purge_button, $confirm_delete_all_button, $purge_link_text,
       $empty_link_text, $purge_link_confirm_text, $empty_link_confirm_text,
       $purge_button_confirm_text, $delete_button_confirm_text, 
       $purge_button_title_text, $delete_button_title_text, 
       $purge_link_title_text, $delete_link_title_text, 
       $show_purge_link_allow_override, $confirm_purge_link,
       $folders_to_show_empty_link, $folders_to_not_show_empty_link,
       $confirm_empty_link, $show_empty_link_allow_override,
       $folders_to_not_show_purge_link, $folders_to_show_purge_link,
       $empty_folders_link_onclick, $empty_folders_button_onclick;



// -------------------------------------------------------------------
//
// FOLDER LIST PURGE/DELETE ALL LINK OPTIONS
//


// This is a list of folders that by default will have a
// "purge" link next to them in the folder list.  You may
// leave this empty if none should.
//
// The purge link will remove all messages in the folder
// permanently - without moving to the trash folder.
//
// If set, this value must contain the exact name(s) of
// the specified folder(s) (the format of which may depend
// on your IMAP server).
//
// The trash folder is not affected by this setting -
// SquirrelMail includes a purge trash link as native
// functionality.
//
// $folders_to_show_purge_link = array(
//    'INBOX',
//    'INBOX.Sent',
//    'INBOX.Mailing Lists',
// );
//
$folders_to_show_purge_link = array(
);



// This is a list of folders that by default will NOT have
// a "purge" link next to them in the folder list.  All
// other folders WILL have a "purge" link next to them if
// this setting is anything except an empty list.
//
// The purge link will remove all messages in the folder
// permanently - without moving to the trash folder.
//
// If any of the folders identified here overlap with
// $folders_to_show_purge_link, a purge link WILL be
// shown for that folder.
//
// If set, this value must contain the exact name(s) of
// the specified folder(s) (the format of which may depend
// on your IMAP server).
//
// The trash folder is not affected by this setting -
// SquirrelMail includes a purge trash link as native
// functionality.
//
// $folders_to_not_show_purge_link = array(
//    'INBOX',
//    'INBOX.Sent',
//    'INBOX.Mailing Lists',
// );
//
$folders_to_not_show_purge_link = array(
);



// When the user clicks the purge link, should they
// be presented with a confirmation message before
// the purge is performed?
//
// 0 = no, 1 = yes
//
$confirm_purge_link = 1;



// Allow users to determine what folders the purge
// link is to be shown next to?
//
$show_purge_link_allow_override = 1;



// This is a list of folders that by default will have an
// "empty" link next to them in the folder list.  You may
// leave this empty if none should.
//
// The empty link will move all messages in the folder
// to the trash folder.
//
// If set, this value must contain the exact name(s) of
// the specified folder(s) (the format of which may depend
// on your IMAP server).
//
// The trash folder is not affected by this setting -
// SquirrelMail includes a purge trash link as native
// functionality.
//
// $folders_to_show_empty_link = array(
//    'INBOX',
//    'INBOX.Sent',
//    'INBOX.Mailing Lists',
// );
//
$folders_to_show_empty_link = array(
);



// This is a list of folders that by default will NOT have
// an "empty" link next to them in the folder list.  All
// other folders WILL have an "empty" link next to them if
// this setting is anything except an empty list.
//
// The empty link will move all messages in the folder
// to the trash folder.
//
// If any of the folders identified here overlap with
// $folders_to_show_empty_link, an empty link WILL be
// shown for that folder.
//
// If set, this value must contain the exact name(s) of
// the specified folder(s) (the format of which may depend
// on your IMAP server).
//
// The trash folder is not affected by this setting -
// SquirrelMail includes a purge trash link as native
// functionality.
//
// $folders_to_not_show_empty_link = array(
//    'INBOX',
//    'INBOX.Sent',
//    'INBOX.Mailing Lists',
// );
//
$folders_to_not_show_empty_link = array(
);



// When the user clicks the empty link, should they
// be presented with a confirmation message before
// the empty is performed?
//
// 0 = no, 1 = yes
//
$confirm_empty_link = 1;



// Allow users to determine what folders the empty
// link is to be shown next to?
//
$show_empty_link_allow_override = 1;



// When a confirmation message is used upon link click, this
// is the JavaScript that is used to produce it.  You should
// never need to change this unless you know what you are
// doing.
//
// If you do, note that it will be encapsulated in double
// quotes and "###TEXT###" will be replaced with the
// appropriate confirmation message (configured elsewhere).
//
$empty_folders_link_onclick = 'if (!confirm(\'###TEXT###\')) return false;';



// -------------------------------------------------------------------
//
// MESSAGE LIST PURGE/DELETE ALL BUTTON OPTIONS
//


// Should the trash folder have a "purge all" button in it?
//
// 0 = no, 1 = yes
//
$show_purge_trash_button = 0;



// Allow users to determine if the purge button is to be shown
// in the trash folder?
//
$show_purge_trash_button_allow_override = 1;



// This is a list of folders that by default will have a
// "purge" button on the mailbox list page.  You may leave
// this empty if none should.
//
// The purge button will remove all messages in the folder
// permanently - without moving to the trash folder.
//
// If set, this value must contain the exact name(s) of
// the specified folder(s) (the format of which may depend
// on your IMAP server).
//
// The trash folder is not affected by this setting - see
// $show_purge_trash_button elsewhere.
//
// $folders_to_show_purge_button = array(
//    'INBOX',
//    'INBOX.Sent',
//    'INBOX.Mailing Lists',
// );
//
$folders_to_show_purge_button = array(
);



// This is a list of folders that by default will NOT have
// a "purge" button on the mailbox list page.  All other
// folders WILL have a "purge" button in them if this
// setting is anything except an empty list.
//
// The purge button will remove all messages in the folder
// permanently - without moving to the trash folder.
//
// If any of the folders identified here overlap with
// $folders_to_show_purge_button, a purge button WILL
// be shown for that folder.
//
// If set, this value must contain the exact name(s) of
// the specified folder(s) (the format of which may depend
// on your IMAP server).
//
// The trash folder is not affected by this setting - see
// $show_purge_trash_button elsewhere.
//
// $folders_to_not_show_purge_button = array(
//    'INBOX',
//    'INBOX.Sent',
//    'INBOX.Mailing Lists',
// );
//
$folders_to_not_show_purge_button = array(
);



// When the user clicks the purge button, should they
// be presented with a confirmation message before
// the purge is performed?
//
// 0 = no, 1 = yes
//
$confirm_purge_button = 1;



// Allow users to determine what folders the purge
// button is to be shown in?
//
$show_purge_button_allow_override = 1;



// This is a list of folders that by default will have a
// "delete all" button on the mailbox list page.  You may
// leave this empty if none should.
//
// The delete all button will move all messages in the
// folder to the trash folder.
//
// If set, this value must contain the exact name(s) of
// the specified folder(s) (the format of which may depend
// on your IMAP server).
//
// The trash folder is not affected by this setting - see
// $show_purge_trash_button elsewhere.
//
// $folders_to_show_delete_all_button = array(
//    'INBOX',
//    'INBOX.Sent',
//    'INBOX.Mailing Lists',
// );
//
$folders_to_show_delete_all_button = array(
);



// This is a list of folders that by default will NOT have
// a "purge" button on the mailbox list page.  All other
// folders WILL have a "purge" button in them if this
// setting is anything except an empty list.
//
// The delete all button will move all messages in the
// folder to the trash folder.
//
// If any of the folders identified here overlap with
// $folders_to_show_delete_all_button, a delete all
// button WILL be shown for that folder.
//
// If set, this value must contain the exact name(s) of
// the specified folder(s) (the format of which may depend
// on your IMAP server).
//
// The trash folder is not affected by this setting - see
// $show_purge_trash_button elsewhere.
//
// $folders_to_not_show_delete_all_button = array(
//    'INBOX',
//    'INBOX.Sent',
//    'INBOX.Mailing Lists',
// );
//
$folders_to_not_show_delete_all_button = array(
);



// When the user clicks the delete all button, should
// they be presented with a confirmation message before
// the deletion is performed?
//
// 0 = no, 1 = yes
//
$confirm_delete_all_button = 1;



// Allow users to determine what folders the delete
// all button is to be shown in?
//
$show_delete_all_button_allow_override = 1;



// When a confirmation message is used upon button click,
// this is the JavaScript that is used to produce it.  You
// should never need to change this unless you know what
// you are doing.
//
// If you do, note that it will be encapsulated in double
// quotes and "###TEXT###" will be replaced with the
// appropriate confirmation message (configured elsewhere).
//
$empty_folders_button_onclick = 'if (!confirm(\'###TEXT###\')) return false;';



// -------------------------------------------------------------------
//
// LANGUAGE OPTIONS
//


// You may change the text of the links and buttons that
// this plugin generates.  The following strings are
// included in the translation file for this plugin:
//
//    "Empty"
//    "empty"
//    "Empty Trash"
//    "Empty (%d) Messages"
//    "Purge"
//    "purge"
//    "Purge All"
//    "purge all"
//    "Purge Trash"
//    "Purge All (%d)"
//    "Purge (%d) Messages"
//    "Purge All (%d) Messages"
//    "Delete All"
//    "delete all"
//    "Delete All (%d)"
//    "Delete (%d) Messages"
//    "Delete All (%d) Messages"
//
// Note that if "%d" is found in the string, it will be replaced
// with the number of messages in the current folder.
//
// You can use any other string you like, but if you use something
// other than those strings above, the buttons/links will not be
// correctly translated into other languages unless you add the
// string(s) to your locale files manually.
// 
$purge_trash_text = "Purge All";
$purge_button_text = "Purge All";
$delete_button_text = "Delete All";
$purge_link_text = "Purge";
$empty_link_text = "Empty";



// You may also change the text of the confirmation (warning)
// messages for the links and buttons that this plugin generates.
// The following strings are included in the translation file
// for this plugin:
//
//    "This will permanently remove ALL messages from this folder.\\n\\nAre you sure you want to continue?"
//    "This will permanently remove ALL %d messages from this folder.\\n\\nAre you sure you want to continue?"
//    "This will delete ALL messages in this folder.\\n\\nAre you sure you want to continue?"
//    "This will delete ALL %d messages in this folder.\\n\\nAre you sure you want to continue?"
//    "Purge ALL messages in this folder - are you sure?"
//    "Purge ALL %d messages in this folder - are you sure?"
//    "Delete ALL messages in this folder - are you sure?"
//    "Delete ALL %d messages in this folder - are you sure?"
//
// Note that if "%d" is found in the string, it will be replaced
// with the number of messages in the current folder.
//
// You can use any other string you like, but if you use something
// other than those strings above, the confirmation/warning message
// will not be correctly translated into other languages unless you
// add the string(s) to your locale files manually.
// 
$purge_button_confirm_text = "This will permanently remove ALL messages from this folder.\\n\\nAre you sure you want to continue?";
$delete_button_confirm_text = "This will delete ALL messages in this folder.\\n\\nAre you sure you want to continue?";
$purge_link_confirm_text = "This will permanently remove ALL messages from this folder.\\n\\nAre you sure you want to continue?";
$empty_link_confirm_text = "This will delete ALL messages in this folder.\\n\\nAre you sure you want to continue?";



// You may change the text of the title attribute for the links
// and buttons that this plugin generates.  The following strings
// are included in the translation file for this plugin:
//
//    "Permanently remove ALL messages from this folder"
//    "Permanently remove ALL %d messages from this folder"
//    "Permanently remove all messages from this folder"
//    "Permanently remove all %d messages from this folder"
//    "Purge ALL messages in this folder"
//    "Purge ALL %d messages in this folder"
//    "Purge all messages in this folder"
//    "Purge all %d messages in this folder"
//    "Delete ALL messages in this folder"
//    "Delete ALL %d messages in this folder"
//    "Delete all messages in this folder"
//    "Delete all %d messages in this folder"
//    "Move ALL messages from this folder to the trash"
//    "Move ALL %d messages from this folder to the trash"
//    "Move all messages from this folder to the trash"
//    "Move all %d messages from this folder to the trash"
//
// Note that if "%d" is found in the string, it will be replaced
// with the number of messages in the current folder.
//
// You can use any other string you like, but if you use something
// other than those strings above, the confirmation/warning message
// will not be correctly translated into other languages unless you
// add the string(s) to your locale files manually.
//
$purge_button_title_text = "Permanently remove all messages from this folder";
$delete_button_title_text = "Delete all messages in this folder";
$purge_link_title_text = "Permanently remove all messages from this folder";
$delete_link_title_text = "Delete all messages in this folder";



