<?php

/**
  * SquirrelMail Empty Folders Plugin
  * Copyright (C) 2003-2005 Paul Lesneiwski <pdontthink@angrynerds.com>
  * This program is licensed under GPL. See COPYING for details
  *
  * @package plugins
  * @subpackage Empty Folders
  *
  */



if (!defined('SM_PATH')) define('SM_PATH', '../../');



if (file_exists(SM_PATH . 'include/validate.php'))
   include_once(SM_PATH . 'include/validate.php');
else
   include_once(SM_PATH . 'src/validate.php');


include_once (SM_PATH . 'functions/imap.php');
load_config('empty_folders', array('config.php.sample', 'config.php'));


global $imapServerAddress, $imapPort, $username, $key, $move_to_trash;


sqgetGlobalVar('username', $username, SQ_SESSION);
sqgetGlobalVar('key', $key, SQ_COOKIE);
sqgetGlobalVar('delimiter', $delimiter, SQ_SESSION);
sqgetGlobalVar('onetimepad', $onetimepad, SQ_SESSION);

sqgetGlobalVar('mailbox', $mailbox, SQ_FORM);
if (isset($mailbox)){
    $mailbox = urldecode( $mailbox );
}


// should we expunge or move to trash?
//
$empty_folders_link_behavior = getPref($data_dir, $username,
                                       'empty_folders_link_behavior',
                                       $default_empty_link_behavior);


// no longer needed
// do_hook('session_recall');

$imap_stream = sqimap_login($username, $key, $imapServerAddress, $imapPort, 0);


// figure out if there are any messages to delete
//
if (check_sm_version(1, 3)) 
{
   $mbx_response = sqimap_mailbox_select($imap_stream, $mailbox);
   $mbx_response = $mbx_response['EXISTS'];
} 
else 
{
   $mbx_response = sqimap_get_num_messages($imap_stream, $mailbox);
}


// if so, move to trash or expunge, depending on desired behavior
//
if ($mbx_response > 0) {

   sqimap_mailbox_select($imap_stream, $mailbox);

   // we override the "move_to_trash" functionality
   // on our own, based on user's preferences
   //
   $myMoveToTrash = $move_to_trash;
   if ($empty_folders_link_behavior == 'moveToTrash')
      $move_to_trash = true;
   else if ($empty_folders_link_behavior == 'expunge')
      $move_to_trash = false;


   // delete messages (or move to trash)
   //
   sqimap_messages_delete ($imap_stream, 1, '*', $mailbox);
   $move_to_trash = $myMoveToTrash;


   // empty out the mailbox
   //
   sqimap_mailbox_expunge($imap_stream, $mailbox, true);

}


$base_uri = sqm_baseuri();
header ('Location: ' . $base_uri . 'src/left_main.php');

sqimap_logout($imap_stream);

?>
