<?php

/**
  * SquirrelMail Empty Folders Plugin
  * Copyright (C) 2003, 2004 Paul Lesneiwski <pdontthink@angrynerds.com>
  * This program is licensed under GPL. See COPYING for details
  *
  */


   // include compatibility plugin
   //
   if (defined('SM_PATH'))
      include_once(SM_PATH . 'plugins/compatibility/functions.php');
   else if (file_exists('../plugins/compatibility/functions.php'))
      include_once('../plugins/compatibility/functions.php');
   else if (file_exists('./plugins/compatibility/functions.php'))
      include_once('./plugins/compatibility/functions.php');



// Display empty links on target folders
//
function empty_folders_show_link_do($parms) {

   global $data_dir, $username, $default_folders_to_show_empty_link;
   $numMessages = $parms[0];
   $real_box = $parms[1];
   $imapConnection = $parms[2];


   if (!defined('SM_PATH'))
      define('SM_PATH', '../');


   include_once (SM_PATH . 'plugins/empty_folders/config.php');


   // grab preferences
   //
   $allFolders = getPref($data_dir, $username, 'empty_folders_show_link', '');


   // load default folders if none have previously been chosen
   //
   if ($allFolders == 'NONE') $allFolders = '';
   else if ($allFolders == '')
   {
      $allFolders = implode('###', $default_folders_to_show_empty_link);
   }
   $empty_folders_show_link = explode('###', $allFolders);


   if (empty($numMessages)) {
      $numMessages = sqimap_get_num_messages($imapConnection, $real_box);
   }
   if ($numMessages > 0 && in_array($real_box, $empty_folders_show_link)) {
      bindtextdomain('empty_folders', SM_PATH . 'plugins/empty_folders/locale');
      textdomain('empty_folders');
      $urlMailbox = urlencode($real_box);
      $text = "<small>&nbsp;&nbsp;(<A HREF=\"../plugins/empty_folders/empty_folder.php?mailbox=$urlMailbox\" style=\"text-decoration:none\">"._("empty")."</A>)</small>";
      bindtextdomain('squirrelmail', SM_PATH . 'locale');
      textdomain('squirrelmail');
      return $text;
   }

}



// This is the text that appears on the option page
//
function empty_folders_show_options_do() {

   global $username, $data_dir, $color, $user_empty_link, 
          $user_empty_behavior, $default_empty_link_behavior,
          $default_folders_to_show_empty_link;


   // grab new settings if user had just pressed Save
   //
   global $empty_folders_form;
   compatibility_sqextractGlobalVar('empty_folders_form');
   if (isset($empty_folders_form) && $empty_folders_form)
   {

      // get behavior first; it's easy
      //
      global $empty_folders_link_behavior;
      compatibility_sqextractGlobalVar('empty_folders_link_behavior');
      setPref($data_dir, $username, 'empty_folders_link_behavior', $empty_folders_link_behavior);
      

      // get folders that should get an empty link
      //
      global $empty_folders_show_link;
      compatibility_sqextractGlobalVar('empty_folders_show_link');
      $allFolders = '';
      if (isset($empty_folders_show_link))
         foreach ($empty_folders_show_link as $folder)
            $allFolders .= $folder . '###';
      if (!isset($empty_folders_show_link) || count($empty_folders_show_link) == 0)
         $allFolders = 'NONE';
      setPref($data_dir, $username, 'empty_folders_show_link', $allFolders);

   }


   if (!defined('SM_PATH'))
      define('SM_PATH', '../');

   include_once (SM_PATH . 'plugins/empty_folders/config.php');


   // grab preferences
   //
   $empty_folders_link_behavior = getPref($data_dir, $username, 
                                          'empty_folders_link_behavior', 
                                          $default_empty_link_behavior);
   $allFolders = getPref($data_dir, $username, 'empty_folders_show_link', '');


   // load default folders if none have previously been chosen
   //
   if ($allFolders == 'NONE') $allFolders = '';
   else if ($allFolders == '')
   {
      $allFolders = implode('###', $default_folders_to_show_empty_link);
   }

   
   $empty_folders_show_link = explode('###', $allFolders);

   bindtextdomain('empty_folders', SM_PATH . 'plugins/empty_folders/locale');
   textdomain('empty_folders');

   if ($user_empty_link || $user_empty_behavior)
   {

      echo '<FORM METHOD="POST" NAME="empty_folders_links_form">'
         . '<input type="hidden" value="1" name="empty_folders_form">'
         . '<TABLE WIDTH="70%" COLS="1" ALIGN="CENTER" cellpadding="4" '
         . 'cellspacing="0" border="0">'
         . "<tr><td bgcolor=\"$color[4]\">&nbsp;</td></tr>\n"
         . "<TR><TD BGCOLOR=\"$color[9]\" ALIGN=CENTER><B>"
         . _("Empty Link")
         . '</B></TD></TR>'
         . "<TR><TD BGCOLOR=\"$color[0]\" ALIGN=CENTER>";
      if ($user_empty_link)
      {
         global $boxes, $trash_folder;
         $specialFolders = array();
         echo '<TABLE WIDTH="100%" BORDER="0"><TR><TD width="60%" align="right">'
            . '<SELECT NAME="empty_folders_show_link[]" multiple size="8">';
         for ($i = 0; $i < count($boxes); $i++) 
         {
            if (strtolower($boxes[$i]['unformatted']) != $trash_folder)
            {
               $box = $boxes[$i]['unformatted-dm'];
               $box2 = str_replace(' ','&nbsp;',imap_utf7_decode_local(
                                                $boxes[$i]['unformatted-disp']));
               if (strtolower($box) != 'inbox.trash') 
                  echo '<OPTION VALUE="' . $box . '"'
                     . (isset($empty_folders_show_link) 
                        && in_array($box, $empty_folders_show_link)
                        ? ' SELECTED' : '') . '>' . $box2 . "\n";

               // get special folder list for use below
               //
               if (isSpecialMailbox($box))
                  $specialFolders[] = $box2;

            }
         }

         echo '</SELECT></TD><TD valign="bottom">'
            . '&nbsp;&nbsp;<a href="#" onClick="list=document.empty_folders_links_form.elements[1]; for (i=0; i<list.length; i++) {if (';
         $first = true;
         foreach ($specialFolders as $specialFolder)
         {
            if (!$first) echo ' || ';
            else $first = false;
            echo 'list.options[i].text==\'' . $specialFolder . '\'';
         }
         echo ') { if (list.options[i].selected) list.options[i].selected=false; else list.options[i].selected=true; } } return false">' . _("Toggle Special Folders") . '</a><br><br>'
            . '&nbsp;&nbsp;<a href="#" onClick="list=document.empty_folders_links_form.elements[1]; for (i=0; i<list.length; i++) {if (list.options[i].selected) list.options[i].selected=false; else list.options[i].selected=true; } return false">' . _("Toggle All") . '</a></TD></TR></TABLE>';
         if ($user_empty_behavior)
            echo '<hr width="75%">';
      }
      if ($user_empty_behavior)
      {
         echo _("Link behavior") . ': <select name="empty_folders_link_behavior">'
            . '<option value="moveToTrash"'
            . (isset($empty_folders_link_behavior) 
               && $empty_folders_link_behavior == 'moveToTrash'
                  ? ' SELECTED' : '') . '>' . _("Move to Trash")
            . '<option value="expunge"'
            . (isset($empty_folders_link_behavior) 
               && $empty_folders_link_behavior == 'expunge'
                  ? ' SELECTED' : '') . '>' . _("Expunge")
            . '</select>';
      }
      echo '</TD></TR><TR><TD BGCOLOR="' . $color[0] 
         . '" align="right"><input type="submit" value="' 
         . _("Save") . '">'
         . '</TD></TR></TABLE></FORM>';

   }

   bindtextdomain('squirrelmail', SM_PATH . 'locale');
   textdomain('squirrelmail');

}



?>
