<?php

     /***************************************************
      *  Disk Quota Plugin                              *
      *  By Kerem Erkan <kerem.erkan@hacettepe.edu.tr>  *
      *  Version 3.0                                    *
      *  See INSTALL for usage details.                 *
      ***************************************************/

/*
 * Some explanation before we go on.
 * The typical output from quota command is like that:
 *
 *       Disk quotas for user dq_user (uid 501):
 *            Filesystem  blocks   quota   limit   grace   files   quota   limit   grace
 *              /dev/md0    8940       0       0             854       0       0
 *              /dev/hda2      0       0       0               0       0       0
 *              /dev/md1 2504904 3000000 3500000           10125       0       0
 *
 * We will divide blocks by quota and draw a graph.
*/

global $color;
$dq_usage_shown = 0;
$dq_click = 0;

putenv("LANG=C");
$dq_quota_binary = str_replace("_", " ", $dq_quota_binary);
$dq_your_disk_usage = str_replace("_", " ", $dq_your_disk_usage);
$dq_click_text = str_replace("_", " ", $dq_click_text);
$dq_click_text_multi = str_replace("_", " ", $dq_click_text_multi);
$dq_details_text = str_replace("_", " ", $dq_details_text);
exec("$dq_quota_binary -v $username", $quota_data, $return_data);

if ( sizeof($quota_data) > 2 ) {

    for ( $i=2 ; $i<sizeof($quota_data) ; $i++ ) {

        list($dq_fsname, $dq_blocks, $dq_quota, $dq_limit, $dq_grace) =
                split( "[[:blank:]]+", trim($quota_data[$i]) );

        if ( $dq_quota != 0 && $dq_quota <= $dq_limit ) {

                $dq_click++;
                if ( $dq_show_filesystem == 0 ) {
                        $dq_fsname = "-";
                }
                $dq_blocks = str_replace("*", "", $dq_blocks);
                $dq_grace = str_replace("day", ":day", $dq_grace);
                if ( $dq_blocks < $dq_quota ) {
                        $dq_grace = "-";
                }

if ( $dq_usage_text_shown == 0 ) {
        echo '<div align = "center">' .
             '<font color="' . $color[11] . '"><br><strong>' . $dq_your_disk_usage . '</strong><br></font>';
        $dq_usage_text_shown = 1;
}
echo '<object classid="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000"
 codebase="http://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=6,0,29,0"
 width="' . $dq_bar_width . '" height="' . $dq_bar_height . '">
 <param name="movie" value="' . $dq_sm_server . '/plugins/disk_quota/swf/quotaBar.swf">
 <param name=FlashVars value="' .
"dq_details_text=$dq_details_text&dq_sm_server=$dq_sm_server
&dq_fsname=$dq_fsname&dq_blocks=$dq_blocks&dq_quota=$dq_quota&dq_limit=$dq_limit&dq_grace=$dq_grace" .
'"><param name="quality" value="high">
 <embed src="' . $dq_sm_server . '/plugins/disk_quota/swf/quotaBar.swf" FlashVars="' .
"dq_details_text=$dq_details_text&dq_sm_server=$dq_sm_server
&dq_fsname=$dq_fsname&dq_blocks=$dq_blocks&dq_quota=$dq_quota&dq_limit=$dq_limit&dq_grace=$dq_grace" .
'" quality="high" pluginspage="http://www.macromedia.com/go/getflashplayer"
 type="application/x-shockwave-flash"
 width="' . $dq_bar_width . '" height="' . $dq_bar_height . '"></embed>
</object>
<br>';
        }
    }
    if ( $dq_click == 1 ) {
            echo $dq_click_text;
    }
    elseif ( $dq_click > 1 ) {
            echo $dq_click_text_multi;
    }
    echo '</div>';
}
?>
