<?php
if(!isset($_SESSION['prefs_cache']['left_size']))
    $left = '150';
else
    $left = $_SESSION['prefs_cache']['left_size'];

$dq_quota_binary = str_replace("_", " ", $dq_quota_binary);

global $color;
/*
 * Some explanation before we go on.
 * The typical output from quota command is like that:
 *
 *       Disk quotas for user username (uid 501):
 *            Filesystem  blocks   quota   limit   grace   files   quota   limit   grace
 *              /dev/md0    8940       0       0             854       0       0
 *              /dev/hda2      0       0       0               0       0       0
 *              /dev/md1 2504904 3000000 3500000           10125       0       0
 *
 * We will divide blocks by quota and draw a graph.
*/

putenv("LANG=C");
exec("$dq_quota_binary -v $username", $quota_data, $return_data);

while ( list($key,$val) = each($quota_data) ) {
    if( !eregi("^\/", trim($val)) ) continue;
    list($disk,$blocks,$quota,$limit) = split("[[:blank:]]+", trim($val));
    if( $quota != 0 || !$dq_show_verbose == 0 ) {
        $disks[$disk][used] = $blocks;
        $disks[$disk][quota] = $quota;
    }
} 


if( isset($disks) ) {
    array_multisort($disks);

    $dq_your_disk_usage = str_replace("_", " ", $dq_your_disk_usage);
    $dq_details = str_replace("_", " ", $dq_details);
    echo '<center>';

    echo '<a href="../plugins/disk_quota/disk_quota.php" target="right">';
    echo "<font color=\"$color[11]\">";
    echo '<strong>' . $dq_your_disk_usage . '</font><br></strong></a>';


    foreach($disks as $key => $val) {
        $used = $disks[$key]['used'];
        $quota = $disks[$key]['quota'];

        if ( $dq_use_gd == 1 && function_exists(imagecreate) ) {

	    if ( ($dq_show_verbose == 0) && ($used == 0 || $quota == 0) )
	        continue;
	
	    if ( $used == 0 || $quota == 0 ) {
                echo "<font size=\"1\"><br></font>";
    	        echo "<img src=\"../plugins/disk_quota/bar.php?left=$left&zero=1\"><br>";
                echo "<font size=\"1\"><br></font>";
	    }	

	    else {
    		$alt =  human_readable($used*1024). ' out of '. human_readable($quota*1024);
                echo "<font size=\"1\"><br></font>";
    	        echo "<img src=\"../plugins/disk_quota/bar.php?left=$left&usage=".
                     "$used&threshold=$quota\" alt=\"$alt\" title=\"$alt\"><br>";
                echo "<font size=\"1\"><br></font>";
	    }
        }

        else {

            if ( ($dq_show_verbose == 0) && ($used == 0) ) {
	        continue;
	    }

	    if ( $quota != 0)
                $dq_leftwidth = $used/$quota*100;
	    else
	        $dq_leftwidth = 0;

            settype($dq_leftwidth, "integer");
            $dq_rightwidth = 100 - $dq_leftwidth;

	    $dq_bar = "009900";		// Green < 70, Yellow < 90, or Red
            if ( $dq_leftwidth > 69 && $dq_leftwidth < 90 ) {
                $dq_bar = "FFCC00";
            } else if ( $dq_leftwidth > 89 ) {
                $dq_bar = "FF0000";
            }

	    $agent = $_SERVER['HTTP_USER_AGENT'];
	    list($browser,$ver,$x) = split('[/,(\[]',$agent,3);

	    if ( $browser == "Mozilla" && ( (false === strpos($agent,"MSIE")) && $ver < 5 ) || $browser == "Opera") {
		$MSIE = 0;		// Netscape 4.x or older
		$padding = ' cellpadding="1"';
		$style = "";
	    } else {
		$MSIE = 1;		// MSIE or compatible broswer
		$padding = ' cellpadding="0"';
		$style = ' bgcolor="#FFFFFF" style="border: #000000 1px solid; padding:1px; padding-right: 0px; padding-left: 0px;"';
	    }

            echo '<table width="100%" border="0" cellspacing="0" ' . "$padding bgcolor=\"$color[6]\">";
	    echo "<tr>\n";
	    echo '<td><table width="100%" border="0" cellpadding="0" cellspacing="0"' . "$style>";
	    echo "<tr>\n";

	    if ( $MSIE ) {
		$dq_width = $dq_leftwidth;
		if ( $dq_width > 100 ) { $dq_width = 100; }
		if ( $dq_leftwidth == 0 ) {
		   $dq_bar = "#FFFFFF";				// Mac IE 5.2
		   $dq_width = 1;				// Konqueror 3.0.4
		}
	        echo "<td width=\"100%\"><div style=\"height:6px; width:$dq_width%; font-size:3px; background-color:$dq_bar\"></div></font></td>";
	    } else {
		if ( $dq_leftwidth > 0 ) {
		   echo "<td width=\"$dq_leftwidth%\" bgcolor=\"#$dq_bar\"><font size=\"-2\">&nbsp;</font></td>";
		}
		if ( $dq_rightwidth > 0 ) { 
		   echo "<td width=\"$dq_rightwidth%\" bgcolor=\"#FFFFFF\"><font size=\"-2\">&nbsp;</font></td>";
		}
	    }

            echo "</tr>\n";
            echo "</table></td></table>";
	    if ( $dq_leftwidth > 99 ) {
		echo "$key: <font color=\"$color[2]\">100%</font><br>";
	    } else {
                echo "$key: $dq_leftwidth%<br>\n";
	    }
	    echo "<font size=\"-2\"><br></font>\n";

        }
    }

    if ( $dq_show_details_link == 1 ) {

        echo '<a href="../plugins/disk_quota/disk_quota.php" target="right">' .
             $dq_details . '</a>';
        echo '</p>';

    }
}

?>
