<?php

function squirrelmail_plugin_init_disk_quota() {
  global $squirrelmail_plugin_hooks;
  $squirrelmail_plugin_hooks['left_main_after']['disk_quota'] = 'disk_quota_graph_and_link';
  $squirrelmail_plugin_hooks['optpage_register_block']['disk_quota'] = 'disk_quota_plugin_optpage_register_block';
}

define('SM_PATH', '../');

function disk_quota_graph_and_link() {

  include_once(SM_PATH . 'plugins/disk_quota/options.php');
  include_once(SM_PATH . 'functions/i18n.php');
  bindtextdomain('disk_quota', SM_PATH . 'plugins/disk_quota/locale');
  textdomain('disk_quota');

  global $username;
  $dq_nolimit = _("No_quota_limit");
  $dq_your_disk_usage = _("Your_Disk_Usage");
  $dq_details = _("Details");

  textdomain('squirrelmail');

  if ( $dq_check_quota_on_remote == 0 ) {

    include_once ("../plugins/disk_quota/left_quota.php");

  }
  elseif ( $dq_check_quota_on_remote == 1 ) {

    include_once ("$dq_imap_server/left_quota_sv.php?username=$username&dq_quota_binary=$dq_quota_binary&dq_strange_binary=$dq_strange_binary&dq_show_filesystem_left=$dq_show_filesystem_left&dq_show_verbose=$dq_show_verbose&dq_show_details_link=$dq_show_details_link&dq_your_disk_usage=$dq_your_disk_usage&dq_details=$dq_details");

  }
}

function disk_quota_plugin_optpage_register_block() {

  global $optpage_blocks;

  include_once(SM_PATH . 'functions/i18n.php');
  bindtextdomain('disk_quota', SM_PATH . 'plugins/disk_quota/locale');
  textdomain('disk_quota');

  $optpage_blocks[] = array(
     'name' => _("Check Quota"),
     'url'  => '../plugins/disk_quota/disk_quota.php',
     'desc' => _("Connects to the Server and checks your diskquota usage."),
     'js'   => false
     );

  textdomain('squirrelmail');
}

 function human_readable( $number, $base=1024,
   $suffixes=array( " B", " KB", " MB", " GB", " TB", " PB", " EB" )
 )
 {
   $usesuf = 0;
   $n = (float) $number; //Appears to be necessary to avoid rounding
   while( $n >= $base ) {
     $n /= (float) $base;
     $usesuf++;
  }
   $places = 2 - floor( log10( $n ) );
   $places = max( $places, 0 );
   $retval = number_format( $n, $places, ".", "" ) . $suffixes[$usesuf];
   return $retval;
 }


?>
