<?php
/*

 I wrote this script to allow those of us with GD to create
a better looking bar graph for disk quotas. 

*/
require_once('options.php');

$width  = $_GET['left']-25;
$usage  = $_GET['usage'];
$quota  = $_GET['threshold'];
$zero   = $_GET['zero'];

header ("Content-type: image/png");
    
$im = @imagecreate ($width, 15)
  or die ("Cannot Initialize new GD image stream!");

$white = imagecolorallocate ($im, 255, 255, 255);
$green = imagecolorallocate ($im, 0, 128, 0);
$yellow = imagecolorallocate ($im, 255, 255, 0);
$red = imagecolorallocate ($im, 255, 0, 0);
$blue = imagecolorallocate ($im, 0, 0, 255);
$text_color = $blue;

if( isset($zero) ) {
    $fill_width = $width/2;
    imagefilledrectangle ($im, 1,1,1,13,$white);
    imagestring ($im, 2, $fill_width, 1,  "0%", $blue);
    imagepng ($im);
}

else {

    $percent = ($usage/$quota);
    $eval = round($percent*100, 1);

    switch(TRUE) {

        case ( $eval <= $dq_warn) :
	    $fill_width = round($width*$percent);
            $text_pos = ($width-$fill_width)/2.8+$fill_width;
	    $fill_color = $green;
	    break;

        case ( ($eval > $dq_warn) && ($eval < $dq_alarm) ) :
	    $fill_width = round($width*$percent);
	    $fill_color = $yellow;
	    $text_pos = ($fill_width*.50);
	    break;

	case ( $eval >= 100 ) :
	    $eval = 100;
	    $fill_width = $width-2;
	    $text_pos = ($fill_width*.45);
	    break;

        default:
	        $fill_width = round($width*$percent);
	        $text_pos = ($fill_width*.50);
	    $fill_color = $red;
	    break;
    } //end switch

    imagefilledrectangle ($im, 1,1,$fill_width,13,$fill_color);
    imagestring ($im, 2, $text_pos, 1,  "$eval%", $text_color);
    imagepng ($im);
}
?>

