<?php

	/*
	*  Disk Quota Usage
	*  By Claudio Panichi <claudio.panichi@roma2.infn.it>
	*  Version 1.1
	*/

$table_border_size="\"4\"";             // table border size in pixel!


chdir ("..");

if (!isset($strings_php))
    include_once ("../functions/strings.php");

if (!isset($config_php))
    include_once ("../config/config.php");

if (!isset($page_header))
    include_once ("../functions/page_header.php");

if (!isset($imap_php))
    include_once ("../functions/imap.php");

include_once ("../src/load_prefs.php");

displayPageHeader($color, "None");



/* 	Try to find where is the quota binary.
*	Command "whereis -b quota" looks for the quota BINARY only
*	and the output is like the following:
*		quota: /usr/bin/quota	if quota-binary is present
*		quota:			if quota-binary is NOT present
*	so we'll see how many fields contain the string from "whereis"...
*/

// User can define the full path to quota binary here, if he doesn't like "whereis"
// modify and uncomment the following line in that case!
// $quota_binary="/usr/bin/wwwquota";	/* see INSTALL for details... */

if(!isset($quota_binary))
	{
	exec("whereis -b quota", $whereis, $whereis_return_code);
	$fields=split( "[[:blank:]]+", trim($whereis[0]) );
	$fields_number=count($fields);

	if ($fields_number === 1)
		{
		echo "<br>Quota-binary is not present on your system";
		echo "<br>or it is NOT in the whereis's path...";
		exit ;
		}
	if ($fields_number > 2 )
		{
		echo "<br> Kind of mismatch. Too many quota.binaries found!";
		exit ;
		}

	$quota_binary=$fields[1];
	}

/*
*       Some explanation before we procede!
*       The tipical output from quota command is like that:
*
*	Disk quotas for user claudio (uid 501):
*	     Filesystem  blocks   quota   limit   grace   files   quota   limit   grace
*	       /dev/md0    8940       0       0             854       0       0
*	       /dev/hda2      0       0       0               0       0       0
*	       /dev/md1 2504904 3000000 3500000           10125       0       0
*
*       It means that the first two lines must be skipped, and
*       that's why $i in the for-cicle will start from 2 and not
*       from 0 (we'll skip line 0 and line 1)
*/

exec("$quota_binary -v $username", $quota_data, $return_code);

if ($return_code === 0)
	{
	echo "<center>";
	echo "<br>";
	echo "<p>";
	echo "<I><B><FONT SIZE=5 COLOR=$color[8]>This is your disk-quota usage!</FONT></B></I><p>";
	echo "<table border=$table_border_size>";
	echo "<tr>";
	echo "  <td align=\"center\" BGCOLOR=$color[3]><B>Filesystem</B></td>";
	echo "  <td align=\"center\" BGCOLOR=$color[3]><B>Blocks</B></td>";
	echo "  <td align=\"center\" BGCOLOR=$color[3]><B>Quota</B></td>";
	echo "  <td align=\"center\" BGCOLOR=$color[3]><B>Limit</B></td>";
	echo "  <td align=\"center\" BGCOLOR=$color[3]><B>Status</B></td>";
	echo "</tr>";


	for ($i=2 ; $i<sizeof($quota_data) ; $i++)
        	{
	        echo "<tr>";
	        $splitted=split( "[[:blank:]]+", trim($quota_data[$i]) );
	        /*
	        * Choose the fields we want to display now!
	        * We will ignore any info about inode and grace-time
	        * So let's consider just the first 4 fields.
	        * See that index in next for-cicle will range from 0 to 3 then!
	        */
	        for ($j=0 ; $j<4 ; $j++ )
        	        {
                	echo "<td align=\"center\" BGCOLOR=$color[5]>$splitted[$j]</td>";
			}
			if( strpos($splitted[1], "*") == false )
				{
				echo "<td align=\"center\" BGCOLOR=$color[5]>OK!</td>";
				}
			else if( !(strpos($splitted[1], "*") == false) )
				{
				echo "<td align=\"center\" BGCOLOR=$color[2]><B>EXCEEDED!</B></td>";
				}
        	echo "</tr>";
	        }

	echo "</table>";

	echo "<center>";
	echo "<br>";
	echo "<p>";
	echo "<I><B><FONT SIZE=5 COLOR=$color[8]>Ok, but what does it mean?!</FONT></B></I><p>";
	
	echo "<table border=$table_border_size";
	echo "<tr>";
	echo "  <td align=\"center\" BGCOLOR=$color[3]><B>Filesystem</B></td>";
	echo "	<td align=\"center\" BGCOLOR=$color[5]>This is the physical place where your data are stored</td>";
	echo "</tr>";
	echo "<tr>";
	echo "  <td align=\"center\" BGCOLOR=$color[3]><B>Blocks</B></td>";
	echo "	<td align=\"center\" BGCOLOR=$color[5]>This is your actual amount of data on the physical device</td>";
	echo "</tr>";
	echo "<tr>";
	echo "  <td align=\"center\" BGCOLOR=$color[3]><B>Quota</B></td>";
	echo "	<td align=\"center\" BGCOLOR=$color[5]>This is the amount of disk-space that you can use</td>";
	echo "</tr>";
	echo "<tr>";
	echo "  <td align=\"center\" BGCOLOR=$color[3]><B>Limit</B></td>";
	echo "	<td align=\"center\" BGCOLOR=$color[5]>This is the absolute disk-space you cannot exceed</td>";
	echo "</tr>";
	echo "<tr>";
	echo "  <td align=\"center\" BGCOLOR=$color[3]><B>Status</B></td>";
	echo "	<td align=\"center\" BGCOLOR=$color[5]>This is your situation with the law! =:-)</td>";
	echo "</tr>";
	echo "</table>";

	echo "<br><br>";
	echo "<table border=$table_border_size>";
	echo "<tr>";
	echo "<td align=\"center\" BGCOLOR=$color[3]><B>What's the difference between Quota and Limit?</B></td>";
	echo "</tr>";
	echo "<tr>";
	echo "<td align=\"center\" BGCOLOR=$color[5]>";
	echo "Well, you have a limited amount of disk-space available for your data and if you. ";
	echo "You have two kind of limit. Between the first one (called Quota) and the second one ";
	echo "(called Limit) the system will still let you work for some more time ";
	echo "(the so colled Grace-time) but if you exceed \"Limit\", the system will ";
	echo "prevent you from creating new files! Please notice that once your Grace-time ";
	echo "is expired, you won't be able do anything than delete files!</td>";
	echo "</tr>";
	echo "<tr>";
	echo "<td align=\"center\" BGCOLOR=$color[3]><B>I see an \"EXCEEDED\" in the status-field. What's that?</B></td>";
	echo "</tr>";
	echo "<tr>";
	echo "<td align=\"center\" BGCOLOR=$color[5]>";
	echo "It's not fine!!! It means that you will not be able to work anymore on the system ";
	echo "if you immediately do not trash & purge some of your data! Please consider the ";
	echo "possibility of moving some data on your local computer rather than leave it all ";
	echo "on the server!</td>";
	echo "</tr>";
	echo "</table>";
	echo "</center>";
	}

else if ($return_code != 0)
	{
	echo "<br><br>Sorry. There's a problem with disk_quota plugin on this system.";
	echo "<br>Notify the System Administrator about the issue!";
	exit;
	}
?>

