<?php

/**
  * SquirrelMail Debugger
  * Copyright (C) 2004-2005 Paul Lesneiwski <pdontthink@angrynerds.com>
  * This program is licensed under BSD (because some portions of 
  * the source are already licensed under BSD; typical SquirrelMail 
  * license is GPL). See COPYING for details
  *
  */


global $sm_debugger_fatal, $show_debug_menu_link;


//---------------------------------------------------------
// CONFIGURATION
//


// show menu link to popup with SESSION, POST and GET
// information?
//
$show_debug_menu_link = TRUE;


// show error reports for PHP notices/warnings/errors?
//
$show_reports = TRUE;


// which kind of output do we want?
//
$fancy = FALSE;
//$fancy = TRUE;


// stop after error occurs?
//
$sm_debugger_fatal = TRUE;
//$sm_debugger_fatal = FALSE;


//
// END CONFIGURATION
//---------------------------------------------------------


/** @ignore */
if (!defined('SM_PATH'))
   define('SM_PATH', '../');



if ($show_reports)
{

   ini_set('display_errors', 'On');
   ini_set('error_reporting', E_ALL);
   //error_reporting(E_ALL);



   if ($fancy)
   {
      include_once(SM_PATH . 'plugins/debugger/Handler.php');
//      $__ErrorHandler = new ErrorHandler;
//      set_error_handler(array(&$__ErrorHandler, 'raiseError'));
      $oldErrorHandler = set_error_handler('fancyErrorHandler');
   
   }
   else
   {
      include_once(SM_PATH . 'plugins/debugger/simple_handler.php');
      $oldErrorHandler = set_error_handler('simpleErrorHandler');
   }

}


/**
  * Register this plugin with SquirrelMail
  *
  */
function squirrelmail_plugin_init_debugger()
{

   global $squirrelmail_plugin_hooks, $show_debug_menu_link;

   if ($show_debug_menu_link)
      $squirrelmail_plugin_hooks['menuline']['debugger'] = 'debug_menu_link';

// maybe some day this plugin will have some user-configurable options...
// then again, why would it?
//
//   $squirrelmail_plugin_hooks['optpage_loadhook_display']['debugger']
//      = 'preview_pane_show_options';

}



/**
  * Returns version info about this plugin
  *
  */
function debugger_version()
{

   return '1.2-1.4';

}



/**
  * Inserts link to debugger popup window in main menu bar
  *
  */
function debug_menu_link()
{

   include_once(SM_PATH . 'plugins/debugger/functions.php');
   debug_menu_link_do();

}



/**
  * Show user configurable options display prefs page
  *
  */
function debugger_show_options()
{

  include_once(SM_PATH . 'plugins/debugger/functions.php');
  debugger_show_options_do();

}



?>
