<?php

   // include compatibility plugin
   //
   if (defined('SM_PATH'))
      include_once(SM_PATH . 'plugins/compatibility/functions.php');
   else if (file_exists('../plugins/compatibility/functions.php'))
      include_once('../plugins/compatibility/functions.php');
   else if (file_exists('./plugins/compatibility/functions.php'))
      include_once('./plugins/compatibility/functions.php');



// This is the text that appears on the option page
//
function custom_from_options_display_do() 
{

   global $username, $data_dir, $restrict_access_to_users_file;


   if (compatibility_check_sm_version(1, 3))
      include_once (SM_PATH . 'plugins/custom_from/config/config.php');
   else
      include_once ('../plugins/custom_from/config/config.php');


   if (!empty($restrict_access_to_users_file) 
      && file_exists($restrict_access_to_users_file))
   {
      if (!findUser($username, $restrict_access_to_users_file))
         return;
   }


   $use_custom_from = getPref($data_dir, $username, 'use_custom_from', '0');


   echo "<tr><td align=right valign=top><br>\n".
      _("Use Custom From When Composing Messages:") . "</td>\n".
      "<td><br><input type='radio' value='1' name='use_custom_from' ";
   if ($use_custom_from == '1') echo "CHECKED";
   echo ">&nbsp;" . _("Yes") . "\n".
      "&nbsp;&nbsp;&nbsp;&nbsp;<input type='radio' value='0' name='use_custom_from' ";
   if ($use_custom_from == '0') echo "CHECKED";
   echo ">&nbsp;" . _("No") . "\n".
      "</td></tr>\n";


}



// Here we save the user's custom from preferences
//
function custom_from_options_save_do() 
{

   global $data_dir, $username, $use_custom_from;

   compatibility_sqextractGlobalVar('use_custom_from');

   setPref($data_dir, $username, 'use_custom_from', $use_custom_from);

}



// look up user in users data file
//
function findUser($user, $restrict_access_to_users_file)
{


   // override per-user settings
   //
   if (!empty($restrict_access_to_users_file) && !empty($user)) {


      // find user
      //
      if ($USERS = @fopen ($restrict_access_to_users_file, "r"))
      {

         while (!feof($USERS))
         {
 
            $line = fgets($USERS, 4096);
            $line = trim($line);
 
 
            // skip blank lines and comment lines
            //
            if (strpos($line, '#') === 0 || strlen($line) < 3)
               continue;
 
 
            // stop when we have the right username (case insensitive)
            //
            if (preg_match('/^' . str_replace(array('?', '*'), array('\w{1}', '.*?'),
                           strtoupper($line)) . '$/', strtoupper($user)))
               return TRUE;
 
         }
 
         fclose($USERS);

      }

   }

   return FALSE;

}


?>
