<?php
/**
 * setup.php -- Custom charset plugin initiation script
 *
 * Copyright (c) 2005 Tomas Kuliavas <tokul@users.sourceforge.net>
 * This file is part of SquirrelMail Custom Charset plugin.
 *
 * Custom Charset plugin is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Custom Charset plugin is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Custom Charset plugin; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * @copyright (c) 2005 Tomas Kuliavas <tokul@users.sourceforge.net>
 * @version $Id: setup.php,v 1.5 2005/05/18 11:41:59 tokul Exp $
 * @package sm-plugins
 * @subpackage custom_charset
 */

/**
 * make sure SM_PATH is defined
 * @ignore
 */
if (!defined('SM_PATH'))  {
    define('SM_PATH','../../');
}

/**
 * init function
 */
function squirrelmail_plugin_init_custom_charset() {
    global $squirrelmail_plugin_hooks;

    $squirrelmail_plugin_hooks['loading_prefs']['custom_charset'] = 'custom_charset_prefs';
    $squirrelmail_plugin_hooks['optpage_loadhook_display']['custom_charset'] = 'custom_charset_optblock';
}

/**
 * loads plugin preferences
 */
function custom_charset_prefs() {
    include_once(SM_PATH . 'plugins/custom_charset/functions.php');
    custom_charset_prefs_function();
}

/**
 * adds custom_charset options to display option block
 */
function custom_charset_optblock() {
    include_once(SM_PATH . 'plugins/custom_charset/functions.php');
    custom_charset_optblock_function();
}

/**
 * shows plugin's version
 * @return string
 */
function custom_charset_version() {
    return '1.1';
}
?>