<?php
/**
 * Functions used by Custom Charset plugin
 *
 * Copyright (c) 2005 Tomas Kuliavas <tokul@users.sourceforge.net>
 * This file is part of SquirrelMail Custom Charset plugin.
 *
 * Custom Charset plugin is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Custom Charset plugin is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Custom Charset plugin; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * @copyright (c) 2005 Tomas Kuliavas <tokul@users.sourceforge.net>
 * @version $Id: functions.php,v 1.4 2005/05/18 11:41:59 tokul Exp $
 * @package sm-plugins
 * @subpackage custom_charset
 */

/**
 * make sure SM_PATH is defined
 * @ignore
 */
if (!defined('SM_PATH'))  {
    define('SM_PATH','../../');
}

/**
 * load squirrelmail functions 
 * (gettext support, getpref() and check_sm_version()) 
 */
include_once(SM_PATH . 'include/validate.php');

// Plugin defaults
/**
 * Space separated list of charsets.
 * if is set to 'auto', loads all charsets available in squirrelmail $languages
 * @global string $custom_charset_list 
 */
global $custom_charset_list;
$custom_charset_list='auto';

// load config
if (file_exists(SM_PATH . 'config/custom_charset_config.php')) {
    include_once(SM_PATH . 'config/custom_charset_config.php');
} elseif (file_exists(SM_PATH . 'plugins/custom_charset/config.php')) {
    include_once(SM_PATH . 'plugins/custom_charset/config.php');
}

/**
 * Adds custom charset to squirrelmail languages array and creates automatic
 * list of custom charsets.
 * (internal function)
 */
function custom_charset_prefs_function() {
    // get needed globals
    global $username, $data_dir, $languages, $default_charset, $custom_charset_list;

    if (preg_match("/auto/i",$custom_charset_list)) {
        // create charset from $languages
        $custom_charsets=array();
        foreach ($languages as $lang_key) {
            if (isset($lang_key['CHARSET']) && ! in_array($lang_key['CHARSET'],$custom_charsets))
                $custom_charsets[].=$lang_key['CHARSET'];
        }
        $custom_charset_list=implode(' ',$custom_charsets);
    }

    // globalize $custom_charset
    global $custom_charset;
    // get custom_charset prefs
    $custom_charset=getPref($username,$data_dir,'custom_charset',$default_charset);

    /**
     * I think, squirrelmail language is not setup yet.
     * I can't translate this string. Maybe ALTNAME can be configurable by admin.
     */
    $languages['custom']['NAME']='English (custom charset)';
    $languages['custom']['CHARSET']=$custom_charset;
    $languages['custom']['LOCALE']='en_US.' . $custom_charset;
}

/**
 * Adds custom charset options to display preferences.
 * (internal function)
 */
function custom_charset_optblock_function() {
    global $optpage_data, $custom_charset, $custom_charset_list;

    // check $custom_charset_list. It must contain at least one space
    if (trim($custom_charset_list)!='' && preg_match("/ /",$custom_charset_list)) {
        bindtextdomain('custom_charset',SM_PATH . 'locale');
        textdomain('custom_charset');

        foreach (explode(' ',$custom_charset_list) as $charset) {
            $custom_charset_array[$charset]=$charset;
        }
        // sort array
        ksort($custom_charset_array);

        $optpage_data['vals'][SMOPT_GRP_GENERAL][] = array(
            'name'    => 'custom_charset',
            'caption' => _("Custom Charset"),
            'type'    => SMOPT_TYPE_STRLIST,
            'refresh' => SMOPT_REFRESH_ALL,
            'posvals' => $custom_charset_array,
            'initial_value' => $custom_charset,
            'trailing_text' => '<small>'._("only for English (custom charset)") . '</small>');

        if (! check_sm_version(1,5,0)) {
            $optpage_data['vals'][SMOPT_GRP_GENERAL][] = array(
                'name'    => 'custom_charset_comment',
                'type'    => SMOPT_TYPE_COMMENT,
                'caption' => '<small>'._("Warning").'</small>',
                'comment' => '<small>'
                             ._("Custom charset is used only with 'English (custom charset)' language") 
                             .'</small>');
        }
        bindtextdomain('squirrelmail',SM_PATH . 'locale');
        textdomain('squirrelmail');
    }
}
?>