<?php
/*******************************************************************************

    Author ......... Jimmy Conner
    Contact ........ jimmy@sqmail.org
    Home Site ...... http://www.sqmail.org/
    Program ........ Cpanel Vacation
    Version ........ 0.2
    Purpose ........ Allows your users to set a Vacation Auto-Response when
                     using a host with CPanel

*******************************************************************************/


if (!defined('SM_PATH'))
    define('SM_PATH','../../');

include_once (SM_PATH . 'include/validate.php');
include_once (SM_PATH . 'plugins/cpanel_vacation/config.php');
include_once (SM_PATH . 'plugins/cpanel_vacation/charsets.php');

bindtextdomain('cpanel_vacation', SM_PATH . 'plugins/cpanel_vacation/locale');
textdomain('cpanel_vacation');

global $submit, $subject, $body, $charset;
global $username, $color, $plugins;
global $squirrelmail_language, $languages, $squirrelmail_default_language;

if (!in_array('cpanel_vacation',$plugins) || $cpanel_vac_un == '' || $cpanel_vac_pw == '') {
    header("Location:../../index.php");
    exit;
}

sqgetGlobalVar('status', $status, SQ_FORM);
sqgetGlobalVar('subject', $subject, SQ_FORM);
sqgetGlobalVar('body', $body, SQ_FORM);
sqgetGlobalVar('submit', $submit, SQ_FORM);
sqgetGlobalVar('charset', $charset, SQ_FORM);

$filename = getHashedFile($username, $data_dir, '');
$fullname = getPref($filename, $username, 'full_name');

$submit = trim($submit);
$body = trim($body);
$subject = trim($subject);
$charset = trim($charset);

$errors = false;

if ($status != 0 && $status != 1) {
    $status = getPref($filename, $username, 'cpanel_vacation_status');
    if ($status != 0 && $status != 1)
        $status = 0;
}

if (isset($submit) && $submit == _("Save")) {
    // check for errors!
    //
    setPref($data_dir, $username, 'cpanel_vacation_status', $status);
    if ($subject == '')
        $subject = _("Re:") . ' %subject%';
    setPref($data_dir, $username, 'cpanel_vacation_subject', urlencode($subject));
    if ($body == '')
        $body = _("Hello.  I am currently away from my mailbox right now, but I will read your message when I return.") . "\n\n" . _("Thank you for your patience") . ",\n" . $fullname;
    setPref($data_dir, $username, 'cpanel_vacation_body', urlencode($body));

    if ($charset == '')
        $charset = $squirrelmail_default_language;
    setPref($data_dir, $username, 'cpanel_vacation_charset', urlencode($charset));
}

if (isset($submit) && $submit == _("Save") && ($errors == false) && $status == 1) {

    $cpanel_domain = $_SERVER["SERVER_ADDR"];
    $cpanel_port = 2082;		// Your CPanel port. (https not supported unless CURL is installed.)

    $un_parts = explode("@", $username);	// Split the un into parts.  (username/domain name)
    $request = "email=".$un_parts[0]."&domain=".$un_parts[1]."&subject=".urlencode($subject) . "&body=".urlencode($body)."&from=".urlencode($fullname) ."&charset=us-ascii&html=0";

    // Form the header of the HTTP request, with username and password.
    $header = "POST " . $cpanel_file_location . " HTTP/1.0\r\nAuthorization: Basic ";
    $header .= base64_encode($cpanel_vac_un . ":" . $cpanel_vac_pw) .  "\r\n";
    $header .= "Content-type: application/x-www-form-urlencoded\r\n";
    $header .= "Content-length: " . strlen($request) . "\r\n";
    $header .= "Connection: close\r\n\r\n";

    $cpanel_response = '';
    // Connect to the server
    $fp = fsockopen($cpanel_domain, $cpanel_port, $errno, $errstr);
    if ($fp) {
        // Send the request
        fputs($fp, $header . $request);
        // Get the result
        while (!feof($fp)) { $cpanel_response .= fgets($fp, 128); }
    }

    // Close the connection
    $fp = fclose($fp);

    // Get rid of the HTTP result headers - they aren't needed.
    $nnpos = strpos($cpanel_response, "\n\n");
    $cpanel_response = substr($cpanel_response, $nnpos + 1);

    // Determine if the Cpanel request was successful or not by finding the
    // "success" text string specified in the config file.
    //$cpanel_response_temp = implode('',$cpanel_response);
    $cpanel_response_temp = strip_tags($cpanel_response); // remove all the HTML tags from the output
    $array_temp = array("\n", "\r" );
    $cpanel_response_temp = str_replace($array_temp, "", $cpanel_response_temp); // remove the line breaks
    $find_string = strpos($cpanel_response_temp, $cpanel_success_string);

    if ($find_string == true) {
        $msg = _("Your settings were saved successfully.");
    } else {
        $msg = _("A problem occurred and your vacation message has not been set.");
        setPref($data_dir, $username, 'cpanel_vacation_status', 0);
    }
}


if (isset($submit) && $submit == _("Save") && ($errors == false) && $status == 0) {

    // Delete the Vacation Response Message

    $cpanel_domain = $_SERVER["SERVER_ADDR"];
    $cpanel_port = 2082;		// Your CPanel port. (https not supported unless CURL is installed.)

    $request = "email=".$username;

    // Form the header of the HTTP request, with username and password.
    $header = "POST " . $cpanel_file_location_delete . " HTTP/1.0\r\nAuthorization: Basic ";
    $header .= base64_encode($cpanel_vac_un . ":" . $cpanel_vac_pw) .  "\r\n";
    $header .= "Content-type: application/x-www-form-urlencoded\r\n";
    $header .= "Content-length: " . strlen($request) . "\r\n";
    $header .= "Connection: close\r\n\r\n";

    $cpanel_response = '';
    // Connect to the server
    $fp = fsockopen($cpanel_domain, $cpanel_port, $errno, $errstr);
    if ($fp) {
        // Send the request
        fputs($fp, $header . $request);
        // Get the result
        while (!feof($fp)) { $cpanel_response .= fgets($fp, 128); }
    }

    // Close the connection
    $fp = fclose($fp);

    // Get rid of the HTTP result headers - they aren't needed.
    $nnpos = strpos($cpanel_response, "\n\n");
    $cpanel_response = substr($cpanel_response, $nnpos + 1);

    // Determine if the Cpanel request was successful or not by finding the
    // "success" text string specified in the config file.
    //$cpanel_response_temp = implode('',$cpanel_response);
    $cpanel_response_temp = strip_tags($cpanel_response); // remove all the HTML tags from the output
    $array_temp = array("\n", "\r" );
    $cpanel_response_temp = str_replace($array_temp, "", $cpanel_response_temp); // remove the line breaks
    $find_string = strpos($cpanel_response_temp, $cpanel_success_string_delete);

    if ($find_string == true) {
        $msg = _("Your settings were saved successfully.");
    } else {
        $msg = _("A problem occurred and your vacation message has not been removed.");
        setPref($data_dir, $username, 'cpanel_vacation_status', 0);
    }
}


include_once (SM_PATH . 'include/validate.php');
include_once (SM_PATH . 'functions/page_header.php');
include_once (SM_PATH . 'include/load_prefs.php');

displayPageHeader($color, 'None');

$status = getPref($filename, $username, 'cpanel_vacation_status');
if ($status != 0 && $status != 1) {
    $status = 0;
    setPref($data_dir, $username, 'cpanel_vacation_status', $status);
}
$subject = urldecode(getPref($filename, $username, 'cpanel_vacation_subject'));
if ($subject == '') {
    $subject = 'Re: %subject%';
    setPref($data_dir, $username, 'cpanel_vacation_subject', urlencode($subject));
}
$body = urldecode(getPref($filename, $username, 'cpanel_vacation_body'));
if ($body == '') {
        $body = _("Hello.  I am currently away from my mailbox right now, but I will read your message when I return.") . "\n\n" . _("Thank you for your patience") . ",\n" . $fullname;
    setPref($data_dir, $username, 'cpanel_vacation_body', urlencode($body));
}

$charset = getPref($filename, $username, 'cpanel_vacation_charset');
if ($charset == '') {
    $charset = '';

    foreach($languages as $t=>$l) {
        if ($t == $squirrelmail_language && isset($l['CHARSET']))
            $charset = $l['CHARSET'];
    }
    if ($charset == '') {
        foreach($languages as $t=>$l) {
            if ($t == $squirrelmail_default_language && isset($l['CHARSET']))
                $charset = $l['CHARSET'];
        }
    }
    if ($charset != '')
        setPref($data_dir, $username, 'cpanel_vacation_charset', $charset);
}
?>

<table width="95%" align=center border=0 cellpadding=2 cellspacing=2>
   <tr>
	  <td align="center" bgcolor="<?php echo $color[0] ?>"><b><?php echo _("Change your Vacation Auto Response"); ?></b>
	     <table cellspacing="0" cellpadding="5" border="0" width="100%">
		    <tr>
		       <td bgcolor="<?php echo $color[4] ?>">
					<?php 
					if (isset($msg))
					{ echo "<br /><center><b><font color=\"red\">$msg</font></b></center>"; }

					?>
			   <form method=post><center><br><table><tr><td>
			   <?php echo _("Your Vacation Auto Response is currently"); ?>:</td><td>
                           <input type=radio name=status value=1<?php if ($status == 1) echo ' checked'; echo '> ' . _("Enabled"); ?></td></tr><tr><td>&nbsp;</td><td><input type=radio name=status value=0<?php if ($status == 0) echo ' checked'; echo '> ' . _("Disabled"); ?></td></tr></table><br>
			   <hr width="80%" size="1" noshade><br>
			   <table>
				  <tr>
					 <td align=right valign=top><?php echo _("Subject:"); ?></td>
					 <td valign=top><input name=subject size=63 type=text maxlength="255" value="<?php echo $subject; ?>"></td></tr>
				  <tr>
					 <td align=right valign=top><?php echo _("Charset:"); ?></td>
					 <td valign=top><select name=charset>
<?php
    global $vac_charsets;
    foreach($vac_charsets as $t) {
        print '<option value=' . $t;
        if (trim(strtolower($charset)) == trim(strtolower($t))) print ' SELECTED';
        print '>' . $t . "</option>\n";
    }
?>
                                         </select>
                                         </td></tr>
				  </tr>
				  <tr>
					 <td align=right valign=top><?php echo _("Message:"); ?></td>
					 <td valign=top><textarea name="body" cols=60 rows=10><?php echo $body; ?></textarea></td>
				  </tr>
				</table><br>
				<hr width="80%" size="1" noShade>
				<input name=submit type=submit value="<?php echo _("Save"); ?>"></form> 
			  </td>
		   </tr>
	    </table>
	 </td>
  </tr>
</table>

<?php

if ((!empty($cpanel_response)) && ($show_cpanel_output == true)) {
    // Display the output from Cpanel here.
    echo '<hr><b><h2>' . _("CPanel Output - Change Auto Response") . '</h2></b>';
    echo $cpanel_response;
}
bindtextdomain('squirrelmail', SM_PATH . 'locale');
textdomain('squirrelmail');
?>

</body>
</html>