<?php


   chdir('..');
   define('SM_PATH','../');



   // include compatibility plugin
   //
   if (defined('SM_PATH'))
      include_once(SM_PATH . 'plugins/compatibility/functions.php');
   else if (file_exists('../plugins/compatibility/functions.php'))
      include_once('../plugins/compatibility/functions.php');
   else if (file_exists('./plugins/compatibility/functions.php'))
      include_once('./plugins/compatibility/functions.php');



   if (compatibility_check_sm_version(1, 3))
   {
      include_once (SM_PATH . 'include/validate.php');
      include_once (SM_PATH . 'functions/page_header.php');
      include_once (SM_PATH . 'include/load_prefs.php');
      include_once (SM_PATH . 'plugins/courier_vacation/config.php');
   }
   else
   {
      include_once ('../src/validate.php');
      include_once ('../functions/page_header.php');
      include_once ('../src/load_prefs.php');
      include_once ('../plugins/courier_vacation/config.php');
   }
   
   
   
   global $messageFileName, $subjectFileName, $ccAddressesFileName, 
          $keepMessagesFileName, $vacationMessageSubmit, $messageText, 
          $vacationStatus, $messageSubject, $ccAddresses, $keepMessages,
          $username, $data_dir, $color;



   // get flag that tells us if this is a vacation
   // message submission
   //
   compatibility_sqextractGlobalVar('vacationMessageSubmit');



   // get the user's home directory
   //
   $homeDir = getHomeDirectory($username);



   // if a message and other info was submitted, process it here
   //
   if (isset($vacationMessageSubmit) && $vacationMessageSubmit == 1)
   {

      compatibility_sqextractGlobalVar('messageText');
      compatibility_sqextractGlobalVar('vacationStatus');
      compatibility_sqextractGlobalVar('messageSubject');
      compatibility_sqextractGlobalVar('ccAddresses');
      compatibility_sqextractGlobalVar('keepMessages');

      // collapse message text into one line
      //
      $messageText = nl2br(htmlentities($messageText));
      $messageText = ereg_replace ("\n", "", $messageText);
      $messageText = ereg_replace ("\r", "", $messageText);
      
      setPref($data_dir, $username, 'messageText', $messageText);
      setPref($data_dir, $username, 'messageSubject', $messageSubject);
      setPref($data_dir, $username, 'ccAddresses', $ccAddresses);

      if (isset($keepMessages) && $keepMessages == "on")

         setPref($data_dir, $username, 'keepMessages', $keepMessages);

      else
      {

         setPref($data_dir, $username, 'keepMessages', '');
         $keepMessages = '';

      }


      // turn on vacation messaging
      //
      if (isset($vacationStatus) && $vacationStatus == "on")
      {

         setPref($data_dir, $username, 'vacationStatus', $vacationStatus);
         writeVacationFiles($homeDir, $messageText, $messageSubject, $ccAddresses, $keepMessages);

      }

      // turn off vacation messaging
      //
      else
      {

         setPref($data_dir, $username, 'vacationStatus', '');
         $vacationStatus = '';
         removeVacationFiles($homeDir);

      }


      $location = '../../src/options.php';
      header('Location: ' . $location);
      exit(0);

   }

        
   // pull previous settings from user prefs
   //
   $messageText = getPref($data_dir, $username, 'messageText', '');
   $messageSubject = getPref($data_dir, $username, 'messageSubject', '');
   $ccAddresses = getPref($data_dir, $username, 'ccAddresses', '');
   $keepMessages = getPref($data_dir, $username, 'keepMessages', '');
   $vacationStatus = getPref($data_dir, $username, 'vacationStatus', '');


   // resynch vacation files if they should exist but doesn't
   //
   if ($vacationStatus == 'on' && (
        !@file_exists($homeDir . '/' . $messageFileName)
     || (!@file_exists($homeDir . '/' . $subjectFileName) 
         && !empty($messageSubject))
     || (!@file_exists($homeDir . '/' . $ccAddressesFileName) 
         && !empty($ccAddresses))
     || (!@file_exists($homeDir . '/' . $keepMessagesFileName) 
         && !empty($keepMessages))))
   {

      writeVacationFiles($homeDir, $messageText, $messageSubject, $ccAddresses, $keepMessages);

   }


   displayPageHeader($color, 'None', 'document.forms[0].elements["messageText"].focus();');
   echo '<br>';


   echo '<form method="POST"><input type="hidden" name="vacationMessageSubmit" value="1">'
      . '<table width=95% align=center cellpadding=2 cellspacing=2 border=0>'
      . '<tr><td bgcolor="' . $color[0] . '">'
      . '<center><b>'
      . _("Vacation / Autoresponder");

   ?>

      </b></center>
      </td>
   </tr>
   <tr> 
      <td align="center">
         <table width="70%" cellspacing="2">
            <tr>
               <td valign="top">
                  <br>
                  <input type="checkbox" name="vacationStatus" value="on" <?php
                                                   if ($vacationStatus == 'on') echo ' CHECKED' ?>>
               </td>
               <td>
                  <br>
                  <b><?php echo _("Activate vacation autoresponder") ?></b>
               </td>
            </tr>
            <tr>
               <td colspan="2"> 
                  <br>
                  <b><?php echo _("Message text"); ?></b>:
                  <br>
                  <textarea name="messageText" rows="5" cols="50" wrap="off"><?php echo eregi_replace('<br[[:space:]]*/?[[:space:]]*>', "\n", $messageText); ?></textarea>
               </td>
            </tr>
            <tr>
               <td colspan="2">
                  <br>
                  <b><?php echo _("Message subject") . '</b> ' 
                        . _("(leave blank to use standard \"RE:\" syntax)"); ?>:
                  <br>
                  <input type="text" name="messageSubject" size="60" value="<?php echo $messageSubject; ?>">
               </td>
            </tr>
            <tr>
               <td colspan="2">
                  <br>
                  <b><?php echo _("Send copy of messages to") . '</b> ' 
                        . _("(separate email addresses with commas)"); ?>:
                  <br>
                  <input type="text" name="ccAddresses" size="60" value="<?php echo $ccAddresses; ?>">
               </td>
            </tr>
            <tr>
               <td valign="top">
                  <br>
                  <input type="checkbox" name="keepMessages" value="on" <?php 
                                                   if ($keepMessages == 'on') echo ' CHECKED' ?>>
               </td>
               <td>
                  <br>
                  <b><?php echo _("Keep copies of incoming messages in this account"); ?></b>
                  <br>(<?php echo _("not applicable when you have not specified any forwarding addresses above"); ?>)
               </td>
            </tr>
            <tr>
               <td align=right colspan="2">
                  <br>
                  <input type="submit" value="<?php echo _("Submit"); ?>">
               </td>
            </tr>
         </table>
      </td>
   </tr>
</table>
</form>
</body>
</html>

<?php

exit(0);



// ################################################################
//
// functions...
//


// deletes all vacation related files in user's home
// directory (all info is left in squirrelmail prefs,
// however)
//
function removeVacationFiles($homeDir)
{

   global $messageFileName, $subjectFileName, $ccAddressesFileName, $keepMessagesFileName;


   if (compatibility_check_sm_version(1, 3))
   {
      include_once (SM_PATH . 'plugins/courier_vacation/config.php');
   }
   else
   {
      include_once ('../plugins/courier_vacation/config.php');
   }


   // delete message text file
   //
   if (file_exists($homeDir . '/' . $messageFileName))
   {

      if (!@unlink($homeDir . '/' . $messageFileName))
      {
         showError('ERROR: Could not remove vacation text');
         exit(1);
      }

   }


   // delete message subject file
   //
   if (file_exists($homeDir . '/' . $subjectFileName))
   {

      if (!@unlink($homeDir . '/' . $subjectFileName))
      {
         showError('ERROR: Could not remove vacation message subject');
         exit(1);
      }

   }


   // delete cc addresses file
   //
   if (file_exists($homeDir . '/' . $ccAddressesFileName))
   {

      if (!@unlink($homeDir . '/' . $ccAddressesFileName))
      {
         showError('ERROR: Could not remove CC addresses');
         exit(1);
      }

   }


   // delete keep messagees file
   //
   if (file_exists($homeDir . '/' . $keepMessagesFileName))
   {

      if (!@unlink($homeDir . '/' . $keepMessagesFileName))
      {
         showError('ERROR: Could not remove keep messages info');
         exit(1);
      }

   }


}



// creates (or overwrites) vacation files as needed
// removes files that should not be present (for example,
// if there was a subject file previously, but this 
// time no subject is given, the subject file is removed)
//
function writeVacationFiles($homeDir, $messageText, 
                            $messageSubject, $ccAddresses, $keepMessages)
{

   global $messageFileName, $subjectFileName, 
          $ccAddressesFileName, $keepMessagesFileName;


   if (compatibility_check_sm_version(1, 3))
   {
      include_once (SM_PATH . 'plugins/courier_vacation/config.php');
   }
   else
   {
      include_once ('../plugins/courier_vacation/config.php');
   }


   // write message text
   //
   $FILE = @fopen($homeDir . '/' . $messageFileName, 'w');
   if (!$FILE)
   {
      showError('ERROR: Could not access vacation message');
      exit(1);
   }
   if (!@fwrite($FILE, $messageText))
   {
      fclose($FILE);
      showError('ERROR: Could not save vacation message');
      exit(1);
   }
   fclose($FILE);


   // write message subject (if needed)
   //
   if (!empty($messageSubject))
   {
      $FILE = @fopen($homeDir . '/' . $subjectFileName, 'w');
      if (!$FILE)
      {
         showError('ERROR: Could not access vacation message subject');
         exit(1);
      }
      if (!@fwrite($FILE, $messageSubject))
      {
         fclose($FILE);
         showError('ERROR: Could not save vacation message subject');
         exit(1);
      }
      fclose($FILE);
   }

   // if no message subject, clear out subject file
   //
   else if (file_exists($homeDir . '/' . $subjectFileName))
   {
      
      if (!@unlink($homeDir . '/' . $subjectFileName))
      {
         showError('ERROR: Could not remove vacation message subject');
         exit(1);
      }

   }


   // save cc addresses (if needed)
   //
   if (!empty($ccAddresses))
   {
      
      $FILE = @fopen($homeDir . '/' . $ccAddressesFileName, 'w');
      if (!$FILE)
      {
         showError('ERROR: Could not access cc addresses');
         exit(1);
      }


      // TODO: how can we make sure there are only email addresses here?  
      //       don't want to allow user to run arbitrary commands here
      //       for now, just restrict to alphanumerics characters plus @, _ and .
      //
      $ccAddrs = explode(',', $ccAddresses);
      $parsedCCAddrresses = '';
      foreach ($ccAddrs as $ccAddr)
      {

         $ccAddr = trim($ccAddr);

         if (preg_match('/[^A-Za-z0-9@\._]/', $ccAddr)) 
         {
            fclose($FILE);
            showError('ERROR: Illegal characters in CC address');
            exit(1);
         }
   
         $parsedCCAddrresses .= ' ' . $ccAddr;

      }

      if (!@fwrite($FILE, $parsedCCAddrresses . "\n"))
      {
         fclose($FILE);
         showError('ERROR: Could not save CC address');
         exit(1);
      }

      fclose($FILE);


      // write flag file indicating to keep messages in this account (if needed)
      //
      if (!empty($keepMessages))
      {
         $FILE = @fopen($homeDir . '/' . $keepMessagesFileName, 'w');
         if (!$FILE)
         {
            showError('ERROR: Could not access keep messages info');
            exit(1);
         }
         if (!@fwrite($FILE, $keepMessages))
         {
            fclose($FILE);
            showError('ERROR: Could not save keep messages info');
            exit(1);
         }
         fclose($FILE);
      }

      // or remove keep messages file if needed
      //
      else if (file_exists($homeDir . '/' . $keepMessagesFileName))
      {

         if (!@unlink($homeDir . '/' . $keepMessagesFileName))
         {
            showError('ERROR: Could not remove keep messages info');
            exit(1);
         }

      }

   }

   // if no CC addresses, clear out CC address file as 
   // well as keep messages flag file
   //
   else 
   {
      if (file_exists($homeDir . '/' . $ccAddressesFileName))
      {
      
         if (!@unlink($homeDir . '/' . $ccAddressesFileName))
         {
            showError('ERROR: Could not remove CC addresses');
            exit(1);
         }

      }
      if (file_exists($homeDir . '/' . $keepMessagesFileName))
      {
      
         if (!@unlink($homeDir . '/' . $keepMessagesFileName))
         {
            showError('ERROR: Could not remove keep messages info');
            exit(1);
         }

      }

   }

}



// displays simple error output page
//
function showError($message)
{

   global $color;
   displayPageHeader($color, 'None');
   echo '<br><br><center><font color="' . $color[2] . '"><b>'
      . $message
      . '</b></font></center></body></html>';

}



// gets user's home directory location from backend
//
function getHomeDirectory($user)
{

   global $backend;


   // build correct function name
   //
   $backendFunction = $backend . '_get_home_directory';


   return $backendFunction($user);

}



// get user's home directory from a MySQL backend
//
function mysql_get_home_directory($user)
{

   global $mysql_server, $mysql_user, $mysql_pwd, $mysql_database,
          $mysql_home_field, $mysql_table, $mysql_userid_field;


   $ds = mysql_connect($mysql_server, $mysql_user, $mysql_pwd);
   if (!$ds) 
   {
      showError('ERROR: Could not connect to database');
      exit(1);
   }

   if (!mysql_select_db($mysql_database, $ds)) 
   {
      showError('ERROR: Could not find database');
      exit(1);
   }

   $query_string = 'SELECT ' . $mysql_home_field 
                 . ' FROM '  . $mysql_table
                 . ' WHERE ' . $mysql_userid_field . '="' . $user . '"';

   $select_result = mysql_query($query_string, $ds);
    
   if (!$select_result) 
   {
      showError('ERROR: Database call failed');
      exit(1);
   }

   if (mysql_num_rows($select_result) != 1) 
   {
      showError('ERROR: Could not fetch correct user info');
      exit(1);
   }

   // after all that...  get query results
   //
   $row = mysql_fetch_row($select_result);
   return $row[0];

}



?>
