<?php
/**
 * plugins/cookie_warning/setup.php -- Main setup script
 *
 * SquirrelMail Cookie Warning Plugin
 * Copyright (C) 2004 Tomas Kuliavas <tokul@users.sourceforge.net>
 * This program is licensed under GPL. See COPYING for details
 *
 * @version $Id: setup.php,v 1.2 2004/12/06 13:20:21 tokul Exp $
 * @package sm-plugins
 * @subpackage cookie_warning
 */

// make sure SM_PATH is defined
if (!defined('SM_PATH'))  {
    define('SM_PATH','../../');
}

/**
 * init function
 */
function squirrelmail_plugin_init_cookie_warning() {
  global $squirrelmail_plugin_hooks;

  $squirrelmail_plugin_hooks['login_bottom']['cookie_warning'] = 'cookie_warning_onlogin';
}

/**
 * calls main cookie warning function
 */
function cookie_warning_onlogin() {
  include_once(SM_PATH . 'plugins/cookie_warning/functions.php');
  cookie_warning_onlogin_function();
}

/**
 * shows plugin's version
 * @return string
 */
function cookie_warning_version() {
  return '1.0';
}
?>