<?php
/**
 * plugins/cookie_warning/functions.php -- Functions used by plugin
 *
 * SquirrelMail Cookie Warning Plugin
 * Copyright (C) 2004 Tomas Kuliavas <tokul@users.sourceforge.net>
 * This program is licensed under GPL. See COPYING for details
 *
 * @version $Id: functions.php,v 1.2 2004/12/06 13:20:21 tokul Exp $
 * @package sm-plugins
 * @subpackage cookie_warning
 */

/**
 * Detects if session cookie is set.
 * sqgetGlobalVar function is already loaded by src/login.php
 */
function cookie_warning_onlogin_function() {
    global $session_name;
    if (! sqgetGlobalVar($session_name,$session_cookie,SQ_COOKIE)) {
        // Set domain
        bindtextdomain ('cookie_warning', SM_PATH . 'locale');
        textdomain ('cookie_warning');
        echo '<div align="center">'
            .'<p><b>' . _("WARNING: This interface requires cookie support in browser.") . "</b></p>\n"
            ."</div>\n";
        // Revert domain
        bindtextdomain ('squirrelmail', SM_PATH . 'locale');
        textdomain ('squirrelmail');
    }
}
?>