<?php
# plugins/contactclean/options.php
/*
 * Created: May 2007, Copyright ContactClean Ltd. 
 * Author: Ian Rogers
 *
 */
 
require_once(SM_PATH . 'plugins/contactclean/common.php');
 
define('SMOPT_NEED_EMAIL', 0);
define('SMOPT_GRP_CONTACT', 1);
define('SMOPT_GRP_SIG', 2);
define('SMOPT_GRP_POWERED', 3);

/*
 * this main entry function - run by a hook in the options system once this
 * file has been loaded
 */
function load_optpage_data_contactclean() {
    global $data_dir, $username;
 
    $email_address	= getPref($data_dir, $username, 'email_address');
    
    sq_change_text_domain('contactclean');
    if (! $email_address) {
    	$opts = cc_opt_need_email();
    } else { 
    	$opts = cc_opt($email_address);
    }
    sq_change_text_domain('squirrelmail');
    return($opts);
}
    
function cc_opt_need_email() {

    $optgrps = array();
    $optvals = array();

    $optgrps[SMOPT_NEED_EMAIL] = _("Set E-mail Address");

   	$optvals[SMOPT_NEED_EMAIL][] = array(
        'name'    => 'need_address',
        'caption' => _("Set E-mail Address"),
        'type'    => SMOPT_TYPE_COMMENT,
        'refresh' => SMOPT_REFRESH_NONE,
        'comment' =>
        	'<blockquote>'
        	. _("You need to set your address in the <a href=\"options.php?optpage=personal\">Personal Information options page</a>")
        	. '<br/>' 
			. _("Once you've done that, come back here to continue the ContactClean setup ")
			. '</blockquote>' 
    );
    
    $result = array(
        'grps' => $optgrps,
        'vals' => $optvals
    );
    return ($result);
}

function cc_opt($email_address) {
	global $data_dir, $username, $optmode, $javascript_on;
	global $contactclean_key;
	
	/*
	 * TODO support multiple identities/signatures
	 */
	$signature  = getSig($data_dir, $username, 'g');
	$setsig = false;
	if (! $signature and $optmode != 'submit') {
		# no signature is set and we're not in a "submit" phase
		$setsig = true;
	}

	$contactclean_key = getPref($data_dir, $username, 'contactclean_key');

    $optgrps = array();
    $optvals = array();

    $optgrps[SMOPT_GRP_CONTACT] = _("Confirm or Register with ContactClean");

   	$optvals[SMOPT_GRP_CONTACT][] = array(
        'name'    => 'get_account',
        'caption' => sprintf(_("Register with %s"), 'ContactClean'),
        'type'    => SMOPT_TYPE_COMMENT,
        'refresh' => SMOPT_REFRESH_NONE,
        'comment' =>
        	'&nbsp;<br/><div>' 
        	. _("If you don't have an account with ContactClean then you need to register before continuing further.")
        	. '
<blockquote>
<form action="' . CONTACTCLEAN_HTTPS . '/user/addnewuser.php" method="post">
  <table border="0" cellspacing="0" cellpadding="2">
    <tr class="text"> 
      <td align="right" valign="middle">' . _("Current email address") . ': </td>
      <td align="left" valign="middle">' . $email_address . '</td>
    </tr>
    <tr class="text"> 
      <td align="right" valign="middle">' . _("Previous email address") . ': </td>
      <td align="left" valign="middle"> <input name="previous" type="text" id="previous"></td>
      <td>(' . _("optional") . ')</td>
    </tr>
    <tr>
      <td></td>
      <td><input value="' . _("Register Address") . '" type="submit" style="color: #333;padding: 2px"></td>
    </tr>
  </table>
</form>
</blockquote>
'
		. sprintf(
			_("Then fetch your %s and paste it in below."), 
			'<a target=_blank href="' . CONTACTCLEAN_HTTPS . '/user/license_key.php">' . _("search-license key") . '</a>'
		)
		. '</div><br/>&nbsp;'
    );


	$optvals[SMOPT_GRP_CONTACT][] = array(
   	    'name'    => 'contactclean_key',
       	'caption' => 'ContactClean Search-License Key',
       	'type'    => SMOPT_TYPE_STRING,
        'refresh' => SMOPT_REFRESH_NONE,
        'size'    => SMOPT_SIZE_LARGE,
   	);
    
    $optgrps[SMOPT_GRP_SIG] = _("Signature Options");
    $optvals[SMOPT_GRP_SIG] = array();

	if ($setsig && $javascript_on) {
	   	$optvals[SMOPT_GRP_SIG][] = array(
        	'name'    => 'setsig',
        	'caption' => _("Set Signature"),
        	'type'    => SMOPT_TYPE_COMMENT,
        	'refresh' => SMOPT_REFRESH_NONE,
        	'comment' =>
        	    sprintf(
        	    	_("You don't have a signature. <a %s>Click here</a> to set one and share ContactClean with others."),
        			'href="#" onclick="setsig();return(false)"'
	    		),
	    	'post_script'  => "
<script type=\"text/javascript\">
<!--
function setsig() {
	document.getElementsByName('new_signature')[0].innerHTML = \"" 
		. _("Keep in Touch - make sure your address book is up to date by using ContactClean's easy to use services. ")
		. _("To find out more go to www.ContactClean.com") 
		. "\";
	radio_on('new_use_signature');
	radio_on('new_prefix_sig');
}
function radio_on(name) {
	buts = document.getElementsByName(name);
	for (i = 0; i < buts.length; i++) {
		b = buts[i];
		if (b.value == 1) {
			b.checked = true;
		} else {
			b.checked = false;
		}
	}
}
//-->
</script>
"
	    );
	}
	$optvals[SMOPT_GRP_SIG][] = array(
        'name'    => 'signature',
        'caption' => _("Signature"),
        'type'    => SMOPT_TYPE_TEXTAREA,
        'refresh' => SMOPT_REFRESH_NONE,
        'size'    => SMOPT_SIZE_MEDIUM,
        'save'    => 'save_option_signature'
    );
	$optvals[SMOPT_GRP_SIG][] = array(
        'name'    => 'use_signature',
        'caption' => _("Use Signature"),
        'type'    => SMOPT_TYPE_BOOLEAN,
        'refresh' => SMOPT_REFRESH_NONE
    );
    $optvals[SMOPT_GRP_SIG][] = array(
        'name'    => 'prefix_sig',
        'caption' => _("Prefix Signature with '-- ' Line"),
        'type'    => SMOPT_TYPE_BOOLEAN,
        'refresh' => SMOPT_REFRESH_NONE
    );
    
	$optgrps[SMOPT_GRP_POWERED] = '';
    $optvals[SMOPT_GRP_POWERED] = array();

	$optvals[SMOPT_GRP_POWERED][] = array(
        'name'    => 'cc_logo',
        'caption' => '<b>' . _("Powered by") . '</b>',
        'type'    => SMOPT_TYPE_COMMENT,
        'refresh' => SMOPT_REFRESH_NONE,
        'comment' => '
			<a href=' . CONTACTCLEAN_HTTP . ' target="_blank"><img src="' 
			. sqm_baseuri() . 'plugins/contactclean/logo.png" alt="ContactClean.com" border="0"></a>
			<br/>
			<a href="' . CONTACTCLEAN_HTTPS . '/user">' . _("See your account") . '</a>',
    );
    
	$result = array(
        'grps' => $optgrps,
        'vals' => $optvals
    );
    return ($result);
}


/*
 * Saves the signature option 
 * SMELL pinched from include/options/personal.php watch that it doesn't change  
 */
function save_option_signature($option) {
    global $data_dir, $username;
    setSig($data_dir, $username, 'g', $option->new_value);
}