<?php
/*
 * verify.php
 *
 * Copyright (c) 2002-2007 www.ContactClean.com
 *
 * Verify contents of personal address book.
 *
 * Updated for squirrelmail 1.4.x
 *
 */

// SQ boilerplate
if (file_exists('../../include/init.php'))
	include_once('../../include/init.php');
else if (file_exists('../../include/validate.php'))
{
	define('SM_PATH', '../../');
	include_once(SM_PATH . 'include/validate.php');
}
else
{
	chdir('..');
	define('SM_PATH', '../');
	include_once(SM_PATH . 'src/validate.php');
} 

require_once(SM_PATH . 'functions/display_messages.php');
require_once(SM_PATH . 'functions/addressbook.php');
require_once(SM_PATH . 'plugins/contactclean/common.php');
require_once(SM_PATH . 'plugins/contactclean/nusoap.php');

sq_change_text_domain('contactclean');

# TODO: Should detect if we can make https queries in the installation of PHP we're running on!!!
$ml_soap_endpoint = CONTACTCLEAN_HTTPS . '/soap/index.php';

$ml_debug = false;

sqgetGlobalVar('username', $username, SQ_SESSION);
$email_address  = getPref($data_dir, $username, 'email_address');
$contactclean_key  = getPref($data_dir, $username, 'contactclean_key');

// $color should be set by validate.php included above
displayPageHeader($color, 'None');

if (! $email_address) {
    plain_error_message(
        _("You haven't set your email address yet.")
        . "<br/><br/>" 
        . sprintf(
        	_("You need to go to the <a href='%ssrc/options.php?optpage=personal'>Personal Information options page</a> and set your own email address before you can verify your address book"),
        	sqm_baseuri()
        ), 
        $color
    );
    ml_finish_page();
}
if (! $contactclean_key) {
    plain_error_message(
        _("You haven't set your ContactClean.com account key yet.")
		. "<br/><br/>"
		. sprintf(
			_("You need to go to the <a href='%ssrc/options.php?optpage=contactclean'>ContactClean options page</a>"),
			sqm_baseuri()
		),
        $color
    );
    ml_finish_page();
}

/* SMELL from src/addressbook.php watch it doesn't change
 *
 * Open addressbook, with error messages on but without LDAP (the 
 * second "true"). Don't need LDAP here anyway
 */
$abook = addressbook_init(true, true);
if($abook->localbackend == 0) {
    plain_error_message(
        _("No personal address book is defined. Contact your administrator."),
        $color);
    ml_finish_page();
}

/* Get and sort address list */
$alist = $abook->list_addr();
if(!is_array($alist)) {
    plain_error_message($abook->error, $color);
    ml_finish_page();
}
if (count($alist) == 0) {
    plain_error_message(
        _("Nothing in the addressbook (is this what you expect?) - nothing to do"),
        $color
    );
    ml_finish_page();
}
usort($alist,'alistcmp');

global $refresh, $replace, $ml_replace;



if (sqgetGlobalVar('contactclean_replace', $contactclean_replace, SQ_SESSION)
	and ! sqgetGlobalVar('refresh', $refresh, SQ_FORM)
) {
    if ($ml_debug) { echo '<p>Got replace data from session</p>'; }
    $replace = $contactclean_replace;
    sqgetGlobalVar('contactclean_report', $report, SQ_SESSION);
} else {
    /* Grab all the addresses from the address book and find any new
     * addresses in the ContactClean.com database
     */
    if ($ml_debug) { echo "<p>Getting data from SOAP at $ml_soap_endpoint</p>\n"; }
    
	$client = new soapclient_cc($ml_soap_endpoint);
	$client->debug_flag = $ml_debug;

	$quota = do_soap_request($client, 'account_quota', array('key' => $contactclean_key));
	 
    if ('' === $quota or NULL === $quota) {
    	echo _("No quota returned. Some kind of soap error!!!");
    	ml_finish_page();
    }
    if ($quota <= 0) {
    	echo _("You are out of quota. Please try again later");
    	ml_finish_page();
    }

    $emails = array();
    while(list($undef,$row) = each($alist)) {
        /* get a list of all the addresses, culling out duplicates */
        if ($quota <= 0) {
            /*  If we exceeded the max then we'd simply get a SOAP server error back
             *  so it's best just to search the first $quota from the
             *  addressbook so we at least get something
             */
             break;
        }
        if (! isset($emails[$row['email']])) {
            $emails[$row['email']] = 1; 
            $quota--;
        }
    }
    $soap_req = array();
    while(list($addr,$undef) = each($emails)) {
        /* Encrypt all the addresses for sending over in the query. That complicates things
         * a bit as we have to construct an 'un-md5' map for making sense of the soap result.
         */
        $m5 = md5($addr);
        $soap_req[] = $m5;
        $un5[$m5] = $addr;
    }

	$cc_info = contactclean_info();
	$soap_ans = do_soap_request(
		$client, 
		'addr_search', 
		array(
			'key'		=> $contactclean_key,  
           'encoding'	=> 'md5',
           'emails'		=> $soap_req,
           'client'		=> 'Squirrelmail ' . $cc_info['version']
		));

    $search_result = $soap_ans['search_result'];
    $accountnvp = $soap_ans['report'];

	$report = array();
	foreach ($accountnvp as $acc) {
		$report[$acc['name']] = $acc['value']; 
	}
	if ($ml_debug) {
		echo '<p>report:<br/><pre>'; print_r($report); echo '</pre></p>';
	}

    $replace = array();
    while(list($undef,$soap_struct) = each($search_result)) {
        /* The records in the returned soap struct should be in the same order as
         * we supplied them - but we'll use the un-md5 map to make sure we get the right
         * lookup/result pairings.
         */
        $target = $un5[$soap_struct['query']];
        $rep = $soap_struct['result'];
        if ($rep != 'norecord' and $rep != $target) {
            $replace[$target] = $rep;
        }
    }
    /* We want to stick the $replace array into the session so we don't
     * have to keep going back to the soap server for it.
     */
    sqsession_register($replace, 'contactclean_replace');
    sqsession_register($report, 'contactclean_report');
}

#
# ok, now we've got the $replace array we can offer any new addresses to the user.
#

global $repsel, $sel, $repall;

if (sqgetGlobalVar('repsel', $repsel, SQ_FORM)) {
    /* replace the selected ones */
    if (sqgetGlobalVar('sel', $sel, SQ_FORM)) {
    	while(list($undef, $addr) = each($sel)) {
        	$replace_this[$addr] = $replace[$addr];
	    }
    } else {
    	echo _("ERROR: You need to select some addresses to use the 'Replace Selected' button!"), '<p/>';
    	$replace_this = 0;
    }
} elseif (sqgetGlobalVar('repall', $repall, SQ_FORM)) {
    /* replace all of them */
    $replace_this = $replace;
} else {
	/* first time in. Don't do a replace, just show the option buttons at the end */
	$replace_this = 0;
}


if ($replace_this) {
    echo '<p>', _("Updating the addressbook"), '</p>';
    
    /* The user has selected the addresses to replace */
    if ($ml_debug) { print_r($replace_this); }
    reset($alist);

    echo '<p>';
    while(list($undef,$row) = each($alist)) {
        /* go through the addressbook picking out the ones we want to update */
        $email = $row['email'];
        if (isset($replace_this[$email])) {
        	$rep = $replace_this[$email];
            printf(_("Replacing %s with %s"), $email, $rep);
            echo '<br>', "\n";
            $ml_comment = sprintf(
                _("Changed from %s => %s by ContactClean plugin %s"),
                $email, $rep, date('H:i d/M/y')
            );
            $row['label'] = (isset($row['label']) and $row['label'] and ($row['label'] != ' '))
                ? $row['label'] . ' ' . $ml_comment
                : $ml_comment;

            $row['email'] = $rep;
            
            /* use the updated addressbook row to modify the addressbook */
            $r = $abook->modify($row['nickname'], $row, $row['backend']);

            /* Handle error messages */
            if (!$r) {
                 plain_error_message(_("ERROR") . ': ' . $abook->error, $color);
                 ml_finish_page();
            }
            unset($replace[$email]);
        }
    }
    /* update the session as we may have removed some from $replace */
    sqsession_register($replace, 'contactclean_replace');
}

/* show the remainder of the $replace array */

if (count($replace)) {
        /* we might have something to replace, so offer them up to the user */

        $altline = 1;
        $show_replace = 0;
        reset($alist);
        while(list($undef,$row) = each($alist)) {
            $email = $row['email'];
            if (! isset($replace[$email])) {
            	/* nope, nothing in the cache for this address */
                continue;
            }

            if (! $show_replace) {
                /* This is the first replacement we've offered, so do the form html etc. */
                echo _("The following new addresses have been found!<p>Select the ones you want to update in your addressbook.<p>");
?>
				<table border="0" cellpadding="1" cellspacing-"0" width="90%" align="center">
					<form action="<?php echo $PHP_SELF; ?>" method="post">
<?php
                    ml_buttons();
?>
                    <tr bgcolor="<?php echo $color[9] ?>">
                        <th align="left" width="1%"><?php echo _("Nickname") ?></th>
                        <th align="left" width="1%"><?php echo _("Name") ?></th>
                        <th align="left" width="1%"><?php echo _("E-mail") ?></th>
                        <th align="center" width="1%"><?php echo _("Replace?") ?></th>
                        <th align="left" width="%"><?php echo _("Replace with") ?></th>
                    </tr>
<?php
            }
            echo '<tr';
            if ($altline) { echo ' bgcolor="', $color[0], '"'; }
            echo '>';

            echo '<td valign="top" nowrap width="1%">', $row['nickname'], '</td>',
                 '<td valign="top" nowrap width="1%">', $row['name'], '</td>',
                 '<td valign="top" width="1%">', $email, '</td>',
                 '<td valign="top" align="center" width="1%"><input type="checkbox" name="sel[]" value="',
                    $row['email'],
                 '"></td>',
                 '<td valign="top" width="1%">', $replace[$email], '</td>';
            echo "</tr>\n";
            $altline = 1 - $altline; # alternate lines
            $show_replace = 1;
        }
    
        /* End of list. Close table. */
        if ($show_replace) {
            ml_buttons();
            echo '</table>';
            echo '</form>';
        }
} else {
?>
	<p>
	<form action="<?php echo $PHP_SELF; ?>" method="post">
		<?php echo _("Your address book seems completely up to date."); ?>
    	<input type="submit" name="refresh" value="<?php echo _("Check Again"); ?>">
    </form>
    </p>
<?php
}

if ($report['vets']) {
	echo '<p>',
		sprintf(
    	 	_("% entries in your addressbook have been registered with the ContactClean.com database to await authorisation with the searchee. Please try again in a few days time in case you have been authorised to see some new addresses."),
    	 	$report['vets']
    	),
		'</p>';
}

?>
<p align="center">
<a href="http://www.ContactClean.com" "target=_blank"><img src="logo.png" alt="ContactClean.com" border="0"><br/>
<?php echo _("Powered by") ?></a>
</p>
<?php

function do_soap_request($client, $cmd, $params) {
	global $ml_debug;
	
	if ($ml_debug) {
		echo '<p><b>Function: </b>', $cmd, '<br/>',
			'<b>Params:</b><br/>';
		print_r($params);
		echo '</p>';
	}
	
	// $return = false;
    $return = $client->call($cmd, $params, "urn:contactclean");
    
    if ($ml_debug) {
    	if ($return) {
    		print "<p><b>return:</b><br/><pre>"; print_r($return); print "</pre></p>\n";
	    }
	
		echo '<h2>Request</h2><pre>', htmlspecialchars($client->request, ENT_QUOTES), "</pre>\n";
		echo '<h2>Response</h2><pre>', htmlspecialchars($client->response, ENT_QUOTES), "</pre>\n";
		// echo '<h2>Debug</h2><pre>', htmlspecialchars($client->debug_str, ENT_QUOTES), "</pre>\n";
    }
    if ($err = $client->getError()) { 
       print "<p>$err</p>\n";
       ml_finish_page();
    }
	return($return);
}

function ml_buttons() {
?>
<tr>
    <td colspan="5" align="center">
        <input type="submit" name="repsel" value="<?php echo _("Replace selected") ?>" />
        <input type="submit" name="repall" value="<?php echo _("Replace all") ?>" />
        <input type="submit" name="refresh" value="<?php echo _("Refresh") ?>" />
    </td>
</tr>
<?php
}

function ml_finish_page() {
?>
</body>
</html>
<?php
    exit;
}
