<?php

/**
 * setup.php
 * 
 * setup file for the ContactClean client
 *   
 * by: Ian Rogers ian.rogers@contactclean.com
 *
 * @copyright &copy; 2002-2007 www.ContactClean.com 
 * @package plugins
 * @subpackage contactclean
 */
 
function squirrelmail_plugin_init_contactclean() {
    global $squirrelmail_plugin_hooks;
    
    // options hooks
    $squirrelmail_plugin_hooks['optpage_loadhook_personal']['contactclean']	= 'contactclean_options_personal';
    $squirrelmail_plugin_hooks['optpage_set_loadinfo']['contactclean']		= 'contactclean_options_pageload';
	$squirrelmail_plugin_hooks['optpage_register_block']['contactclean']	= 'contactclean_optpage_register_block';
	
	// addressbook hooks
    $squirrelmail_plugin_hooks['addressbook_bottom']['contactclean']		= 'contactclean_addressbook_bottom';
    // SMELL (see plugins/contactclean/addressbook_functions.php)
    $squirrelmail_plugin_hooks['addressbook_bottom']['cc_clearcache']		= 'contactclean_clear_cache';
}

/* Options hooks */
function contactclean_options_personal() {
	include_once(SM_PATH . 'plugins/contactclean/options_functions.php');
	do_contactclean_options_personal();
}
function contactclean_options_pageload() {
	include_once(SM_PATH . 'plugins/contactclean/options_functions.php');
	do_contactclean_options_pageload();
}
function contactclean_optpage_register_block() {
	include_once(SM_PATH . 'plugins/contactclean/options_functions.php');
	do_contactclean_optpage_register_block();
}
	
/* Addressbook hooks */
function contactclean_addressbook_bottom() {
	include_once(SM_PATH . 'plugins/contactclean/addressbook_functions.php');
	do_contactclean_addressbook_bottom();
}
function contactclean_clear_cache() {
	include_once(SM_PATH . 'plugins/contactclean/addressbook_functions.php');
	do_contactclean_clear_cache();
}


function contactclean_version() {
	$info = contactclean_info();
	return $info['version'];
}
function contactclean_info() {
	return array(
		'english_name' => 'Addressbook ContactClean',
		'authors' => array(
			'Ian Rogers' => array(
				'sm_site_username' => 'ian', 
				'email' => 'admin@contactclean.com'
			)
		),
   		'version' => '3.3.1',
   		'required_sm_version' => '1.4.4',
   		'summary' => 'Keep your addressbook up to date.',
   		'details' => 'Adds a link at the bottom of your addressbook so you can verify how up-to-date your contacts are.

If you click on that link a one-way (MD5) encoded version of your addressbook is created (so your contacts remain secret) and these keys are checked against the MailLocate md5 database. If there is a match your addressbook is updated with the new contact along with suitable comments.

Also adds a link into your Personal Properties page so you can easily register any old email addresses of your own. ',
	   	'requires_configuration' => 0,  
		'per_version_requirements' => array(
			'1.5.2' => array(
				'required_plugins' => array()
			),
			'1.5.0' => array(
				'required_plugins' => array(
					'compatibility' => array(
						'version' => '2.0.7',
						'activate' => FALSE,
					)
				)
			),
			'1.4.10' => array(
				'required_plugins' => array()
			),
			'1.4.8' => array(
				'required_plugins' => array(
					'compatibility' => array(
						'version' => '2.0.7',
						'activate' => FALSE,
					)
				)
			),
			'1.4.6' => array(
				'required_plugins' => array(
					'compatibility' => array(
						'version' => '2.0.7',
						'activate' => FALSE,
					)
				)
			),
			'1.4.4' => array(
				'required_plugins' => array(
					'compatibility' => array(
						'version' => '2.0.7',
						'activate' => FALSE,
					)
				)
			),
		),
   		//'required_php_modules' => array(
        //	),
		//'required_pear_packages' => array(
        //	),
   		//'required_functions' => array(
        //	),
        
		//'required_php_version' => '4.0.6',
		// 'other_requirements' => '',
		'external_project_uri' => 'http://www.ContactClean.com/download/squirrelmail.php'
	);
}