<?php
# plugins/contactclean/options_functions.php
/*
 * Created: May 2007, Copyright ContactClean Ltd. 
 * Author: Ian Rogers
 *
 */

require_once(SM_PATH . 'plugins/contactclean/common.php');

function do_contactclean_options_pageload() {
	global $optpage, $optpage_name, $optpage_file, $optpage_loader, $optpage_loadhook;

	if ($optpage != 'contactclean') return;
	
    $optpage_name = 'ContactClean';
    $optpage_file = SM_PATH . 'plugins/contactclean/options.php';
    $optpage_loader = 'load_optpage_data_contactclean';
    $optpage_loadhook = 'optpage_loadhook_contactclean';
}

function do_contactclean_optpage_register_block() {
	global $optpage_blocks;

	sq_change_text_domain('contactclean');
    $optpage_blocks[] = array(
        'name' => 'ContactClean',
        'url'  => sqm_baseuri() . 'src/options.php?optpage=contactclean',
        'desc' => _("Set your ContactClean account details to enable the Addressbook cleaning function."),
        'js'   => false
    );
    sq_change_text_domain('squirrelmail');
}

function do_contactclean_options_personal() {
    global $optpage_data;
    # print '<p>contactclean_options_personal running<br>';

    $opts = $optpage_data['vals'][SMOPT_GRP_CONTACT];
    
    /* build the entry we want to add into the options
    */
    sq_change_text_domain('contactclean');

    $ml_link_value = '<a href="' . sqm_baseuri() . '/src/options.php?optpage=contactclean">'
                     . _("Register my Old Address(es) with ContactClean")
                     . '</a> '
					 . _("(discards changes made on this form so far)");
    $ml_opt = array(
        'name'    => 'contactclean_register',
        'caption' => _("Previous Address"),
        'type'    => SMOPT_TYPE_COMMENT,
        'refresh' => SMOPT_REFRESH_NONE,
        'comment' =>  $ml_link_value
    );

	sq_change_text_domain('squirrelmail');

    /* SMELL Try to find the position of the current email address in the options
       so we can add our link right under it for best aesthetics
    */
    $insert_pos = 0;
    $numopts = count($opts);
    for($i=0; $i<$numopts; $i++) {
        if ('email_address' == $opts[$i]['name']) {
            $insert_pos = $i + 1;
            break;
        }
    }
    # print "found position $insert_pos<br>";
    if ($insert_pos) {
        /* Shove all the other options along one so we can insert ours
        */
        $opts[] = 'grum'; # extend the array
        for($i = $numopts; $i >= $insert_pos; $i--) {
            $opts[$i] = $opts[$i - 1];
        }

        /* Do the insertion */
        $opts[$insert_pos] = $ml_opt;
    } else {
        /* hmm, didn't find the address in the options
           We'll just add the link on at the end of the list of options, but I guess
           the underlying representation has changed and really we need to update this plugin!
        */
        $opts[] = $ml_opt;
    }

    /* put the new options list back into the group. */
    $optpage_data['vals'][SMOPT_GRP_CONTACT] = $opts;
}