<?php

	function squirrelmail_plugin_init_compose_fix() {
		global $squirrelmail_plugin_hooks;

		$squirrelmail_plugin_hooks['options_display_inside']['compose_fix'] = 'cf_display_inside';
		$squirrelmail_plugin_hooks['options_display_save']['compose_fix'] = 'cf_display_save';
		$squirrelmail_plugin_hooks['compose_bottom']['compose_fix'] = 'cf_compose_fix';
	}	


	function cf_option($var, $value, $name) {
		return "<option value='$value'".
			(($var == $value) ? ' selected="selected"' : '').
			">$name</option>";
	}

	function cf_radio($var, $value, $name, $label) {
		return "<input type='radio' name='$name' value='$value'".
			(($var == $value) ? ' checked="checked"' : '').
			" />&nbsp;$label&nbsp;&nbsp;&nbsp;&nbsp;";
	}

	function cf_display_inside() {
		global $username, $data_dir;

		$tabs = getPref($data_dir, $username, 'fix_compose_tabs', '1');
        $focus = getPref($data_dir, $username, 'fix_reply_focus', '1');

		print '<tr><th colspan="2">Compose window fixes</th></tr>'.
            '<tr><td align="right">Fix compose-window tabs:</td><td>'.
			'<select name="fix_compose_tabs">'.
			cf_option($tabs, '0', 'Leave unfixed').
			cf_option($tabs, '1', 'To-Subject-Message').
			cf_option($tabs, '2', 'To-Cc-Bcc-Subject-Message').
			'</select></td></tr>'.
            '<tr><td align="right">Replies open with cursor in message body:'.
            '</td><td>'.cf_radio($focus, '1', 'fix_reply_focus', _('Yes')).
            cf_radio($focus, '0', 'fix_reply_focus', _('No')).'</td></tr>'.
            '<tr><td colspan="2">&nbsp;</td></tr>';
	}
	
	function cf_display_save() {
		global $username, $data_dir;

		if (isset($_POST['fix_compose_tabs'])) {
			$tabs = $_POST['fix_compose_tabs'];
		} else {
			$tabs = '1';
		}
        setPref($data_dir, $username, 'fix_compose_tabs', $tabs);

		if (isset($_POST['fix_reply_focus'])) {
			$focus = $_POST['fix_reply_focus'];
		} else {
			$focus = '1';
		}
        setPref($data_dir, $username, 'fix_reply_focus', $focus);
	}

	function cf_compose_fix() {
		global $username, $data_dir, $reply_id;

        $sm_path = defined('SM_PATH') ? SM_PATH : '../';
		$tabs = getPref($data_dir, $username, 'fix_compose_tabs', '1');
        if ($tabs == 1) {
            include($sm_path . 'plugins/compose_fix/tabs1.php');
        } elseif ($tabs == 2) {
            include($sm_path . 'plugins/compose_fix/tabs2.php');
        }

        $focus = getPref($data_dir, $username, 'fix_reply_focus', '1');
		if ($focus and $reply_id) {
			print "\n<script language='javascript'>\n<!--\n".
				"function checkForm() {\n".
				"    compose.body.focus();\n".
				"}\n".
				"// -->\n</script>\n";
		}
	}


?>
