<?php

/**
  * SquirrelMail Compose Extras Plugin
  * Copyright (c) 2004-2005 Bruce Richardson <itsbruce@uklinux.net>
  *                         Paul Lesneiwski <pdontthink@angrynerds.com>
  * Licensed under the GNU GPL. For full terms see the file COPYING.
  *
  * @package plugins
  * @subpackage Compose Extras
  *
  */



/**
  * Register this plugin with SquirrelMail
  *
  */
function squirrelmail_plugin_init_compose_fix() 
{

   global $squirrelmail_plugin_hooks;

   // 1.4.x - 1.5.0:  options go on display options page
   // 1.5.1  and up:  options go on compose options page
   //
   $squirrelmail_plugin_hooks['optpage_loadhook_display']['compose_fix'] = 'cf_show_options';
   $squirrelmail_plugin_hooks['optpage_loadhook_compose']['compose_fix'] = 'cf_show_options';

   $squirrelmail_plugin_hooks['compose_bottom']['compose_fix'] = 'cf_compose_go';
   $squirrelmail_plugin_hooks['compose_form']['compose_fix'] = 'cf_fix_body';

}	



/** @ignore */
if (!defined('SM_PATH'))
   define('SM_PATH', '../');



/**
  * Returns version info about this plugin
  *
  */
function compose_fix_version()
{

   return '0.3';

}



/**
  * Integrate options into SM options page
  * 
  */
function cf_show_options($args)
{

   include_once(SM_PATH . 'plugins/compose_fix/functions.php');
   cf_show_options_do($args);

}



/**
  * Inserts javascript for tab fixes
  * 
  */
function cf_compose_go()
{

   include_once(SM_PATH . 'plugins/compose_fix/functions.php');
   cf_compose_go_do();

}



/**
  * Adjusts body text as needed
  * 
  */
function cf_fix_body()
{

   include_once(SM_PATH . 'plugins/compose_fix/functions.php');
   cf_fix_body_do();

}



?>
