<?php

/**
  * SquirrelMail Cleanup Plugin
  * Copyright (c) 2003 Jimmy Conner <jimmy@advcs.org>,
  * Copyright (c) 2008 Paul Lesniewski <paul@squirrelmail.org>,
  * Licensed under the GNU GPL. For full terms see the file COPYING.
  *
  * @package plugins
  * @subpackage cleanup
  *
  */



/**
  * Register this plugin with SquirrelMail
  *
  */
function squirrelmail_plugin_init_cleanup()
{

   global $squirrelmail_plugin_hooks;


   // do cleanup
   //
   $squirrelmail_plugin_hooks['login_verified']['cleanup']
      = 'cleanup';


   // configuration check
   //
   $squirrelmail_plugin_hooks['configtest']['cleanup']
      = 'cleanup_check_configuration';

}



/**
  * Do cleanup
  *
  */
function cleanup()
{
   include_once(SM_PATH . 'plugins/cleanup/functions.php');
   return cleanup_do();
}



/**
  * Validate that this plugin is configured correctly
  *
  * @return boolean Whether or not there was a
  *                 configuration error for this plugin.
  *
  */
function cleanup_check_configuration()
{
   include_once(SM_PATH . 'plugins/cleanup/functions.php');
   return cleanup_check_configuration_do();
}



/**
  * Returns info about this plugin
  *
  */
function cleanup_info()
{

   return array(
                 'english_name' => 'Cleanup',
                 'authors' => array(
                    'Jimmy Conner' => array(
                       'email' => 'jimmy@advcs.org',
                    ),
                    'Paul Lesniewski' => array(
                       'email' => 'paul@squirrelmail.org',
                       'sm_site_username' => 'pdontthink',
                    ),
                 ),
                 'version' => '0.3',
                 'required_sm_version' => '1.4.0',
                 'requires_configuration' => 0,
                 'summary' => 'Does housekeeping for administrators using hosted servers with limited access.',
                 'details' => 'This plugin provides a means for accomplishing some SquirrelMail housekeeping chores for administrators who are using a hosted solution that does not provide the ability to run cron jobs or otherwise manage the webmail system using normal means.<br /><br />Currently, the only task that is done is cleanup of the SquirrelMail attachments directory.  The normal way to do this is create a cron job (there are examples in the README file), but if this is not possible, this plugin can be used for attachment file cleanup.',
                 'requires_source_patch' => 0,
               );

}



/**
  * Returns version info about this plugin
  *
  */
function cleanup_version()
{
   $info = cleanup_info();
   return $info['version'];
}



