<?php
// Change_qldforward 1.00 (05/03/03)
//  
// Copyright Raymond Ferguson 2003.
//
// Thanks to Simon Annetts for change_ldappass, his was the
// base code I done bludgeoned.
//
// This software may be used, modified and distributed freely
// providing this copyright notice remains intact at the head 
// of the file.
//
// This software is freeware. The author accepts no liability for
// any loss or damages whatsoever incurred directly or indirectly 
// from the use of this script. The author of this software makes 
// no claims as to its fitness for any purpose whatsoever. If you 
// wish to use this software you should first satisfy yourself that 
// it meets your requirements.
//
// Email: foo@share-foo.com
//

chdir ("..");

define('SM_PATH','../');

// include compatibility plugin
if (defined('SM_PATH'))
   include_once(SM_PATH . 'plugins/compatibility/functions.php');
else if (file_exists('../plugins/compatibility/functions.php'))
   include_once('../plugins/compatibility/functions.php');
else if (file_exists('./plugins/compatibility/functions.php'))
   include_once('./plugins/compatibility/functions.php');



if (compatibility_check_sm_version(1, 3)) {
   include_once (SM_PATH . 'include/validate.php');
   include_once (SM_PATH . 'functions/page_header.php');
   include_once (SM_PATH . 'include/load_prefs.php');
   include_once (SM_PATH . "functions/strings.php");
   include_once (SM_PATH . "functions/imap.php");
} else {
   include_once ('../src/validate.php');
   include_once ('../functions/page_header.php');
   include_once ('../src/load_prefs.php');
   include_once ('../functions/strings.php');
   include_once ('../functions/imap.php');
}


   if ($_POST['plugin_change_qldforward'] != null) $Messages = change_qldforward_check();
 
   displayPageHeader($color, "None");

// At start, get current setting and add it to messages if any and grab the dn for rebind later.
  if (! $Messages){
      include(SM_PATH . "plugins/change_qldforward/config.php");
      if ($debug) array_push($Messages, "Connecting to LDAP Server");
      $username = $_SESSION['username'];
      $ds=ldap_connect($ldap_server);
      if (! $ds) {
          array_push($Messages,'Can\'t connect to Directory Server, please try later!');
          return $Messages;
      }
      $r=ldap_bind($ds,"","");
      $sr=ldap_search($ds,$ldap_base_dn,"($ldap_user_field=$username)"); //search for uid
      if (ldap_count_entries($ds,$sr)>1) {
          array_push($Messages,'Duplicate mailaddress entries detected, cannot change forwarding!');
          return $Messages;
      }
      if (ldap_count_entries($ds,$sr)==0) {
          array_push($Messages,'Your mailaddress was not found in the LDAP database, cannot change forwarding!');
          return $Messages;
      }
      $info = ldap_first_entry($ds,$sr);
      if ($debug){ 
          for ($i=0; $i<$attrs["count"]; $i++) echo $attrs[$i]."<br>";
      }
      $dn=ldap_get_dn($ds,$info);
      compatibility_sqsession_register($dn, 'dn');
      if ($debug) print $dn;
      $val = @ldap_get_values($ds,$info,$forwarding_field);
      if ($val){ 
          $current_forward = $val[0];
          $Messages = array();
          array_push($Messages,"Email for $username is currently forwarded to $current_forward.");
      }
      @ldap_close($ds);
  }

?>


<br>
<table width=95% align=center cellpadding=2 cellspacing=2 border=0>
<tr><td bgcolor="<?php echo $color[0] ?>">
   <center><b>Set Forwarding Address</b></center>
</td><?php

if (isset($Messages) && count($Messages)) {
    echo "<tr><td>\n";
    foreach ($Messages as $line) {
        echo $line . "<br>\n";
    }
    echo "</td></tr>\n";
}

?><tr><td>
    <form method=post action="<?php print $_SERVER['PHP_SELF'] ?>">
    <table>
      <tr>
        <th align=right>Forward Mail To:</th>
        <td><input type=text name=cp_forward value="<?php if (isset($current_forward)) print $current_forward; ?>"  size=22>(Leave blank to cancel forwarding.)</td>
      </tr>
      <tr>
        <th align=right>Password:</th>
        <td><input type=password name=cp_oldpass value="" size=22></td>
      </tr>
      <tr>
        <td align=center colspan=2><input type=submit value="Submit" name="plugin_change_qldforward"></td>
      </tr>
    </table>
</td></tr>
</tr></table>
</body></html>
<?php

function change_qldforward_check($debug = 0) {
	$cp_oldpass = $_POST['cp_oldpass'];
	$newforward = $_POST['cp_forward'];
	$plugin_change_qldforward = $_POST['plugin_change_qldforward'];
	$username = $_SESSION['username'];

	$Messages = array();

	if ($cp_oldpass == "")	array_push($Messages, 'You must type in your password.');
	if (count($Messages)) return $Messages;
	return change_qldforward_go($debug);
}


function change_qldforward_go($debug) {
		$username = $_SESSION['username'];
		$base_uri = $_SESSION['base_uri'];
	        $dn = $_SESSION['dn'];
		$cp_oldpass = $_POST['cp_oldpass'];
		$newforward = $_POST['cp_forward'];

		include_once(SM_PATH . "plugins/change_qldforward/config.php");
	
                $Messages = array();
                if ($debug) array_push($Messages, "Connecting to LDAP Server");

 		$ds=ldap_connect($ldap_server);
		if (! @ldap_bind($ds,$dn,$cp_oldpass)) { //if we can't bind as the user then the old passwd must be wrong
			array_push($Messages,'Your password was entered incorrectly.');
			return $Messages;
		} else {
			if ($debug) array_push($Messages,"Bind to database as $dn successful.");	
		}
		if ($debug) array_push($Messages,"New forward: $newforward");
		$newentry=array();
                if ($newforward == "") {
                        $sr = ldap_search($ds,$dn,"($ldap_user_field=$username)");
                        $info = ldap_first_entry($ds,$sr);
			$current_forward = @ldap_get_values($ds,$info,$forwarding_field);
			if (!$current_forward) {
				array_push($Messages,"Error: No forward found to delete.");
                                return $Messages;
			} else {
                        	$dele_attribs[$forwarding_field] = array() ;
				$result2 = ldap_mod_del($ds,$dn,$dele_attribs);
				if ( $delivery_mode_field ) {
					$add_attribs[$delivery_mode_field] = $delivery_mode_local_val ;
			        	$result2 .= ldap_modify($ds,$dn,$add_attribs);
				}
			}
                } else {
			$add_attribs[$forwarding_field][0] = $newforward;
			if ( $delivery_mode_field ) {
				$add_attribs[$delivery_mode_field] = $delivery_mode_forward_val ;
			}
                        $result2 = ldap_modify($ds,$dn,$add_attribs);
                }

                if ($result2) {
                        if ($newforward == "") {
	                        array_push($Messages,"Email to $username no longer forwarded.");
       		                return $Messages;
                        } else {
	                        array_push($Messages,"Email to $username now forwarded to $newforward.");
       		                return $Messages;
                	}
		} else {
	                array_push($Messages,"LDAP Modify failed :" . ldap_error($ds));
       		        return $Messages;
                }
		@ldap_close($ds);
}

?>
