/*
how-to compile:
# gcc -lcrypt -O -o chpasswd chpasswd.c; chmod 4750 chpasswd; chown root:apache chpasswd
*/
#define STR_MAX 100
#define MAXLEN 1024
#define hhex(x) (((x) >= '0' && (x) <= '9') || ((x) >= 'a' && (x) <= 'f') || ((x) >= 'A' && (x) <= 'F'))

#include <stdio.h>
#include <time.h>
#include <unistd.h>

void eperror(register char *);
void getword(char *, char *, char);
void to64(register char *, register long, register int);
void putline(FILE *,char *);
static void fixpwd(unsigned char *);
static int htoi(unsigned char *s);

int main(int argc, char *argv[]){
	/*
	Developed by
	Pedro L Orso - orso@onda.com.br
	Changed by
	Thiago Melo de Paula - thiago@fafibe.br
	*/
	int i, ok;
	char User[STR_MAX];
	char buf[MAXLEN];
	char PUser[50];
	char New_pw[50];
	char Old_pw[50];
	char WOld_pw[50];
	char Wrest[MAXLEN];
	char pwdfile[255]="/etc/passwd";
	char command[255];
	char WUser[50];
	char *cpw, salt[3];
	char *tn;
	int  Uid, Gid, test = 0;
	FILE *fpw, *tmp;

	tn = NULL;

	if((setuid(0)) < 0) eperror("setuid");
	if((setgid(3)) < 0) eperror("setgid");

	sprintf(User,"%s",argv[1]);
	sprintf(Old_pw,"%s",argv[2]);
	sprintf(New_pw,"%s",argv[3]);

	if(!strlen(User)){
		printf("You forgot the user.\n");
		return 1;
	}

	if(!strcmp("(null)",New_pw)){
		printf("You forgot the New password.\n");
		return 2;
	}

	if(!strcmp("(null)",Old_pw)){
		printf("You forgot the Current Password.\n");
		return 3;
	}

	if(!strcmp(User,"root")){
		printf("The %s user cannot be edited for security reasons.\n",User);
		return 4; //the root user cannot be edited for security reasons
	}

	fixpwd(New_pw);
	fixpwd(Old_pw);
	fixpwd(User);

	if(!strcmp(Old_pw,New_pw)){
		printf("The new password is equal to old password. Choose another password.\n");
		return 5;
	}

	if(access("/etc/shadow",R_OK) == 0){
		sprintf(pwdfile, "/etc/shadow");
		test = 1;
	}

	strcpy(PUser,User);
	strcat(PUser,":");

	if((fpw=fopen(pwdfile,"r"))==NULL){
		printf("Fail reading the %s file\n",pwdfile);
		if(!test)
			return 6;
		return 7;
	}

	tn = tmpnam(NULL);
	if((tmp=fopen(tn,"w"))==NULL){
		printf("The temporary file %s cannot be opened!\n",tn);
		return 8;
	}

	ok = 0;
	while(fgets(buf,MAXLEN,fpw)!=NULL){
		if(!ok){
			if(strncmp(buf,PUser,strlen(PUser)) == 0){
				getword(WUser,buf,':');
				getword(WOld_pw,buf,':');
				strcpy(Wrest,buf);

				if(strcmp(WOld_pw, (char *)crypt(Old_pw, WOld_pw)) != 0){
					if(fpw)
						fclose(fpw);
					if(tmp){
						fclose(tmp);
						unlink(tn);
					}
					printf("Current password don't match with the password of the server\n");
					return 9;
				}

				(void)srand((int)time((time_t *)NULL));
				to64(&salt[0],rand(),2);
				cpw = (char *)crypt(New_pw,salt);
				sprintf(buf,"%s:%s:%s\n",User,cpw,Wrest);
				buf[strlen(buf)-1]='\0';
				ok++;
			}
		} 
		putline(tmp,buf);
	}

	fclose(fpw);
	fclose(tmp);

	if(ok) {
		sprintf(command,"cp %s %s",tn,pwdfile);
		system(command);
		unlink(tn);
		printf("The password was modified successfully\n");
		return 0;
	} else {
		printf("The user %s don't exist!\n",User);
		unlink(tn);
		return 10;
	}

}

void eperror(s)
register char *s;
{
	/*
	Developed by
	Pedro L Orso - orso@onda.com.br
	Changed by
	Thiago Melo de Paula - thiago@fafibe.br
	*/
   char str[50];

   sprintf(str,"chpasswd - %s",s);
   perror(str);
   exit(1);
}

void getword(char *word, char *line, char stop) 
{
	/*
	Developed by
	Pedro L Orso - orso@onda.com.br
	*/
   int x = 0,y;

   for(x=0;((line[x]) && (line[x] != stop));x++)
      word[x] = line[x];

   word[x] = '\0';
   if(line[x]) ++x;
   y=0;

   while((line[y++] = line[x++]));
}

static void
fixpwd(str)
   unsigned char   *str;
{
	/*
	Developed by
	Pedro L Orso - orso@onda.com.br
	*/	 
   unsigned char   *dest = str;

   while (str[0]) {
      if (str[0] == '+')
         dest[0] = ' ';
      else if (str[0] == '%' && hhex(str[1]) && hhex(str[2])) {
         dest[0] = (unsigned char) htoi(str + 1);
         str += 2;
      } else dest[0] = str[0];

      str++;
      dest++;
   }

   dest[0] = '\0';
   return;
}

static int
htoi(s)
   unsigned char   *s;
{
	/*
	Developed by
	Pedro L Orso - orso@onda.com.br
	*/
   int     value;
   char    c;

   c = s[0];
   if (isupper(c))
      c = tolower(c);
   value = (c >= '0' && c <= '9' ? c - '0' : c - 'a' + 10) * 16;

   c = s[1];
   if (isupper(c))
      c = tolower(c);
   value += c >= '0' && c <= '9' ? c - '0' : c - 'a' + 10;

   return (value);
}

static unsigned char itoa64[] =         /* 0 ... 63 => ascii - 64 */
        "./0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
	/*
	Developed by
	Pedro L Orso - orso@onda.com.br
	*/

void to64(s, v, n)
   register char *s;
   register long v;
   register int n;
{
	/*
	Developed by
	Pedro L Orso - orso@onda.com.br
	*/
   while (--n >= 0) {
      *s++ = itoa64[v&0x3f];
      v >>= 6;
   }
}

void putline(FILE *f,char *l) {
	/*
	Developed by
	Pedro L Orso - orso@onda.com.br
	*/
   int x;

   for(x=0;l[x];x++) fputc(l[x],f);
   return;
}
