<?php

/*
 * PHP Captcha 1.0
 * Copyright (C) 2007 Kerem Erkan <kerem@keremerkan.net>
 *
 * Do not edit this file unless you know what you are doing!
*/

function phpcaptcha_check_captcha()
{
  @session_start();

  if ( !empty($_SESSION["captcha"]) )
  {
    if ( !empty($_POST["captcha"]) )
    {
      if ( !empty($_SESSION["captcha_expiration_time"]) )
      {
        $now = time();

        if ( ($now - $_SESSION["captcha_expiration_time"]) > 0 )
        {
          phpcaptcha_unset_variables();
          return -5; // Captcha string expired
        }
      }

      list($max, $sufficient) = explode(":", $_SESSION["captcha_text_info"]);

      if ( !preg_match("/^[a-zA-Z0-9]{1,$max}$/", $_POST["captcha"]) )
      {
        phpcaptcha_unset_variables();
        return -2; // Invalid or too many characters (possibly an attack)
      }

      $_POST["captcha"] = trim(str_replace("0","O",$_POST["captcha"]));

      if ( $_SESSION["captcha_text_case_sensitive"] == 0 )
        $_POST["captcha"] = strtoupper($_POST["captcha"]);

      if ( $sufficient == 0 )
      {
        if ( function_exists("hash") )
          $_POST["captcha"] = hash("md5", $_POST["captcha"]);
        else
          $_POST["captcha"] = md5($_POST["captcha"]);

        if ( $_SESSION["captcha"] != $_POST["captcha"] )
        {
          phpcaptcha_unset_variables();
          return -1; // Wrong text entered
        }
        elseif ( $_SESSION["captcha"] == $_POST["captcha"] )
        {
          phpcaptcha_unset_variables();
          return 0; // Right text entered
        }
      }
      else
      {
        $correct = 0;

        for ( $i = 0; $i < strlen($_POST["captcha"]); $i++ )
        {
          $pos = strpos($_SESSION["captcha"], $_POST["captcha"]{$i});

          if ( $pos !== FALSE )
          {
            $correct++;
            $_SESSION["captcha"] = substr_replace($_SESSION["captcha"], "", $pos, 1);
          }

          unset($pos);
        }

        if ( $correct < $sufficient )
        {
          phpcaptcha_unset_variables();
          return -1; // Insufficient correct characters entered
        }
        else
        {
          phpcaptcha_unset_variables();
          return 0; // Sufficient correct characters entered
        }
      }
    }
    else
    {
      phpcaptcha_unset_variables();
      return -3; // Empty string posted
    }
  }
  else
  {
    phpcaptcha_unset_variables();
    return -4; // Session variable was unset
  }
}

function phpcaptcha_set_random_text_direction()
{
  @session_start();

  if ( mt_rand(0,1) == 0 )
    $_SESSION["captcha_text_direction"] = "RL";
  else
    $_SESSION["captcha_text_direction"] = "LR";
}

function phpcaptcha_unset_variables()
{
  unset($_SESSION["captcha"],
        $_SESSION["captcha_text_direction"],
        $_SESSION["captcha_text_case_sensitive"],
        $_SESSION["captcha_text_info"],
        $_SESSION["captcha_expiration_time"],
        $_POST["captcha"]);
}
  
function phpcaptcha_get_random_string($length,$type="")
{
  if ( $length > 0 )
  {
    $lowercase = "abcdefghijklmnopqrstuvwxyz";
    $uppercase = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    $numbers   = "123456789";
    $pointers  = "abdnst123456790-.[";

    if ( empty($type) )
      $random_string = $lowercase . $uppercase . $numbers;
    elseif ( strtoupper($type) == "P" )
      $random_string = $pointers;
    else
    {
      $random_string = "";
      if ( strpos(strtoupper($type), "L") !== FALSE )
        $random_string .= $lowercase;
      if ( strpos(strtoupper($type), "U") !== FALSE )
        $random_string .= $uppercase;
      if ( strpos(strtoupper($type), "N") !== FALSE )
        $random_string .= $numbers;
    }

    $last = strlen($random_string) - 1;

    $random_id='';

    for( $i = 1; $i <= $length; $i++ )
    {
      $num = mt_rand(0,$last);
      $random_id .= $random_string{$num} . " ";
    }
  }
  $random_id = rtrim($random_id);
  return $random_id;
}

function phpcaptcha_get_random_color($rand1=0,$rand2=255)
{
  $color = "#" . sprintf("%02s",dechex(mt_rand($rand1,$rand2))) .
                 sprintf("%02s",dechex(mt_rand($rand1,$rand2))) .
                 sprintf("%02s",dechex(mt_rand($rand1,$rand2)));

  return $color;
}

