/*******************************************************************************

    Author ....... Jonathan S. Earle
    Contact ...... plugins@kronos.honk.org
    Home Site .... http://kronos.honk.org/~earlej/
    Program ...... Canadian Weather

*******************************************************************************/

/*
var js_languages = new Array();
js_languages[0] = new Array();
js_languages[0][0] = new Option("", "");
js_languages[0][1] = new Option("English", "e");
js_languages[0][2] = new Option("franais", "f");
*/

var js_e_provinces = new Array();
js_e_provinces[0] = new Array();
js_e_provinces[0][0]  = new Option("", "");
js_e_provinces[0][1]  = new Option("Ontario", "ON");
js_e_provinces[0][2]  = new Option("Quebec", "QC");
js_e_provinces[0][3]  = new Option("Alberta", "AB");
js_e_provinces[0][4]  = new Option("British Columbia", "BC");
js_e_provinces[0][5]  = new Option("Saskatchewan", "SK");
js_e_provinces[0][6]  = new Option("Manitoba", "MB");
js_e_provinces[0][7]  = new Option("Newfoundland and Labrador", "NF");
js_e_provinces[0][8]  = new Option("New Brunswick", "NB");
js_e_provinces[0][9]  = new Option("Prince Edward Island", "PE");
js_e_provinces[0][10] = new Option("Nova Scotia", "NS");
js_e_provinces[0][11] = new Option("Yukon", "YK");
js_e_provinces[0][12] = new Option("Northwest Territories", "NT");
js_e_provinces[0][13] = new Option("Nunavut", "NU");

var js_f_provinces = new Array();
js_f_provinces[0] = new Array();
js_f_provinces[0][0]  = new Option("", "");
js_f_provinces[0][1]  = new Option("Ontario", "ON");
js_f_provinces[0][2]  = new Option("Qubec", "QC");
js_f_provinces[0][3]  = new Option("Alberta", "AB");
js_f_provinces[0][4]  = new Option("Colombie-Britannique", "BC");
js_f_provinces[0][5]  = new Option("Saskatchewan", "SK");
js_f_provinces[0][6]  = new Option("Manitoba", "MB");
js_f_provinces[0][7]  = new Option("Terre-Neuve-et-Labrador", "NF");
js_f_provinces[0][8]  = new Option("Nouveau-Brunswick", "NB");
js_f_provinces[0][9]  = new Option("le-du-Prince-douard", "PE");
js_f_provinces[0][10] = new Option("Nouvelle-cosse", "NS");
js_f_provinces[0][11] = new Option("Yukon", "YK");
js_f_provinces[0][12] = new Option("Territoires du Nord-Ouest", "NT");
js_f_provinces[0][13] = new Option("Nunavut", "NU");

// Used to initially populate the combo boxes.
function populate_boxes()
{
    // Removed - populating from PHP code. Turf in a later release.
    //populateBox(base.weather_lang_in, 0, js_languages, lang);

    if (lang == 'e')
        populateBox(base.weather_province_in, 0, js_e_provinces, sel_prov);
    else if (lang == 'f')
        populateBox(base.weather_province_in, 0, js_f_provinces, sel_prov);
    else if (lang == "") {
        clearcombo(base.weather_province_in);
        clearcombo(base.weather_region_in);
    }

    if (lang != "" && sel_prov != "")
        show_region_list(base.weather_province_in);
}

function populateBox(oBox, nIndex, aArray, sval)
{
    for (var i = 0; i < aArray[nIndex].length; i++)
    {
        oBox.options[oBox.options.length] =
            new Option(aArray[nIndex][i].text, aArray[nIndex][i].value);

        // Highlight the saved option.
        if (sval)
            if (aArray[nIndex][i].value == sval)
                oBox.options[oBox.options.length - 1].selected = true;
    }
}

// Shows the appropriate province list based on language.
function show_province_list(elem)
{
    // Clear the region and province list boxes first.
    var oBox = base.weather_region_in;
    clearcombo(oBox);
    oBox = base.weather_province_in;
    clearcombo(oBox);

    // Clear the user's previously selected provice and region settings.
    sel_prov = "";
    sel_region = "";

    lang = elem[elem.selectedIndex].value;
    
    if (lang == 'e')
        populateBox(oBox, 0, js_e_provinces, sel_prov);
    else if (lang == 'f')
        populateBox(oBox, 0, js_f_provinces, sel_prov);
}

// Shows the region list based on the chosen province.
function show_region_list(elem)
{
    var oBox = base.weather_region_in;
    clearcombo(oBox);

    var province = elem[elem.selectedIndex].value;
    //alert("Province:" + province);

    // Get http page from EC and extract region list. Populate combobox
    // with extracted list (value = code, text = region name).

    // base_uri variable set from options.php
    var url = base_uri + "plugins/weather/get_reg_list.php?" +
              "weather_lang_in=" + lang + "&weather_province_in=" + province;
    //alert("URL:" + url);

    // This statement bombs on IE... probably not needed anyway.
    //xmlhttp.overrideMimeType('text/html');
    xmlhttp.open("GET", url, true);
    xmlhttp.onreadystatechange = useHttpResponse;
    xmlhttp.send(null)
}

// Callback.
function useHttpResponse()
{
    //alert ("state:"+xmlhttp.readyState);

    if (xmlhttp.readyState == 4)
    {
        build_region_list(xmlhttp.responseText);
    }
}

// Acutally builds the region select list.
function build_region_list(response)
{
    //var strLen = response.length;
    //alert("recvd strlen:"+strLen);

    // Need to loop and pull out value pairs of: region code, region name
    // and create new option tags for the weather_region select list.

    var arr_region_data = response.split(",");
    //alert ("arrlen:"+arr_region_data.length);

    // Define a temp variable for shortening subsequent code lines.
    var region = base.weather_region_in;
    
    // Include a blank option to allow the user to disable the plugin.
    region.options[region.options.length] = new Option("", "");

    for (var i = 0; i < arr_region_data.length; i += 2)
    {
        //alert ("optlen:"+region.options.length);
        region.options[region.options.length] =
            new Option(arr_region_data[i+1], arr_region_data[i]);

        // Highlight the saved option.
        if (sel_region)
            if (arr_region_data[i] == sel_region)
                region.options[region.options.length - 1].selected = true;
    }
}

function clearcombo(elem)
{
    var i;
    for (i = elem.options.length; i >= 0; i--) elem.options[i] = null;
    elem.selectedIndex = -1;
}
