<?php

/*******************************************************************************

    Author ....... Jonathan S. Earle
    Contact ...... plugins@kronos.honk.org
    Home Site .... http://kronos.honk.org/~earlej/
    Program ...... Canadian Weather

*******************************************************************************/

include_once(SM_PATH . 'plugins/weather/functions.php');

function squirrelmail_plugin_init_weather()
{
    global $squirrelmail_plugin_hooks;

    $squirrelmail_plugin_hooks['optpage_register_block']['weather'] = 'weather_opt';
    $squirrelmail_plugin_hooks["options_save"]["weather"] = "weather_save_options";
    $squirrelmail_plugin_hooks['optpage_set_loadinfo']['weather'] = 'weather_set_loadinfo';
    $squirrelmail_plugin_hooks['generic_header']['weather'] = 'weather_generic_header';
    $squirrelmail_plugin_hooks["left_main_before"]["weather"] = "weather_show_above";
    $squirrelmail_plugin_hooks["left_main_after"]["weather"] = "weather_show_below";
    $squirrelmail_plugin_hooks["loading_prefs"]["weather"] = "weather_load_options";

    return;
}

function weather_opt()
{
    global $optpage_blocks;

    /* Register Squirrelspell with the $optionpages array. */
    $optpage_blocks[] = array(
        'name' => _("Canadian Weather"),
        'url'  => SM_PATH . 'plugins/weather/options.php',
        'desc' => _("Here you can configure the Canadian Weather plugin."),
        'js'   => false
    );
}

// Puts a little msg at the top of the options page indicating we've saved our settings.
function weather_set_loadinfo()
{
    global $optpage, $optpage_name;
    if ($optpage=='weather') {
        $optpage_name=_("Canadian Weather");
    }
}

// New requirement for returning plugin version and other info.
function weather_info()
{
    // Defaults.. will be overridden by contents of 'version' file.
    $name = "Canadian Weather";
    $version = "3.2.0";

    // Load the name and version from the version file so we only maintain 
    // the info in one place.
    $handle = fopen( SM_PATH . 'plugins/weather/version', 'r' );
    if (isset($handle))
    {
        $contents = fread($handle,
                          filesize(SM_PATH . 'plugins/weather/version'));
        $pattern = "/(.*)\n(.*)/";
        // Get the plugin name.
        $name = preg_replace($pattern, "$1", $contents);
        // Get the plugin version.
        $version = preg_replace($pattern, "$2", $contents);
        fclose($handle);
    }

    return array(
                  'english_name' => $name,
                  'version' => $version,
                  'required_sm_vesion' => '1.4.0', 
                  'summary' => 'Displays Canadian Weather in the folder list frame.',
                  'details' => 'This plugin will retrieve and display weather information ' .
                               'from Environment Canada and display a formatted weather ' .
                               'info block above or below the folder list.',
                  'requires_configuration' => 0,
                  'requires_source_patch' => 0,
                );
}

// Return version number as required by plugin developer docs.
function weather_version()
{
    $info = weather_info();
    return $info['version'];
}

// Load stylesheets which are the primary formatting tools for the EC weather site.
function weather_generic_header()
{
    // Copied from functions/page_header.php
    if ( !sqgetGlobalVar('base_uri', $base_uri, SQ_SESSION) ) {
        global $base_uri;
    }

    // The stylesheet is really only needed in the folder list frame.
    echo "\n<link rel=\"stylesheet\" type=\"text/css\" href=\"" . $base_uri . 
         "plugins/weather/weather.css\" />\n";

    // Commenting this out for now due to the workaround for the IE display
    // issue. Just need the one stylesheet at this time, but who knows what
    // future versions of Mozilla/IE will bring to the table. ;)
    if (0) {
    echo "\n<!--[if IE]><![if gte IE 7]><![endif]--><style type=\"text/css\">/*\*/ " .
         "@import url(\"" . $base_uri . "plugins/weather/weather.css\") all; " .
         "/**/</style><!--[if IE]><![endif]><![endif]--><!-- standard stylesheet -->\n";
    echo "<!--[if lte IE 7]><link href=\"" . $base_uri . "plugins/weather/weather_ie.css\" " .
         "rel=\"stylesheet\" type=\"text/css\" /><![endif]--><!-- win ie stylesheet -->\n";
    echo "<style type=\"text/css\">/*\*//*/ @import url(\"" .
         $base_uri . "plugins/weather/weather_ie_mac.css\");/**/</style>" .
         "<!-- mac ie stylesheet -->\n";
    }

    // These could be moved into options.php if they can be inserted into the
    // header in that page only.
    echo "<script src=\"" . $base_uri . "plugins/weather/xhr_load.js\" " .
         "type=\"text/javascript\"></script>\n";
    echo "<script src=\"" . $base_uri . "plugins/weather/weather.js\" " .
         "type=\"text/javascript\"></script>\n";
}

function weather_show_above()
{
    weather_show_above_do();
}

function weather_show_below()
{
    weather_show_below_do();
}

function weather_save_options()
{
    weather_save_options_do();
}

function weather_load_options()
{
    weather_load_options_do();
}

?>
